/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.model.project;

import com.intel.sensing.fdk.common.exceptions.ExceptionHandler;
import com.intel.sensing.fdk.common.exceptions.ISSError;
import com.intel.sensing.fdk.common.exceptions.ISSException;
import com.intel.sensing.fdk.common.log.ISSLogger;
import com.intel.sensing.fdk.common.utils.CUtils;
import com.intel.sensing.fdk.model.abstractData.Version;
import com.intel.sensing.fdk.model.entity.ModuleEntity;
import com.intel.sensing.fdk.model.entity.ProjectEntity;
import com.intel.sensing.fdk.model.entity.SelectedItemsDataEntity;
import com.intel.sensing.fdk.model.entity.SensorDataEntity;
import com.intel.sensing.fdk.model.project.AISSProject;
import com.intel.sensing.fdk.model.project.AValidateStep;
import com.intel.sensing.fdk.model.project.ModuleJsonFileCheker;
import com.intel.sensing.fdk.model.project.ProjectJsonFileCheker;
import com.intel.sensing.fdk.model.project.SelectJsonFileCheker;
import com.intel.sensing.fdk.model.project.SensorJsonFileCheker;
import com.intel.sensing.fdk.model.service.PersistenceService;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class ISSProject
extends AISSProject {
    private List<AValidateStep> fullSteps;
    private AValidateStep fValidateProectJsonFileExistedStep;
    private AValidateStep fValidateProjectJsonFileStep;
    private AValidateStep fValidateSelectJsonFileExistedStep;
    private AValidateStep fValidateSelectedSensorJsonFile;
    private AValidateStep fUnkonwExceptionStep;
    private AValidateStep fValidateFirmwareStep;
    private AValidateStep fValidateSelectedSensors;

    public ISSProject(IProject project) {
        super(project);
        try {
            this.initializeValidateSteps();
            this.resetAll();
            this.validate();
        }
        catch (Exception e) {
            ISSLogger.e((Exception)e);
        }
    }

    public void reLoad() throws Exception {
        ProjectEntity original = new ProjectEntity(this.fProjectEntity);
        this.init();
        this.resetAll();
        this.validate();
        this.handlePlatformChanges(original);
    }

    @Override
    public void validate() {
        this.fullSteps.forEach(step -> step.execute());
    }

    public void resetAll() throws CoreException {
        this.fullSteps.forEach(step -> step.reset());
        this.fProject.deleteMarkers(AValidateStep.MARKER_ID, false, 0);
    }

    private void initializeValidateSteps() throws IOException {
        this.fullSteps = new ArrayList<AValidateStep>();
        this.fValidateProectJsonFileExistedStep = new ValidateProjectJsonFileExisted((IResource)this.fProject.getFile("project.json"));
        this.fullSteps.add(this.fValidateProectJsonFileExistedStep);
        this.fValidateProjectJsonFileStep = new ValidateProjectJsonFile((IResource)this.fProject.getFile("project.json"));
        this.fullSteps.add(this.fValidateProjectJsonFileStep);
        this.fValidateSelectJsonFileExistedStep = new ValidateSelectedJsonFileExisted((IResource)this.fProject.getFile("selected_sensors.json"));
        this.fullSteps.add(this.fValidateSelectJsonFileExistedStep);
        this.fValidateSelectedSensorJsonFile = new ValidateSelectedSensorJsonFile((IResource)this.fProject.getFile("selected_sensors.json"));
        this.fullSteps.add(this.fValidateSelectedSensorJsonFile);
        this.fValidateFirmwareStep = new ValidateFirmwareStep((IResource)this.fProject);
        this.fullSteps.add(this.fValidateFirmwareStep);
        this.fValidateSelectedSensors = new ValidateSelectedSensorsStep((IResource)this.fProject);
        this.fullSteps.add(this.fValidateSelectedSensors);
        String modulePath = String.valueOf(this.fProjectPath) + File.separator + "modules";
        Path path = Path.of(modulePath, new String[0]);
        Throwable throwable = null;
        Object var4_5 = null;
        try (Stream<Path> paths = Files.walk(path, 2, new FileVisitOption[0]);){
            List moduleStrList = paths.filter(file -> file.toFile().exists() && file.toFile().isDirectory() && file.resolve("module.json").toFile().exists()).map(file -> file.resolve("module.json").toAbsolutePath().toString()).collect(Collectors.toList());
            for (String jsonPath : moduleStrList) {
                String relative = CUtils.getRelativePath((String)jsonPath, (String)this.fProject.getLocation().toOSString());
                IFile jsonFile = this.fProject.getFile(relative);
                ValidateModuleStep step = new ValidateModuleStep((IResource)jsonFile);
                this.fullSteps.add(step);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public boolean isFirmwareSupported() {
        if (this.fValidateFirmwareStep != null) {
            return !this.fValidateFirmwareStep.hasErrors();
        }
        return true;
    }

    public void handleUnknownException(ISSException e) {
        ISSError err = new ISSError(ISSError.Severity.ERROR, 0, ExceptionHandler.parseException((Exception)((Object)e)), (IResource)this.fProject);
        this.fUnkonwExceptionStep.addError(err);
    }

    public boolean hasProjectJsonFataError() {
        Boolean ret = true;
        if (this.fValidateProectJsonFileExistedStep != null) {
            ret = this.fValidateProectJsonFileExistedStep.hasFatalErrors();
        }
        if (this.fValidateProjectJsonFileStep != null) {
            ret = ret & this.fValidateProjectJsonFileStep.hasFatalErrors();
        }
        return ret;
    }

    public boolean hasFatalErrors() {
        return this.getFirstFatalError() != null;
    }

    public boolean hasErrors() {
        if (this.getAllIssues().isEmpty()) {
            return false;
        }
        return this.getAllIssues().stream().anyMatch(err -> err.getSeverity() == ISSError.Severity.ERROR);
    }

    public ISSError getFirstFatalError() {
        return this.getAllIssues().stream().filter(err -> err.getSeverity() == ISSError.Severity.FATAL).findFirst().orElse(null);
    }

    public List<ISSError> getAllIssues() {
        return this.fullSteps.stream().flatMap(step -> step.getAllIssues().stream()).collect(Collectors.toList());
    }

    public boolean needUpdate() {
        return !this.isFirmwareSupported();
    }

    public void fixErrors() {
        if (!this.isFirmwareSupported()) {
            this.UpgradeFirmwareSlience();
            this.fSelectMgr.reInit(this.fProjectEntity, this.fUserModuleMgr.getUserModules());
        }
        this.validate();
    }

    public void validateSelectSensors() {
        this.fValidateSelectedSensors.execute();
    }

    public class UnKnowException
    extends AValidateStep {
        public UnKnowException(IResource res) {
            super(res);
        }

        @Override
        public void run() {
        }
    }

    public class ValidateFirmwareStep
    extends AValidateStep {
        public ValidateFirmwareStep(IResource res) {
            super(res);
        }

        @Override
        public void run() {
            if (ISSProject.this.fProjectEntity == null) {
                return;
            }
            String plat = ISSProject.this.fProjectEntity.getPlatform();
            Version fw = ISSProject.this.fProjectEntity.getFwVersionInData();
            boolean supportPlat = plat == null ? false : PersistenceService.getAvailablePlatform().contains(plat);
            boolean supportVer = false;
            if (supportPlat) {
                supportVer = PersistenceService.getAvailableKitVersionByPlatform(plat).contains(fw);
                if (!supportVer) {
                    ISSError error = new ISSError(ISSError.Severity.ERROR, 16, "Project's firmware version isn't installed.", this.getResource());
                    this.addError(error);
                }
            } else {
                ISSError error = new ISSError(ISSError.Severity.ERROR, 16, "Project's platform isn't supported.", this.getResource());
                this.addError(error);
            }
        }
    }

    public class ValidateModuleStep
    extends AValidateStep {
        public ValidateModuleStep(IResource res) {
            super(res);
        }

        @Override
        public void run() {
            ModuleEntity me;
            IFile file = (IFile)this.getResource();
            if (file == null || !file.exists()) {
                ISSError error = new ISSError(ISSError.Severity.FATAL, 4, "Missing module.json.", (IResource)this.getResource().getParent());
                this.addError(error);
                return;
            }
            List<ISSError> err = new ModuleJsonFileCheker().check(file);
            err.forEach(e -> this.addError((ISSError)e));
            String name = file.getName();
            if (ISSProject.this.fUserModuleMgr != null && (me = ISSProject.this.fUserModuleMgr.getModuleByName(name)) != null && me.isSensor().booleanValue()) {
                IFile sensorFile = (IFile)file.getParent().findMember("sensor.json");
                if (sensorFile == null || !sensorFile.exists()) {
                    ISSError error = new ISSError(ISSError.Severity.FATAL, 4, "Missing sensor.json.", (IResource)this.getResource().getParent());
                    this.addError(error);
                    return;
                }
                List<ISSError> sensorerrs = new SensorJsonFileCheker().check(sensorFile);
                sensorerrs.forEach(e -> this.addError((ISSError)e));
            }
        }
    }

    public class ValidateProjectJsonFile
    extends AValidateStep {
        public ValidateProjectJsonFile(IResource res) {
            super(res);
        }

        @Override
        public void run() {
            IFile file = (IFile)this.getResource();
            if (file != null && file.exists()) {
                List<ISSError> err = new ProjectJsonFileCheker().check(file);
                err.forEach(e -> this.addError((ISSError)e));
            }
        }
    }

    public class ValidateProjectJsonFileExisted
    extends AValidateStep {
        public ValidateProjectJsonFileExisted(IResource res) {
            super(res);
        }

        @Override
        public void run() {
            IFile file = (IFile)this.getResource();
            if (file == null || !file.exists()) {
                ISSError error = new ISSError(ISSError.Severity.FATAL, 1, "Missing project.json.", (IResource)this.getResource().getProject());
                this.addError(error);
            }
        }
    }

    public class ValidateSelectedJsonFileExisted
    extends AValidateStep {
        public ValidateSelectedJsonFileExisted(IResource res) {
            super(res);
        }

        @Override
        public void run() {
            IFile file = (IFile)this.getResource();
            if (file == null || !file.exists()) {
                ISSError error = new ISSError(ISSError.Severity.FATAL, 2, "Missing selected_sensors.json.", (IResource)this.getResource().getProject());
                this.addError(error);
            }
        }
    }

    public class ValidateSelectedSensorJsonFile
    extends AValidateStep {
        public ValidateSelectedSensorJsonFile(IResource res) {
            super(res);
        }

        @Override
        public void run() {
            IFile file = (IFile)this.getResource();
            if (file != null && file.exists() && file != null && file.exists()) {
                List<ISSError> err = new SelectJsonFileCheker().check(file);
                err.forEach(e -> this.addError((ISSError)e));
            }
        }
    }

    public class ValidateSelectedSensorsStep
    extends AValidateStep {
        public ValidateSelectedSensorsStep(IResource res) {
            super(res);
        }

        @Override
        public void run() {
            if (ISSProject.this.fProjectEntity == null || ISSProject.this.fSelectMgr == null) {
                return;
            }
            List<SelectedItemsDataEntity> sensorDataList = ISSProject.this.fSelectMgr.getSelectedItems();
            if (sensorDataList.size() <= 1) {
                return;
            }
            int i = 0;
            while (i < sensorDataList.size()) {
                int j = i + 1;
                while (j < sensorDataList.size()) {
                    SensorDataEntity sd2;
                    SensorDataEntity sd1;
                    SelectedItemsDataEntity s1 = sensorDataList.get(i);
                    SelectedItemsDataEntity s2 = sensorDataList.get(j);
                    if (s1.getModuleEntity().getName().equalsIgnoreCase(s2.getModuleEntity().getName()) && s1.getModuleEntity() != s2.getModuleEntity()) {
                        ISSError error = new ISSError(ISSError.Severity.ERROR, 192, "Project selects more than one modules with same name: " + s1.getModuleEntity().getName(), this.getResource());
                        this.addError(error);
                    } else if (s1 instanceof SensorDataEntity && s2 instanceof SensorDataEntity && (sd1 = (SensorDataEntity)s1).equalsIgnoreTag(sd2 = (SensorDataEntity)s2)) {
                        ISSError error = new ISSError(ISSError.Severity.ERROR, 192, "Project selects more than one sensors with same LUID: " + sd1.getSensorName(), this.getResource());
                        this.addError(error);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }
}

