/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.model.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.intel.sensing.fdk.common.ManagerEnums;
import com.intel.sensing.fdk.model.entity.AbstractEntity;
import com.intel.sensing.fdk.model.entity.ModuleEntity;
import com.intel.sensing.fdk.model.entity.SelectedItemsDataEntity;
import com.intel.sensing.fdk.model.entity.SensorBundleEntity;
import com.intel.sensing.fdk.model.entity.SensorDataEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SelectedSensorsEntity
extends AbstractEntity {
    @JsonProperty(value="sensortable")
    private List<String> sensortable = new ArrayList<String>();
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    @JsonIgnore
    private List<SelectedItemsDataEntity> selectItemList = new ArrayList<SelectedItemsDataEntity>();

    public SelectedSensorsEntity() {
    }

    public SelectedSensorsEntity(String jsonFilePath) {
        super(jsonFilePath);
    }

    @JsonProperty(value="sensortable")
    public List<String> getSensortable() {
        return this.sensortable;
    }

    @JsonProperty(value="sensortable")
    public void setSensortable(List<String> sensortable) {
        this.sensortable = sensortable;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @JsonIgnore
    public boolean contains(Object sensorDataEntity) {
        return this.selectItemList.contains(sensorDataEntity);
    }

    @JsonIgnore
    public boolean containsAll(List<SelectedItemsDataEntity> sensors) {
        return this.selectItemList.containsAll(sensors);
    }

    @JsonIgnore
    public boolean containsAny(List<SelectedItemsDataEntity> sensors) {
        return sensors.stream().filter(sensorData -> this.selectItemList.contains(sensorData)).findAny().isPresent();
    }

    @JsonIgnore
    public void addSensorIfNotExist(List<SelectedItemsDataEntity> sensors) {
        List complementSensors = sensors.stream().filter(sensor -> !this.selectItemList.contains(sensor)).collect(Collectors.toList());
        this.selectItemList.addAll(complementSensors);
        this.updateSensorTable();
    }

    @JsonIgnore
    public void removeSensorIfExist(List<SelectedItemsDataEntity> sensors) {
        List redundantSensors = sensors.stream().filter(sensor -> this.selectItemList.contains(sensor)).collect(Collectors.toList());
        this.selectItemList.removeAll(redundantSensors);
        this.updateSensorTable();
    }

    @JsonIgnore
    public void addSelectItem(SelectedItemsDataEntity sensorData) {
        if (!this.selectItemList.contains(sensorData)) {
            this.selectItemList.add(sensorData);
            this.updateSensorTable();
        }
    }

    @JsonIgnore
    public void removeSelectItem(Object sensorData) {
        this.selectItemList.remove(sensorData);
        this.updateSensorTable();
    }

    @JsonIgnore
    public List<SelectedItemsDataEntity> getSelectedItems() {
        return this.selectItemList;
    }

    @JsonIgnore
    public void setSelectItems(List<SelectedItemsDataEntity> items) {
        this.selectItemList = items;
        this.updateSensorTable();
    }

    public void updateSensorTable() {
        List selectedSensorList = this.selectItemList.stream().filter(item -> item instanceof SensorDataEntity).map(item -> (SensorDataEntity)item).collect(Collectors.toList());
        Map<SensorBundleEntity, List<SensorDataEntity>> sensorBundleMap = selectedSensorList.stream().collect(Collectors.groupingBy(SensorDataEntity::getSensorBundleEntity));
        ArrayList<String> newSensorTable = new ArrayList<String>();
        sensorBundleMap.forEach((bundle, sensors) -> {
            String sensorStr = sensors.stream().map(sensorData -> sensorData.getSensorName()).collect(Collectors.joining(";"));
            String bundleStr = "";
            bundleStr = bundle.getModuleEntity().getIssModuleTags().equals((Object)ManagerEnums.ISSModuleTags.INSTALLED) ? String.valueOf(bundle.getModuleEntity().getPackageName()) + "/" + "lib" + "/" + bundle.getModuleEntity().getName() + " " + "@" + bundle.getModuleEntity().getIssModuleTags() + " " + "@SELECTED" + "[" + sensorStr + "]" : "modules/sensors/" + bundle.getModuleEntity().getName() + " " + "@" + bundle.getModuleEntity().getIssModuleTags() + " " + "@SELECTED" + "[" + sensorStr + "]";
            newSensorTable.add(bundleStr);
        });
        List selectedLibraryList = this.selectItemList.stream().filter(item -> item instanceof ModuleEntity).map(item -> (ModuleEntity)item).collect(Collectors.toList());
        selectedLibraryList.stream().forEach(libraryitem -> {
            String bundleStr = "";
            bundleStr = libraryitem.getIssModuleTags().equals((Object)ManagerEnums.ISSModuleTags.INSTALLED) ? String.valueOf(libraryitem.getModuleEntity().getPackageName()) + "/" + "lib" + "/" + libraryitem.getName() + " " + "@" + libraryitem.getIssModuleTags() : "modules/libs/" + libraryitem.getName() + " " + "@" + libraryitem.getIssModuleTags();
            newSensorTable.add(bundleStr);
        });
        this.sensortable = newSensorTable;
    }

    public void sync(SelectedSensorsEntity selectSensors) {
        this.selectItemList.clear();
        this.selectItemList = selectSensors.getSelectedItems();
        this.updateSensorTable();
    }
}

