/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor;

import binTools.BinReader;
import binTools.BinWriter;
import binTools.Common;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pdtEditor.BoardDescriptionTable;
import pdtEditor.exceptions.FeatureNotSupportedYetException;

public class FormFactorTable
extends BoardDescriptionTable {
    public static final int BDT_TYPE = 2;
    private static final int LATEST_FORMAT_ID = 1;
    private static final int MANUAL_ADVANCED_CONFIG_FLAG = 0;
    private static final AdvancedConfiguration DEFAULT_ADVANCED_CONFIG_TWO_IN_ONE = new AdvancedConfiguration(360, HingeLocation.BOTTOM, ScreenLocation.INTERIOR);
    private static final AdvancedConfiguration DEFAULT_ADVANCED_CONFIG_KICKSTAND = new AdvancedConfiguration(180, HingeLocation.LEFT, ScreenLocation.EXTERIOR);
    private static final AdvancedConfiguration DEFAULT_ADVANCED_CONFIG_SWIVEL = new AdvancedConfiguration(0, HingeLocation.BOTTOM, ScreenLocation.INTERIOR);
    private static final AdvancedConfiguration DEFAULT_ADVANCED_CONFIG_TABLET = new AdvancedConfiguration(0, HingeLocation.NA, ScreenLocation.NA);
    private static final AdvancedConfiguration DEFAULT_ADVANCED_CONFIG_CLAMSHELL = new AdvancedConfiguration(0, HingeLocation.NA, ScreenLocation.NA);
    private static final AdvancedConfiguration DEFAULT_ADVANCED_CONFIG_MID = new AdvancedConfiguration(360, HingeLocation.BOTTOM, ScreenLocation.INTERIOR);
    private int _formatId = 1;
    private FormFactorType _formFactorType = FormFactorType.TWO_IN_ONE;
    private AdvancedConfiguration _advancedConfiguration = null;

    public FormFactorTable() {
        this.setType(2);
    }

    public FormFactorTable(BinReader reader, Element payloadXmlNode) throws FeatureNotSupportedYetException {
        this.setType(2);
        this._formatId = reader.readNewField((String)"Format", (int)1, (boolean)false, (Node)payloadXmlNode).value;
        if (this._formatId > 1) {
            throw new FeatureNotSupportedYetException(this);
        }
        Element formFactorElement = reader.readNewField((String)"FormFactor", (Node)payloadXmlNode).xmlElement;
        this._formFactorType = FormFactorType.getFormFactor(reader.readNewField((String)"Type", (int)1, (boolean)false, (Node)formFactorElement).value);
        if (this._formatId >= 1) {
            boolean manualAdvancedConfig = (reader.readNewField((String)"Flags", (int)1, (boolean)false, (Node)formFactorElement).value & 1) > 0;
            Element advancedConfigurationElement = reader.readNewField((String)"AdvancedConfiguration", (Node)formFactorElement).xmlElement;
            AdvancedConfiguration advancedConfig = new AdvancedConfiguration(reader.readNewField((String)"MaxHingeAngle", (int)2, (boolean)false, (Node)advancedConfigurationElement).value, HingeLocation.getHingeConnection(reader.readNewField((String)"HingeConnection", (int)1, (boolean)false, (Node)advancedConfigurationElement).value), ScreenLocation.getClosingDirection(reader.readNewField((String)"ClosingDirection", (int)1, (boolean)false, (Node)advancedConfigurationElement).value));
            this._advancedConfiguration = manualAdvancedConfig ? advancedConfig : null;
        }
        this._formatId = 1;
    }

    public static AdvancedConfiguration getDefaultAdvancedConfigOfType(FormFactorType type) {
        switch (type) {
            case TWO_IN_ONE: {
                return DEFAULT_ADVANCED_CONFIG_TWO_IN_ONE;
            }
            case KICKSTAND: {
                return DEFAULT_ADVANCED_CONFIG_KICKSTAND;
            }
            case SWIVEL: {
                return DEFAULT_ADVANCED_CONFIG_SWIVEL;
            }
            case TABLET: {
                return DEFAULT_ADVANCED_CONFIG_TABLET;
            }
            case CLAMSHELL: {
                return DEFAULT_ADVANCED_CONFIG_CLAMSHELL;
            }
            case MID: {
                return DEFAULT_ADVANCED_CONFIG_MID;
            }
        }
        return null;
    }

    @Override
    public void writeToPdt(BinWriter writer, Element parent) {
        writer.writeNewField("Type", 1, this.getType(), (Node)parent);
        Common.Field lengthField = writer.writeNewField("Length", 2, 0, (Node)parent);
        writer.addSizeCounter(lengthField);
        writer.writeNewField("Format", 1, this._formatId, (Node)parent);
        Element formFactorElement = writer.writeNewField((String)"FormFactor", (Node)parent).xmlElement;
        writer.writeNewField("Type", 1, this._formFactorType.getValue(), (Node)formFactorElement);
        if (this._formatId >= 1) {
            AdvancedConfiguration advancedConfiguration;
            byte flags = 0;
            flags = (byte)(flags | (this._advancedConfiguration != null ? 1 : 0));
            writer.writeNewField("Flags", 1, flags, (Node)formFactorElement);
            AdvancedConfiguration advancedConfiguration2 = advancedConfiguration = this._advancedConfiguration != null ? this._advancedConfiguration : FormFactorTable.getDefaultAdvancedConfigOfType(this._formFactorType);
            if (advancedConfiguration != null) {
                Element advancedConfigurationElement = writer.writeNewField((String)"AdvancedConfiguration", (Node)formFactorElement).xmlElement;
                writer.writeNewField("MaxHingeAngle", 2, advancedConfiguration.maxHingeAngle, (Node)advancedConfigurationElement);
                writer.writeNewField("HingeConnection", 1, advancedConfiguration.hingeLocation.getValue(), (Node)advancedConfigurationElement);
                writer.writeNewField("ClosingDirection", 1, advancedConfiguration.screenLocation.getValue(), (Node)advancedConfigurationElement);
            }
        }
        writer.removeSizeCounter(lengthField);
    }

    public FormFactorType getFormFactorType() {
        return this._formFactorType;
    }

    public void setFormFactorType(FormFactorType formFactorType) {
        this._formFactorType = formFactorType;
    }

    public AdvancedConfiguration getAdvancedConfiguration() {
        return this._advancedConfiguration;
    }

    public void setAdvancedConfiguration(AdvancedConfiguration advancedConfiguration) {
        this._advancedConfiguration = advancedConfiguration;
    }

    public static class AdvancedConfiguration {
        public static final int MAX_HINGE_ANGLE_MAX_VALUE = 360;
        public int maxHingeAngle = 0;
        public HingeLocation hingeLocation = null;
        public ScreenLocation screenLocation = null;

        public AdvancedConfiguration(int maxHingeAngle, HingeLocation hingeLocation, ScreenLocation screenLocation) {
            this.maxHingeAngle = maxHingeAngle;
            this.hingeLocation = hingeLocation;
            this.screenLocation = screenLocation;
        }
    }

    public static enum ScreenLocation {
        INTERIOR(0, "Interior"),
        EXTERIOR(1, "Exterior"),
        NA(2, "N/A");

        int _value;
        String _friendlyName;

        private ScreenLocation(int value, String friendlyName) {
            this._value = value;
            this._friendlyName = friendlyName;
        }

        public int getValue() {
            return this._value;
        }

        public String getFriendlyName() {
            return this._friendlyName;
        }

        public static ScreenLocation getClosingDirection(Integer value) {
            if (value == null || value < 0 || value >= ScreenLocation.values().length) {
                return null;
            }
            for (ScreenLocation curr : ScreenLocation.values()) {
                if (curr.getValue() != value.intValue()) continue;
                return curr;
            }
            return null;
        }

        public static ScreenLocation getClosingDirection(String friendlyName) {
            if (friendlyName == null) {
                return null;
            }
            for (ScreenLocation cadidate : ScreenLocation.values()) {
                if (!cadidate.getFriendlyName().equals(friendlyName)) continue;
                return cadidate;
            }
            throw new RuntimeException("No match.");
        }
    }

    public static enum HingeLocation {
        BOTTOM(0, "Bottom"),
        TOP(1, "Top"),
        LEFT(2, "Left"),
        RIGHT(3, "Right"),
        NA(4, "N/A");

        int _value;
        String _friendlyName;

        private HingeLocation(int value, String friendlyName) {
            this._value = value;
            this._friendlyName = friendlyName;
        }

        public int getValue() {
            return this._value;
        }

        public String getFriendlyName() {
            return this._friendlyName;
        }

        public static HingeLocation getHingeConnection(Integer value) {
            if (value == null || value < 0 || value >= HingeLocation.values().length) {
                return null;
            }
            for (HingeLocation curr : HingeLocation.values()) {
                if (curr.getValue() != value.intValue()) continue;
                return curr;
            }
            return null;
        }

        public static HingeLocation getHingeConnection(String friendlyName) {
            if (friendlyName == null) {
                return null;
            }
            for (HingeLocation cadidate : HingeLocation.values()) {
                if (!cadidate.getFriendlyName().equals(friendlyName)) continue;
                return cadidate;
            }
            throw new RuntimeException("No match.");
        }
    }

    public static enum FormFactorType {
        TWO_IN_ONE(0, "2-In-1"),
        KICKSTAND(1, "Kickstand"),
        SWIVEL(2, "Swivel"),
        TABLET(3, "Tablet"),
        CLAMSHELL(4, "Clamshell"),
        MID(5, "MID");

        int _value;
        String _friendlyName;

        private FormFactorType(int value, String friendlyName) {
            this._value = value;
            this._friendlyName = friendlyName;
        }

        public int getValue() {
            return this._value;
        }

        public String getFriendlyName() {
            return this._friendlyName;
        }

        public static FormFactorType getFormFactor(Integer value) {
            if (value == null || value < 0 || value >= FormFactorType.values().length) {
                return null;
            }
            for (FormFactorType curr : FormFactorType.values()) {
                if (curr.getValue() != value.intValue()) continue;
                return curr;
            }
            return null;
        }

        public static FormFactorType getFormFactor(String friendlyName) {
            if (friendlyName == null) {
                return null;
            }
            for (FormFactorType cadidate : FormFactorType.values()) {
                if (!cadidate.getFriendlyName().equals(friendlyName)) continue;
                return cadidate;
            }
            throw new RuntimeException("No match.");
        }
    }
}

