@echo off
SetLocal EnableDelayedExpansion

REM ##############################################
REM Checks the Settings file of the package is 
REM already added to the system.
REM ##############################################

REM ##############################################
REM Compare the ServiceSettings.json file in the 
REM system with the one in the package.
REM If there are no differences then the settings
REM file is successfully added to the system. 
REM ##############################################


fc "C:\Windows\ServiceProfiles\LocalService\AppData\Roaming\Intel(R)\ICST\settings\ServiceSettings.json" "%~dp0Drivers\ServiceSettings.json"

SET isInstalled=%errorlevel%

REM ##############################################
REM If errorlevel is 0 then the settings file is  
REM successfully added to the system.
REM If errorlevel is 1 then the settings file is  
REM not successfully added to the system.
REM ##############################################


IF %isInstalled% EQU 0 (
echo "ICST Service Settings file is installed."
) ELSE (
echo "ICST Service Settings file is NOT installed."
)

exit /b %isInstalled%



