/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.model.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.intel.sensing.fdk.common.utils.ManagerFileUtils;
import com.intel.sensing.fdk.model.abstractData.Version;
import com.intel.sensing.fdk.model.entity.AbstractEntity;
import com.intel.sensing.fdk.model.entity.CompileEntity;
import com.intel.sensing.fdk.model.entity.FwEntity;
import com.intel.sensing.fdk.model.entity.ProjectConfigFileEntity;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ProjectEntity
extends AbstractEntity {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="version")
    private String version;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="vendor")
    private String vendor;
    @JsonProperty(value="arch")
    private String arch;
    @JsonProperty(value="platform")
    private String platform;
    @JsonProperty(value="fw")
    private FwEntity fw;
    @JsonProperty(value="fw_version")
    private String fwVersion;
    @JsonProperty(value="config")
    private ProjectConfigFileEntity config;
    @JsonProperty(value="dependencies")
    private List<String> dependencies = null;
    @JsonProperty(value="compile")
    private CompileEntity compile;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public ProjectEntity() {
        this.setDefaultValue();
    }

    public ProjectEntity(String jsonFilePath) {
        super(jsonFilePath);
        this.setDefaultValue();
    }

    public ProjectEntity(ProjectEntity another) {
        this.sync(another);
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(String version) {
        this.version = version;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="vendor")
    public String getVendor() {
        return this.vendor;
    }

    @JsonProperty(value="vendor")
    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    @JsonProperty(value="arch")
    public String getArch() {
        return this.arch;
    }

    @JsonProperty(value="arch")
    public void setArch(String arch) {
        this.arch = arch;
    }

    @JsonProperty(value="platform")
    public String getPlatform() {
        return this.platform;
    }

    @JsonProperty(value="platform")
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    @JsonProperty(value="fw_version")
    public String getFwVersion() {
        if (this.fwVersion == null) {
            this.fwVersion = Version.emptyVersion.toString();
        }
        return this.fwVersion;
    }

    @JsonProperty(value="fw_version")
    public void setFwVersion(String fwVersion) {
        this.fwVersion = fwVersion;
    }

    @JsonIgnore
    public Version getFwVersionInData() {
        return Version.parseVersion(this.fwVersion);
    }

    @JsonIgnore
    public void setFWVersion(Version version) {
        this.fwVersion = version.toString();
    }

    @JsonProperty(value="fw")
    public FwEntity getFw() {
        return this.fw;
    }

    @JsonProperty(value="fw")
    public void setFw(FwEntity fw) {
        this.fw = fw;
    }

    @JsonProperty(value="config")
    public ProjectConfigFileEntity getConfig() {
        return this.config;
    }

    @JsonProperty(value="config")
    public void setConfig(ProjectConfigFileEntity config) {
        this.config = config;
    }

    @JsonProperty(value="dependencies")
    public List<String> getDependencies() {
        return this.dependencies;
    }

    @JsonProperty(value="dependencies")
    public void setDependencies(List<String> dependencies) {
        this.dependencies = dependencies;
    }

    @JsonProperty(value="compile")
    public CompileEntity getCompile() {
        return this.compile;
    }

    @JsonProperty(value="compile")
    public void setCompile(CompileEntity compile) {
        this.compile = compile;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @JsonIgnore
    private void setDefaultValue() {
        ProjectConfigFileEntity config = new ProjectConfigFileEntity();
        config.setSensorConfig("sensor_plat.cmake");
        config.setInFile("config/project_config.h.in");
        config.setConfigFile("config/ish_default_config.json");
        this.setConfig(config);
        FwEntity fw = new FwEntity();
        fw.setAon("aon_task");
        fw.setImage("ish_$ENV{PLATFORM}");
        fw.setKernel("kernel");
        this.setFw(fw);
        CompileEntity ce = new CompileEntity();
        ArrayList<String> cflags = new ArrayList<String>();
        cflags.add("-DTRACE_CATALOG=0");
        ce.setCflags(cflags);
        this.setCompile(ce);
    }

    @JsonIgnore
    public Path getProjectRootFolder() {
        return this.getAbsoluteParentFolder().toPath();
    }

    @JsonIgnore
    public Path getModuleFolder() {
        return ManagerFileUtils.appendPath((Path)this.getProjectRootFolder(), (String)"modules");
    }

    @JsonIgnore
    public Path getSensorFolder() {
        return ManagerFileUtils.appendPath((Path)this.getModuleFolder(), (String)"sensors");
    }

    public void sync(ProjectEntity data) {
        this.arch = data.arch;
        this.compile = data.compile;
        this.config = data.config;
        this.dependencies = data.dependencies;
        this.description = data.description;
        this.fw = data.fw;
        this.fwVersion = data.fwVersion;
        this.platform = data.platform;
        this.vendor = data.vendor;
        this.version = data.version;
    }
}

