/*
 * Decompiled with CFR 0.152.
 */
package manager.project;

import java.io.File;
import manager.utils.ManagerEnums;
import manager.utils.ManagerFileUtils;
import manager.utils.ManagerXMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GeneralSettings {
    private static GeneralSettings instance;
    private ManagerEnums.SettingsPrompt saveBeforeBuild;
    private boolean validatePdtRun;
    private boolean showMediumWarnings;
    private boolean runTroubleshooterBeforeBuild;
    private boolean runTroubleshooterBeforeRunDebug;

    private GeneralSettings() {
        this.resetSettings();
    }

    public static GeneralSettings getInstance() {
        if (instance == null) {
            instance = new GeneralSettings();
        }
        return instance;
    }

    public ManagerEnums.SettingsPrompt isSaveBeforeBuild() {
        return this.saveBeforeBuild;
    }

    public ManagerEnums.SettingsPrompt isSaveBeforeBuildDefaultValue() {
        return ManagerEnums.SettingsPrompt.Prompt;
    }

    public void setSaveBeforeBuild(ManagerEnums.SettingsPrompt saveBeforeBuild) {
        this.saveBeforeBuild = saveBeforeBuild;
    }

    public boolean isValidatePdtOnRun() {
        return this.validatePdtRun;
    }

    public boolean isValidatePdtOnRunDefaultValue() {
        return true;
    }

    public void setValidatePdtOnRun(boolean validatePdtRun) {
        this.validatePdtRun = validatePdtRun;
    }

    public boolean isShowMediumWarnings() {
        return this.showMediumWarnings;
    }

    public boolean isShowMediumWarningsDefaultValue() {
        return true;
    }

    public void setShowMediumWarnings(boolean showMediumWarnings) {
        this.showMediumWarnings = showMediumWarnings;
    }

    public boolean isRunTroubleshooterBeforeBuild() {
        return this.runTroubleshooterBeforeBuild;
    }

    public boolean isRunTroubleshooterBeforeBuildDefaultValue() {
        return true;
    }

    public void setRunTroubleshooterBeforeBuild(boolean runTroubleshooterBeforeBuild) {
        this.runTroubleshooterBeforeBuild = runTroubleshooterBeforeBuild;
    }

    public boolean isRunTroubleshooterBeforeRunDebug() {
        return this.runTroubleshooterBeforeRunDebug;
    }

    public boolean isRunTroubleshooterBeforeRunDebugDefaultValue() {
        return true;
    }

    public void setRunTroubleshooterBeforeRunDebug(boolean runTroubleshooterBeforeRunDebug) {
        this.runTroubleshooterBeforeRunDebug = runTroubleshooterBeforeRunDebug;
    }

    public void loadGeneralSettings() throws Exception {
        File settingFile = new File(ManagerFileUtils.getGeneralSettingsFilePath());
        if (!settingFile.exists()) {
            this.createGeneralSettingsFile();
        } else {
            Node runTroubleshooterBeforeRunDebugNode;
            Node runTroubleshooterBeforeBuildNode;
            Node showMediumWarningsNode;
            Node validatePdtRunNode;
            Document doc = ManagerXMLUtils.getXMLDocument(settingFile);
            this.resetSettings();
            Node saveBeforeBuildNode = doc.getElementsByTagName("AlwaysSaveBeforeBuild").item(0);
            if (saveBeforeBuildNode != null) {
                try {
                    this.saveBeforeBuild = ManagerEnums.SettingsPrompt.valueOf(saveBeforeBuildNode.getTextContent());
                }
                catch (Exception e) {
                    ManagerEnums.SettingsPrompt settingsPrompt = this.saveBeforeBuild = Boolean.parseBoolean(saveBeforeBuildNode.getTextContent()) ? ManagerEnums.SettingsPrompt.Yes : ManagerEnums.SettingsPrompt.No;
                }
            }
            if ((validatePdtRunNode = doc.getElementsByTagName("ValidatePDTBeforeRun").item(0)) != null) {
                this.validatePdtRun = Boolean.parseBoolean(validatePdtRunNode.getTextContent());
            }
            if ((showMediumWarningsNode = doc.getElementsByTagName("ShowMediumWarnings").item(0)) != null) {
                this.showMediumWarnings = Boolean.parseBoolean(showMediumWarningsNode.getTextContent());
            }
            if ((runTroubleshooterBeforeBuildNode = doc.getElementsByTagName("RunTroubleshooterBeforeBuild").item(0)) != null) {
                this.runTroubleshooterBeforeBuild = Boolean.parseBoolean(runTroubleshooterBeforeBuildNode.getTextContent());
            }
            if ((runTroubleshooterBeforeRunDebugNode = doc.getElementsByTagName("RunTroubleshooterBeforeRun").item(0)) != null) {
                this.runTroubleshooterBeforeRunDebug = Boolean.parseBoolean(runTroubleshooterBeforeRunDebugNode.getTextContent());
            }
        }
    }

    public void createGeneralSettingsFile() throws Exception {
        ManagerXMLUtils.createXMLFile(ManagerFileUtils.getGeneralSettingsFilePath(), "Settings");
        Document doc = ManagerXMLUtils.getNewDocument();
        Element sensorsNode = doc.createElement("Settings");
        Element saveElement = doc.createElement("AlwaysSaveBeforeBuild");
        saveElement.setTextContent(this.isSaveBeforeBuild().name());
        sensorsNode.appendChild(saveElement);
        Element validatePdtElement = doc.createElement("ValidatePDTBeforeRun");
        validatePdtElement.setTextContent(String.valueOf(this.isValidatePdtOnRun()));
        sensorsNode.appendChild(validatePdtElement);
        Element mediumElement = doc.createElement("ShowMediumWarnings");
        mediumElement.setTextContent(String.valueOf(this.isShowMediumWarnings()));
        sensorsNode.appendChild(mediumElement);
        Element troubleBuildElement = doc.createElement("RunTroubleshooterBeforeBuild");
        troubleBuildElement.setTextContent(String.valueOf(this.isRunTroubleshooterBeforeBuild()));
        sensorsNode.appendChild(troubleBuildElement);
        Element troubleRunElement = doc.createElement("RunTroubleshooterBeforeRun");
        troubleRunElement.setTextContent(String.valueOf(this.isRunTroubleshooterBeforeRunDebug()));
        sensorsNode.appendChild(troubleRunElement);
        doc.appendChild(sensorsNode);
        ManagerXMLUtils.createXMLFile(ManagerFileUtils.getGeneralSettingsFilePath(), doc);
        this.resetSettings();
    }

    public void resetSettings() {
        this.saveBeforeBuild = this.isSaveBeforeBuildDefaultValue();
        this.validatePdtRun = this.isValidatePdtOnRunDefaultValue();
        this.showMediumWarnings = this.isShowMediumWarningsDefaultValue();
        this.runTroubleshooterBeforeBuild = this.isRunTroubleshooterBeforeBuildDefaultValue();
        this.runTroubleshooterBeforeRunDebug = this.isRunTroubleshooterBeforeRunDebugDefaultValue();
    }

    public void updateGeneralSettings(ManagerEnums.SettingsPrompt saveBeforeBuild, boolean validatePdtRun, boolean showWarnings, boolean runTroubleshooterBuild, boolean runTroubleshooterRun) {
        this.saveBeforeBuild = saveBeforeBuild;
        this.validatePdtRun = validatePdtRun;
        this.showMediumWarnings = showWarnings;
        this.runTroubleshooterBeforeBuild = runTroubleshooterBuild;
        this.runTroubleshooterBeforeRunDebug = runTroubleshooterRun;
    }
}

