/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.model.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.intel.sensing.fdk.common.ManagerEnums;
import com.intel.sensing.fdk.model.SensorDataModel;
import com.intel.sensing.fdk.model.entity.BusInfoEntity;
import com.intel.sensing.fdk.model.entity.Callbacks;
import com.intel.sensing.fdk.model.entity.FieldsEntity;
import com.intel.sensing.fdk.model.entity.GPInputEntity;
import com.intel.sensing.fdk.model.entity.GPOutputEntity;
import com.intel.sensing.fdk.model.entity.ModuleEntity;
import com.intel.sensing.fdk.model.entity.SelectedItemsDataEntity;
import com.intel.sensing.fdk.model.entity.SensorAttributesEntity;
import com.intel.sensing.fdk.model.entity.SensorBundleEntity;
import com.intel.sensing.fdk.model.entity.SupportedCalibrationFormatsEntity;
import com.intel.sensing.fdk.model.entity.SystemEventsEntity;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SensorDataEntity
implements SelectedItemsDataEntity {
    @JsonProperty(value="BuildNumber")
    private String buildNumber;
    @JsonProperty(value="ISSVersion")
    private String iSSVersion;
    @JsonProperty(value="SensorCoreAPIVersion")
    private String sensorCoreAPIVersion;
    @JsonProperty(value="FriendlyName")
    private String friendlyName;
    @JsonProperty(value="SensorName")
    private String sensorName;
    @JsonProperty(value="SensorTypeId")
    private String sensorTypeId;
    @JsonIgnore
    private String sensorTypeName;
    @JsonProperty(value="ModelId")
    private String modelId;
    @JsonProperty(value="ModelName")
    private String modelName;
    @JsonProperty(value="VendorId")
    private String vendorId;
    @JsonProperty(value="InstanceId")
    private String instanceId;
    @JsonProperty(value="Flags")
    private String flags;
    @JsonProperty(value="ObjectType")
    private String objectType;
    @JsonProperty(value="InitFunctionName")
    private String initFunctionName;
    @JsonProperty(value="BusInfo")
    private List<BusInfoEntity> busInfo;
    @JsonProperty(value="GPInputs")
    private GPInputEntity gpInputEntity;
    @JsonProperty(value="GPOutputs")
    private GPOutputEntity gpOutputEntity;
    @JsonProperty(value="SupportedCalibrationFormats")
    private List<SupportedCalibrationFormatsEntity> supportedCalibrationFormats;
    @JsonProperty(value="Dependencies")
    private List<SensorDataEntity> dependencies;
    @JsonProperty(value="DependencyType")
    private String dependencyType;
    @JsonProperty(value="Configuration")
    private String configuration;
    @JsonProperty(value="ReportIntervalMin")
    private String reportIntervalMin;
    @JsonProperty(value="ReportIntervalMax")
    private String reportIntervalMax;
    @JsonProperty(value="Sensitivity")
    private String sensitivity;
    @JsonProperty(value="ComboId")
    private String comboId;
    @JsonIgnore
    private FieldsEntity fields;
    @JsonIgnore
    private FieldsEntity propertyFields;
    @JsonIgnore
    private SystemEventsEntity systemEvents;
    @JsonIgnore
    private SensorAttributesEntity sensorAttributes;
    @JsonIgnore
    private List<Callbacks> callbacks;
    @JsonIgnore
    private Boolean supportOffload;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    @JsonIgnore
    private SensorBundleEntity sensorBundleEntity;
    @JsonIgnore
    private boolean doNotAddSensorPostfix;
    @JsonProperty(value="CustomFlag")
    private String customFlagvalue;
    @JsonIgnore
    private String notExposedFlagValue;
    @JsonIgnore
    private String vendorName;

    public SensorDataEntity() {
    }

    public SensorDataEntity(SensorBundleEntity sensorBundleEntity) {
        this.sensorBundleEntity = sensorBundleEntity;
    }

    public SensorBundleEntity getSensorBundleEntity() {
        return this.sensorBundleEntity;
    }

    public void setSensorBundleEntity(SensorBundleEntity sensorBundleEntity) {
        this.sensorBundleEntity = sensorBundleEntity;
    }

    @JsonProperty(value="BuildNumber")
    public String getBuildNumber() {
        return this.buildNumber;
    }

    @JsonProperty(value="BuildNumber")
    public void setBuildNumber(String buildNumber) {
        this.buildNumber = buildNumber;
    }

    @JsonProperty(value="ISSVersion")
    public String getISSVersion() {
        return this.iSSVersion;
    }

    @JsonProperty(value="ISSVersion")
    public void setISSVersion(String iSSVersion) {
        this.iSSVersion = iSSVersion;
    }

    @JsonProperty(value="SensorCoreAPIVersion")
    public String getSensorCoreAPIVersion() {
        return this.sensorCoreAPIVersion;
    }

    @JsonProperty(value="SensorCoreAPIVersion")
    public void setSensorCoreAPIVersion(String sensorCoreAPIVersion) {
        this.sensorCoreAPIVersion = sensorCoreAPIVersion;
    }

    @JsonProperty(value="FriendlyName")
    public String getFriendlyName() {
        return this.friendlyName;
    }

    @JsonProperty(value="FriendlyName")
    public void setFriendlyName(String friendlyName) {
        if (friendlyName == null) {
            friendlyName = "";
        }
        if (!this.doNotAddSensorPostfix) {
            if (!friendlyName.isEmpty() && !friendlyName.toLowerCase().trim().endsWith(ManagerEnums.ComponentName.SENSOR.getFriendlyName())) {
                friendlyName = String.valueOf(friendlyName) + " Sensor";
            }
        } else if (friendlyName.toLowerCase().trim().endsWith(" sensor")) {
            friendlyName = friendlyName.substring(0, friendlyName.length() - 7);
        }
        this.friendlyName = friendlyName;
    }

    @JsonProperty(value="SensorName")
    public String getSensorName() {
        return this.sensorName;
    }

    @JsonProperty(value="SensorName")
    public void setSensorName(String sensorName) {
        this.sensorName = sensorName;
    }

    @JsonProperty(value="SensorTypeId")
    public String getSensorTypeId() {
        return this.sensorTypeId;
    }

    @JsonProperty(value="SensorTypeId")
    public void setSensorTypeId(String sensorTypeId) {
        this.sensorTypeId = sensorTypeId;
    }

    @JsonProperty(value="ModelId")
    public String getModelId() {
        return this.modelId;
    }

    @JsonProperty(value="ModelId")
    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    @JsonProperty(value="ModelName")
    public String getModelName() {
        return this.modelName;
    }

    @JsonProperty(value="ModelName")
    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    @JsonProperty(value="VendorId")
    public String getVendorId() {
        return this.vendorId;
    }

    @JsonProperty(value="VendorId")
    public void setVendorId(String vendorId) {
        this.vendorId = vendorId;
    }

    @JsonProperty
    public String getInstanceId() {
        return this.instanceId;
    }

    @JsonProperty
    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    @JsonProperty(value="Flags")
    public String getFlags() {
        return this.flags;
    }

    @JsonProperty(value="Flags")
    public void setFlags(String flags) {
        this.flags = flags;
    }

    @JsonIgnore
    public ManagerEnums.ObjectTypes getObjectType() {
        return ManagerEnums.ObjectTypes.getValueByFriendlyName((String)this.objectType);
    }

    @JsonProperty(value="ObjectType")
    public String getObjectTypeAsStr() {
        return this.objectType;
    }

    @JsonProperty(value="ObjectType")
    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    @JsonProperty(value="InitFunctionName")
    public String getInitFunctionName() {
        return this.initFunctionName;
    }

    @JsonProperty(value="InitFunctionName")
    public void setInitFunctionName(String initFunctionName) {
        this.initFunctionName = initFunctionName;
    }

    @JsonProperty(value="BusInfo")
    public List<BusInfoEntity> getBusInfo() {
        return this.busInfo;
    }

    @JsonProperty(value="BusInfo")
    public void setBusInfo(List<BusInfoEntity> busInfo) {
        this.busInfo = busInfo;
    }

    @JsonProperty(value="GPInputs")
    public GPInputEntity getGpInputEntity() {
        return this.gpInputEntity;
    }

    @JsonProperty(value="GPInputs")
    public void setGpInputEntity(GPInputEntity gpInputEntity) {
        this.gpInputEntity = gpInputEntity;
    }

    @JsonProperty(value="GPOutputs")
    public GPOutputEntity getGpOutputEntity() {
        return this.gpOutputEntity;
    }

    @JsonProperty(value="GPOutputs")
    public void setGpOutputEntity(GPOutputEntity gpOutputEntity) {
        this.gpOutputEntity = gpOutputEntity;
    }

    @JsonProperty(value="SupportedCalibrationFormats")
    public List<SupportedCalibrationFormatsEntity> getSupportedCalibrationFormats() {
        return this.supportedCalibrationFormats;
    }

    @JsonProperty(value="SupportedCalibrationFormats")
    public void setSupportedCalibrationFormats(List<SupportedCalibrationFormatsEntity> supportedCalibrationFormats) {
        this.supportedCalibrationFormats = supportedCalibrationFormats;
    }

    @JsonIgnore
    public SensorAttributesEntity getSensorAttributes() {
        return this.sensorAttributes;
    }

    @JsonIgnore
    public void setSensorAttributes(SensorAttributesEntity sensorAttributes) {
        this.sensorAttributes = sensorAttributes;
    }

    @JsonIgnore
    public FieldsEntity getFields() {
        return this.fields;
    }

    @JsonIgnore
    public void setFields(FieldsEntity fields) {
        this.fields = fields;
    }

    public FieldsEntity getPropertyFields() {
        return this.propertyFields;
    }

    public void setPropertyFields(FieldsEntity propertyFields) {
        this.propertyFields = propertyFields;
    }

    @JsonIgnore
    public SystemEventsEntity getSystemEvents() {
        return this.systemEvents;
    }

    @JsonIgnore
    public void setSystemEvents(SystemEventsEntity systemEvents) {
        this.systemEvents = systemEvents;
    }

    @JsonIgnore
    public List<Callbacks> getCallbacks() {
        return this.callbacks;
    }

    @JsonIgnore
    public void setCallbacks(List<Callbacks> callbacks) {
        this.callbacks = callbacks;
    }

    @JsonProperty(value="Dependencies")
    public List<SensorDataEntity> getDependencies() {
        return this.dependencies;
    }

    @JsonProperty(value="Dependencies")
    public void setDependencies(List<SensorDataEntity> dependencies) {
        this.dependencies = dependencies;
    }

    @JsonProperty(value="DependencyType")
    public String getDependencyType() {
        return this.dependencyType;
    }

    @JsonProperty(value="DependencyType")
    public void setDependencyType(String dependencyType) {
        this.dependencyType = dependencyType;
    }

    @JsonProperty(value="Configuration")
    public String getConfiguration() {
        return this.configuration;
    }

    @JsonProperty(value="Configuration")
    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    @JsonProperty(value="ReportIntervalMin")
    public String getReportIntervalMin() {
        return this.reportIntervalMin;
    }

    @JsonProperty(value="ReportIntervalMin")
    public void setReportIntervalMin(String reportIntervalMin) {
        this.reportIntervalMin = reportIntervalMin;
    }

    @JsonProperty(value="ReportIntervalMax")
    public String getReportIntervalMax() {
        return this.reportIntervalMax;
    }

    @JsonProperty(value="ReportIntervalMax")
    public void setReportIntervalMax(String reportIntervalMax) {
        this.reportIntervalMax = reportIntervalMax;
    }

    @JsonProperty(value="Sensitivity")
    public String getSensitivity() {
        return this.sensitivity;
    }

    @JsonProperty(value="Sensitivity")
    public void setSensitivity(String sensitivity) {
        this.sensitivity = sensitivity;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @JsonProperty(value="ComboId")
    public String getComboId() {
        return this.comboId;
    }

    @JsonProperty(value="ComboId")
    public void setComboId(String comboId) {
        this.comboId = comboId;
    }

    public boolean equalsLUID(SensorDataEntity sd) {
        return this.getLuidString().equalsIgnoreCase(sd.getLuidString());
    }

    @JsonIgnore
    public String getLuidString() {
        int i;
        StringBuilder builder = new StringBuilder("****************");
        if (this.getSensorTypeId() == null) {
            return "";
        }
        Integer typeIdDec = Integer.parseInt(this.getSensorTypeId());
        String typeIdHex = Integer.toHexString(typeIdDec);
        int len = typeIdHex.length();
        int i2 = 0;
        while (i2 < 4 - len) {
            typeIdHex = "0" + typeIdHex;
            ++i2;
        }
        builder.replace(0, 4, typeIdHex);
        if (this.getVendorId() != null) {
            Integer vendorIdDec = Integer.parseInt(this.getVendorId());
            String vendorIdHex = Integer.toHexString(vendorIdDec);
            len = vendorIdHex.length();
            i = 0;
            while (i < 4 - len) {
                vendorIdHex = "0" + vendorIdHex;
                ++i;
            }
            builder.replace(4, 8, vendorIdHex);
        }
        if (this.getModelId() != null) {
            Integer modelIdDec = Integer.parseInt(this.getModelId());
            String modelIdHex = Integer.toHexString(modelIdDec);
            len = modelIdHex.length();
            i = 0;
            while (i < 4 - len) {
                modelIdHex = "0" + modelIdHex;
                ++i;
            }
            builder.replace(8, 12, modelIdHex);
        }
        builder.replace(12, 14, "**");
        if (this.getFlags() != null) {
            Integer flagsDec = Integer.parseInt(this.getFlags());
            String flagsHex = Integer.toHexString(flagsDec);
            len = flagsHex.length();
            i = 0;
            while (i < 2 - len) {
                flagsHex = "0" + flagsHex;
                ++i;
            }
            builder.replace(14, 16, flagsHex);
        }
        return "0x" + builder.toString();
    }

    @JsonIgnore
    public boolean isDoNotAddSensorPostfix() {
        return this.doNotAddSensorPostfix;
    }

    @JsonIgnore
    public void setDoNotAddSensorPostfix(boolean doNotAddSensorPostfix) {
        this.doNotAddSensorPostfix = doNotAddSensorPostfix;
    }

    @JsonProperty(value="CustomFlag")
    public String getCustomFlagvalue() {
        return this.customFlagvalue;
    }

    @JsonProperty(value="CustomFlag")
    public void setCustomFlagvalue(String customFlagvalue) {
        this.customFlagvalue = customFlagvalue;
    }

    @JsonIgnore
    public String getNotExposedFlagValue() {
        return this.notExposedFlagValue;
    }

    @JsonIgnore
    public void setNotExposedFlagValue(String notExposedFlagValue) {
        this.notExposedFlagValue = notExposedFlagValue;
    }

    @JsonIgnore
    public String getSensorTypeName() {
        if (this.sensorTypeName != null) {
            return this.sensorTypeName;
        }
        this.sensorTypeName = SensorDataModel.findSensorTypeNameById(Integer.parseInt(this.sensorTypeId), true);
        return this.sensorTypeName;
    }

    @JsonIgnore
    public void setSensorTypeName(String sensorTypeName) {
        this.sensorTypeName = sensorTypeName;
    }

    @JsonIgnore
    public String getVendorName() {
        if (this.vendorName != null) {
            return this.vendorName;
        }
        if (this.vendorId == null) {
            return null;
        }
        this.vendorName = SensorDataModel.findVendorNameById(Integer.parseInt(this.vendorId), true);
        return this.vendorName;
    }

    @JsonIgnore
    public void setVendorName(String vendorName) {
        this.vendorName = vendorName;
    }

    @JsonIgnore
    public void addSupportedCalibrationFormats(SupportedCalibrationFormatsEntity supportedCalibrationFormatsEntity) {
        if (this.supportedCalibrationFormats == null) {
            this.supportedCalibrationFormats = new ArrayList<SupportedCalibrationFormatsEntity>();
        }
        this.supportedCalibrationFormats.add(supportedCalibrationFormatsEntity);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof SensorDataEntity)) {
            return false;
        }
        SensorDataEntity that = (SensorDataEntity)o;
        String thisJsonFile = new File(this.getSensorBundleEntity().getJsonFilePath()).getAbsolutePath();
        String thatJsonFile = new File(that.getSensorBundleEntity().getJsonFilePath()).getAbsolutePath();
        String thisLUID = this.getLuidString();
        String thatLUID = that.getLuidString();
        if (thisLUID == null || thatLUID == null) {
            return false;
        }
        return thisJsonFile.contentEquals(thatJsonFile) && thisLUID.contentEquals(thatLUID);
    }

    public boolean equalsIgnoreTag(Object o) {
        if (o == null || !(o instanceof SensorDataEntity)) {
            return false;
        }
        SensorDataEntity that = (SensorDataEntity)o;
        boolean ret = this.getSensorTypeId().contentEquals(that.getSensorTypeId()) && this.getVendorId().contentEquals(that.getVendorId()) && this.getModelId().contentEquals(that.getModelId()) && this.getFlags().contentEquals(that.getFlags());
        return ret;
    }

    @Override
    @JsonIgnore
    public ModuleEntity getModuleEntity() {
        return this.sensorBundleEntity.getModuleEntity();
    }

    @Override
    @JsonIgnore
    public String getUIComponentType() {
        return this.getObjectTypeAsStr();
    }

    @Override
    @JsonIgnore
    public String getUIModuleName() {
        return this.getSensorName();
    }

    @Override
    @JsonIgnore
    public String getUISensorType() {
        return this.getSensorTypeName();
    }

    @Override
    @JsonIgnore
    public String getUIVendor() {
        return this.getVendorName();
    }

    @Override
    @JsonIgnore
    public String getUIModelName() {
        return this.getModelName();
    }

    @Override
    @JsonIgnore
    public String getUIFlags() {
        return this.getFlags();
    }

    @Override
    @JsonIgnore
    public String getUILUID() {
        return this.getLuidString();
    }

    @Override
    @JsonIgnore
    public String getUIModuleFolderName() {
        return this.getModuleEntity().getName();
    }

    @Override
    @JsonIgnore
    public String getUIVersion() {
        return this.getBuildNumber();
    }

    public Boolean isSupportOffload() {
        return this.supportOffload;
    }

    public void setSupportOffload(Boolean supportOffload) {
        this.supportOffload = supportOffload;
    }
}

