<?php

include_once("../phpsrc/Common.php");
include_once("../phpsrc/common_smarty.php");
include_once("../phpsrc/baseclass/XMLApiCommand.class.php");
include_once("../phpsrc/localization.php");
require_once('../phpsrc/TreeMenu.php');
?>

<?php

// The following code is added specifically for QA to get the topology by using the
// URL http://localhost/topology.php?qa=1

if (isset($_GET["qa"]))
	$forQA = true;	
?>

<?php
//
//  Get device image 
//
function deviceImage($devType)
{
	switch($devType)
	{
		case DeviceType::DEVICE_TYPE_HD:
			return "Drive_Blue.gif";
		case DeviceType::DEVICE_TYPE_CD_DVD:
		    return "cd_dvd.gif";
		case DeviceType::DEVICE_TYPE_ENCLOSURE:
		    return "Enclosure.gif";
		case DeviceType::DEVICE_TYPE_TAPE:
		    return "Tape.gif";
		case DeviceType::DEVICE_TYPE_PM:
			return "PM.gif";	
		case DeviceType::DEVICE_TYPE_EXPANDER:
			return "Expander.gif";	
		case DeviceType::DEVICE_TYPE_PORT:
			return "Adapter_icon.gif";
		default:
			return 	"Drive_Blue.gif";	// ??? TBD
	}
}

//
// Get PD Image
//
function pdImage($devType)
{
	switch($devType)
	{
		case DTType::DT_CD_DVD :
			return "cd_dvd.gif";
		case DTType::DT_ENCLOSURE :
			return "Enclosure.gif";
		case DTType::DT_SEQ_ACCESS :
			return "Tape.gif";
		case DTType::DT_DIRECT_ACCESS_BLOCK :
			return 	"Drive_Blue.gif";
		default:
			return 	"Drive_Blue.gif";
	}
}


//
// Form SAS address string in hex format.
//
function FormSASAddress($addr)
{
	$sas = explode(' ', trim($addr), 8);
	return sprintf("%02X%02X%02X%02X%02X%02X%02X%02X", $sas[0], $sas[1],$sas[2],$sas[3],$sas[4],$sas[5],$sas[6],$sas[7]);
}

//
// Form PHY ID string.  Wide port has multiple PHYs.
//
function FormPhyID($cnt, $phyIdsStr)
{
	if ($cnt < 1)
		$cnt = 1;
	$str = "";
	$phyIDs = explode(" ", trim($phyIdsStr), 8);
	for ($i = 0; $i < $cnt; $i++)
	{
		if ($i == 0)
			$str .= $phyIDs[$i];
		else
			$str .= ", " . $phyIDs[$i];
	}

	return $str;
}

//
// Get the type, PHY ID(s) and SAS address (of parent) that links to this device (self)
//
function GetParentDetail($adpInfo, $info)
{
	//
	// Link information
	//
	
	$detail ="<table border=1>"; 
	
	// From (parent)
	$detail .= "<tr><th class=topoTh colspan=2>".gettext("From").": ".DeviceType::getDeviceTypeStr($info['Type'])." [" . $info['ID']."]</th></tr>";
	$detail .= "<tr><td class=topo>PHY</td><td class=topo>" . $info['PhyID'] . "</td></tr>";

	// Show SAS address only when:
	if ($adpInfo->AdapterInfo->MaxExpander > 0)	// must be a SAS HBA
	{ 
		if ($info['Type'] == DeviceType::DEVICE_TYPE_PM || $info['LinksTo']['Type'] == DeviceType::DEVICE_TYPE_PM)			
			$showSasAddr = false;	// PM doesn't have SAS address
		// non-SAS device connected directly to HBA doesn't have SAS address			
		else if ($info['Type'] == DeviceType::DEVICE_TYPE_PORT &&  
				($info['LinksTo']['Type'] == DeviceType::DEVICE_TYPE_HD || 
				$info['LinksTo']['Type'] == DeviceType::DEVICE_TYPE_CD_DVD || 
				$info['LinksTo']['Type'] == DeviceType::DEVICE_TYPE_TAPE )&&
				strncmp($info['LinksTo']['DCType'], "SAS", 3) != 0 )
			$showSasAddr = false; 
		else			
			$showSasAddr = true;
	}
	else
		$showSasAddr = false;
		
	if ($showSasAddr)
		$detail .= "<tr><td class=topo>".gettext("SAS address")."</td><td class=topo>". $info['SAS_Address']."</td></tr>";
	
	// To (self)
	$detail .= "<tr><th class=topoTh colspan=2;>".gettext("To").": ".DeviceType::getDeviceTypeStr($info['LinksTo']['Type'])." [".$info['LinksTo']['ID']."]</th></tr>";
	$detail .= "<tr><td class=topo>PHY</td><td class=topo>" . $info['LinksTo']['PhyID'] . "</td></tr>";
	if ($showSasAddr)
		$detail .= "<tr><td class=topo>".gettext("SAS address")."</td><td class=topo>".$info['LinksTo']['SAS_Address']."</td></tr>";

	$detail .= "</table>";

	return $detail;
}

//
// Get model or vendor info.
//
function GetSelfModel($info)
{
	$detail =""; 
	
	//
	// Information od the device itself.
	//
	if ($info['LinksTo']['Type'] == DeviceType::DEVICE_TYPE_HD || $info['LinksTo']['Type'] == DeviceType::DEVICE_TYPE_CD_DVD || $info['LinksTo']['Type'] == DeviceType::DEVICE_TYPE_TAPE || $info['LinksTo']['Type'] == DeviceType::DEVICE_TYPE_ENCLOSURE)
	{
		$detail .= " : ".$info['LinksTo']['DCType'] . " ".$info['LinksTo']['DTType'];
		$detail .= ", " . $info['LinksTo']['Model'];
	}
	else if ($info['LinksTo']['Type'] == DeviceType::DEVICE_TYPE_EXPANDER)
	{
		$detail .= " : ". $info['LinksTo']['VendorID'];
		$detail .= ", " . $info['LinksTo']['ProductID'];
	}
	else if ($info['LinksTo']['Type'] == DeviceType::DEVICE_TYPE_PM)
	{
		$detail .= " : ". $info['LinksTo']['VendorId'];
		$detail .= ", " . $info['LinksTo']['DeviceId'];
	}
	
	return $detail;
}


//
// Get detail information of current device (self) and also how it links to its parent.
//
function GetSelfDetail($info)
{
	$detail ="<table border=1>"; 
	
	//
	// Information od the device itself.
	//
	$detail .= "<tr><th class=topoTh colspan=2>" . DeviceType::getDeviceTypeStr($info['LinksTo']['Type']) . " [". $info['LinksTo']['ID'] ."]</th></tr>";
	if ($info['LinksTo']['Type'] == DeviceType::DEVICE_TYPE_HD || $info['LinksTo']['Type'] == DeviceType::DEVICE_TYPE_CD_DVD || $info['LinksTo']['Type'] == DeviceType::DEVICE_TYPE_TAPE || $info['LinksTo']['Type'] == DeviceType::DEVICE_TYPE_ENCLOSURE)
	{
		$detail .= "<tr><td class=topo>".gettext("PD Type")."</td><td class=topo>".$info['LinksTo']['DCType']. " " . $info['LinksTo']['DTType'] ."</td></tr>";
		$detail .= "<tr><td class=topo>".gettext("Model")."</td><td class=topo>".$info['LinksTo']['Model']."</td></tr>";
		$detail .= "<tr><td class=topo>".gettext("Serial No")."</td><td class=topo>".$info['LinksTo']['SerialNo'] . "</td></tr>";
	}
	else if ($info['LinksTo']['Type'] == DeviceType::DEVICE_TYPE_EXPANDER)
	{
		$detail .= "<tr><td class=topo>".gettext("Number of PHYs")."</td><td class=topo>".$info['LinksTo']['PhyCount']."</td></tr>";
		$detail .= "<tr><td class=topo>".gettext("Vendor ID")."</td><td class=topo>".$info['LinksTo']['VendorID']."</td></tr>";
		$detail .= "<tr><td class=topo>".gettext("Product ID")."</td><td class=topo>".$info['LinksTo']['ProductID']."</td></tr>";
	}
	else if ($info['LinksTo']['Type'] == DeviceType::DEVICE_TYPE_PM)
	{
		$detail .= "<tr><td class=topo>".gettext("Number of PHYs")."</td><td class=topo>".$info['LinksTo']['NumberOfPorts']."</td></tr>";
		$detail .= "<tr><td class=topo>".gettext("Vendor ID")."</td><td class=topo>".$info['LinksTo']['VendorId']."</td></tr>";
		$detail .= "<tr><td class=topo>".gettext("Device ID")."</td><td class=topo>".$info['LinksTo']['DeviceId']."</td></tr>";
	}
	
	$detail .= "</table>";

	return $detail;
}

//
// Add  device info to its parent device array.  Indexed by first (in case its a wide port) PHY ID 
//
function SetEntry($adpId, &$parentLinkAry, $devInfo)
{
	$parent = $devInfo->Link->Parent;
	$self = $devInfo->Link->Self;
	if ($parent->DevType == DeviceType::DEVICE_TYPE_PORT)
		$devId = $adpId;
	else
		$devId = intval($parent->DevID);
		
	// Allways use the first PHY ID as index (in case it is a wide port).
	
	$phyId = intval($parent->PhyID);
	
	if (isset($parentLinkAry[$devId][$phyId]))
	{
		// This code is specially for PATA drives which are master and slave linked to the same HBA port. 
		if ($parent->DevType == DeviceType::DEVICE_TYPE_PORT && 
			DCType::getDCTypeStr($devInfo->ConnectionType) == HdType::PATA_HD)
			{
				$phyId += 127;
			}
	}
	// Add common properties
	$parentLinkAry[$devId][$phyId] = array(
							'Type' => intval($parent->DevType),
							'ID' => $devId,
							'PhyCnt' => intval($parent->PhyCnt),
							'PhyID' => FormPhyID($parent->PhyCnt, $parent->PhyID),          
							'SAS_Address' => FormSASAddress($parent->SAS_Address),
							'LinksTo' => array('Type' => intval($self->DevType),
												'ID' => intval($self->DevID),
												'PhyCnt' => intval($self->PhyCnt),
												'PhyID' => FormPhyID($self->PhyCnt, $self->PhyID),
												'SAS_Address' => FormSASAddress($self->SAS_Address))
												);
	// Add device specific properties 
	$entry = &$parentLinkAry[$devId][$phyId]['LinksTo'];
	if ($self->DevType == DeviceType::DEVICE_TYPE_HD || $self->DevType == DeviceType::DEVICE_TYPE_CD_DVD || $self->DevType == DeviceType::DEVICE_TYPE_TAPE || $self->DevType == DeviceType::DEVICE_TYPE_ENCLOSURE)
	{
		$entry['DCType'] = DCType::getDCTypeStr($devInfo->ConnectionType);
		$entry['DTType'] = DTType::getDTType($devInfo->DeviceType);
		$entry['DTTypeInt'] = $devInfo->DeviceType;
		$entry['Model'] = $devInfo->Model;
		$entry['SerialNo'] = $devInfo->SerialNo;
	}
	else if ($self->DevType == DeviceType::DEVICE_TYPE_EXPANDER)
	{
		$entry['PhyCount'] = intval($devInfo->PhyCount);
		$entry['VendorID'] = $devInfo->VendorID;
		$entry['ProductID'] = $devInfo->ProductID;
	}
	else if ($self->DevType == DeviceType::DEVICE_TYPE_PM)
	{
		$entry['NumberOfPorts'] = intval($devInfo->NumberOfPorts);
		$entry['VendorId'] = dechex($devInfo->VendorId);
		$entry['DeviceId'] = dechex($devInfo->DeviceId);
	}
}

function anchorLink($devType, $devId)
{
	if ($devType == DeviceType::DEVICE_TYPE_HD || $devType == DeviceType::DEVICE_TYPE_CD_DVD || $devType == DeviceType::DEVICE_TYPE_TAPE || $devType == DeviceType::DEVICE_TYPE_ENCLOSURE)
		return "JumpPage.php?Target=PdDetailPage&ID=". $devId;
	else if ($devType == DeviceType::DEVICE_TYPE_PORT)
		return "JumpPage.php?Target=AdapterPage&ID=". $devId;
	else if ($devType == DeviceType::DEVICE_TYPE_EXPANDER)
		return "JumpPage.php?Target=ExpanderDetailPage&ID=". $devId;
	else if ($devType == DeviceType::DEVICE_TYPE_PM)
		return "JumpPage.php?Target=PMDetailPage&ID=". $devId;
	else
		return "#";
}
//
//  Build the menu tree structure by using HTML_TreeMenu-1.2.0 written by Richard Heyes and Harald Radi
//
//  The menu tree is generated recursively begining from the first HBA port (that has device connect to it)
//  and terminate at leave.  Device that has no down links is considerd a leave.
//
// 	$adpInfo - adapter infor
//	$node  -  current node
//  $subNodeType - node type of the node to be appended
//  $linkInfo - node to be appended to $node, associative array.
// 	$expLinks - expander links, associative array.
// 	$pmLinks - PM links, associative array.
//

function buildTreeComponent($adpInfo, $node, $subNodeType, $linkInfo, $expLinks, $pmLinks)
{	
	// We have to use array for the following variables because of the recursive call.

	$parentType = $linkInfo['Type'];
	$childType = $linkInfo['LinksTo']['Type'];
	
	// Build parent node
	if ($parentType != DeviceType::DEVICE_TYPE_HD || $parentType == DeviceType::DEVICE_TYPE_CD_DVD || $parentType == DeviceType::DEVICE_TYPE_TAPE || $parentType == DeviceType::DEVICE_TYPE_ENCLOSURE)
		$parentIcon = "cable.jpg";  // cable icon
	else
		$parentIcon = deviceImage($subNodeType);
		
	$detail = GetParentDetail($adpInfo, $linkInfo);
	
	$parentAnchor = anchorLink($parentType, $linkInfo['ID']); 
	$parentText = " PHY [".$linkInfo['PhyID']."] &harr; PHY [".$linkInfo['LinksTo']['PhyID']."], ".DeviceType::getDeviceTypeStr($childType)." [".$linkInfo['LinksTo']['ID']."]";
    $parentNode = new HTML_TreeNode(array('text' => $parentText, 'link' => "$parentAnchor", 'icon' => $parentIcon, 'expandedIcon' => $parentIcon, 'expanded' => true), array('onmouseover' => "displayDetail('$detail', event)", 'onmouseout' => "hideDetail()"));
    // Build Child node and add to its parent node.

	$childText =  " " . DeviceType::getDeviceTypeStr($childType) . " ["  . $linkInfo['LinksTo']['ID'] ."]";

	$detail = GetSelfModel($linkInfo);
	$childText .= " " . $detail;
	
	if ($childType == DeviceType::DEVICE_TYPE_HD) {
		$childIcon = pdImage($linkInfo['LinksTo']['DTTypeInt']);
	}
	else {
		$childIcon = deviceImage($childType);
	}
	
	$detail = GetSelfDetail($linkInfo);		
	$childAnchor = anchorLink($childType, $linkInfo['LinksTo']['ID']); 
	$childNode = &$parentNode->addItem(new HTML_TreeNode(array('text' => $childText, 'link' => "$childAnchor", 'icon' => $childIcon, 'expandedIcon' => $childIcon, 'expanded' => true), array('onmouseover' => "displayDetail('$detail', event)", 'onmouseout' => "hideDetail()")));

	// Check if we need to build sub-tree
	if ($childType == DeviceType::DEVICE_TYPE_PM || $childType == DeviceType::DEVICE_TYPE_EXPANDER)
	{
		$count = 0;
		if ($childType == DeviceType::DEVICE_TYPE_PM)
		{
			if (($count = count($pmLinks)) > 0)
				$ary = $pmLinks[$linkInfo['LinksTo']['ID']];
		}
		else
		{
			if (($count = count($expLinks)) > 0)
			{
				$ary = $expLinks[$linkInfo['LinksTo']['ID']];
			}
		}

		// Build sub-tree.
		if ($count > 0)
			buildTree($adpInfo, $childNode, $childType, $ary, $expLinks, $pmLinks);
	}
	
	// Add parent node to its own parent node.
    $node->addItem($parentNode);
}

function buildTree($adpInfo, $node, $subNodeType, $subNodeInfo, $expLinks, $pmLinks)
{	
	if (!isset($subNodeInfo))
		return;
	foreach ($subNodeInfo as $tempInfo)
	{
		if ($subNodeType == DeviceType::DEVICE_TYPE_PORT)
		{
			foreach ($tempInfo as $linkInfo)
			{
				buildTreeComponent($adpInfo, $node, $subNodeType, $linkInfo, $expLinks, $pmLinks);
			}
		}
		else
		{
				buildTreeComponent($adpInfo, $node, $subNodeType, $tempInfo, $expLinks, $pmLinks);
		}
	}
}

// Get all adapter Info

$AdpCount = new XMLAPICommand();
$AdpCount->setCommand(XMLAPICommand::MV_Adapter_GetCount);
if ($AdpCount->issueCommand()) 
{
	$AdpCount = $AdpCount->getResult();
	$AdpCount = $AdpCount->RetVal;
}
$Adapter = array();

for ($adpId = 0; $adpId < $AdpCount; $adpId++)
{
	// Get all adapter Info
	$Adapter[$adpId] = new XMLAPICommand();
	$Adapter[$adpId]->setCommand(XMLAPICommand::MV_Adapter_GetInfo);
	$Adapter[$adpId]->setCommandPara("AdapterID", $adpId);
	if ($Adapter[$adpId]->issueCommand()) 
		$Adapter[$adpId] = $Adapter[$adpId]->getResult();

	// Get all Expander Info
	$Expander[$adpId] = new XMLAPICommand();
	$Expander[$adpId]->setCommand(XMLAPICommand::MV_PD_GetExpanderInfo);
	$Expander[$adpId]->setCommandPara("AdapterID",$adpId);
	$Expander[$adpId]->setCommandPara("Expander_ID", XMLAPICommand::ParaALL);

	if ($Expander[$adpId]->issueCommand()) 
		$Expander[$adpId] = $Expander[$adpId]->getResult();
	
	// Get all PM Info
	$PM[$adpId] = new XMLAPICommand();
	$PM[$adpId]->setCommand(XMLAPICommand::MV_PD_GetPMInfo);
	$PM[$adpId]->setCommandPara("AdapterID",$adpId);
	$PM[$adpId]->setCommandPara("PM_ID", XMLAPICommand::ParaALL);
	if ($PM[$adpId]->issueCommand()) 
		$PM[$adpId] = $PM[$adpId]->getResult();
	
	// Get all HD Info
	$HD[$adpId] = new XMLAPICommand();
	$HD[$adpId]->setCommand(XMLAPICommand::MV_PD_GetHDInfo);
	$HD[$adpId]->setCommandPara("AdapterID",$adpId);
	$HD[$adpId]->setCommandPara("HD_ID", XMLAPICommand::ParaALL);
	if ($HD[$adpId]->issueCommand()) 
		$HD[$adpId] = $HD[$adpId]->getResult();
	
	// Create an array of HBA ports that has device links to them.  Indexed by HBA ID and port (phy) ID.
	
	$hbaLinks[$adpId] = array();
	for ($i = 0; $i <$Expander[$adpId]->Count; $i++ )
	{
		$devInfo = $Expander[$adpId]->ExpanderInfo[$i];
		if ($devInfo->Link->Parent->DevType == DeviceType::DEVICE_TYPE_PORT)  // DEVICE_TYPE_PORT is HBA
		{
			SetEntry($adpId, $hbaLinks[$adpId], $devInfo);
		}
	}
	
	for ($i = 0; $i <$PM[$adpId]->Count; $i++ )
	{
		$devInfo = $PM[$adpId]->PM_Info[$i];
		if ($devInfo->Link->Parent->DevType == DeviceType::DEVICE_TYPE_PORT)  // DEVICE_TYPE_PORT is HBA
		{
			SetEntry($adpId, $hbaLinks[$adpId], $devInfo);
		}
	}
	
	for ($i = 0; $i <$HD[$adpId]->Count; $i++ )
	{
		$devInfo = $HD[$adpId]->HD_Info[$i];
		if ($devInfo->Link->Parent->DevType == DeviceType::DEVICE_TYPE_PORT)  // DEVICE_TYPE_PORT is HBA
		{
			SetEntry($adpId, $hbaLinks[$adpId], $devInfo);
		}
	}
	//
	// Create array of Expander ports that has device links to them.  
	// Indexed by Expander ID and PHY ID (use first PHY ID as index if it is wide port).
	// Note that no PM (Port multiplexer) can connect to Expander.
	//
	
	$expLinks[$adpId] = array();
	for ($j = 0; $j <$Expander[$adpId]->Count; $j++ )
	{
		// Connected device itself is Expander.
		for ($i = 0; $i <$Expander[$adpId]->Count; $i++ )
		{
			if ($i != $j)   // Skip self.
			{
				$devInfo = $Expander[$adpId]->ExpanderInfo[$i];
				if (($devInfo->Link->Parent->DevType == DeviceType::DEVICE_TYPE_EXPANDER) && (intval($devInfo->Link->Parent->DevID) == $Expander[$adpId]->ExpanderInfo[$j]->Link->Self->DevID))
				{
					SetEntry($adpId, $expLinks[$adpId], $devInfo);
			}
		}
		}
		
		// Connected device is HD.
		for ($i = 0; $i <$HD[$adpId]->Count; $i++ )
		{
			$devInfo = $HD[$adpId]->HD_Info[$i];
			if (($devInfo->Link->Parent->DevType == DeviceType::DEVICE_TYPE_EXPANDER) && (intval($devInfo->Link->Parent->DevID) == $Expander[$adpId]->ExpanderInfo[$j]->Link->Self->DevID))
			{
				SetEntry($adpId, $expLinks[$adpId], $devInfo);
			}
		}
	}
	
	//
	// Create array of PM (Port Mutiplexer) ports that has device links to them.  
	// Indexed by PM ID and PHY (port) ID.
	// Note that no Expander can connect to PM.
	//
	
	$pmLinks[$adpId] = array();
	for ($j = 0; $j <$PM[$adpId]->Count; $j++ )
	{
		// Connected device itself is PM.
		for ($i = 0; $i <$PM[$adpId]->Count; $i++ )
		{
			if ($i != $j)	// Skip self.
			{
				$devInfo = $PM[$adpId]->PM_Info[$i];
				if (($devInfo->Link->Parent->DevType == DeviceType::DEVICE_TYPE_PM) && ($devInfo->Link->Parent->DevID == $PM[$adpId]->PM_Info[$j]->Link->Self->DevID))
					SetEntry($adpId, $pmLinks[$adpId], $devInfo);
			}
		}
		
		// Connected device is HD.
		for ($i = 0; $i <$HD[$adpId]->Count; $i++ )
		{
			$devInfo = $HD[$adpId]->HD_Info[$i];
			if (($devInfo->Link->Parent->DevType == DeviceType::DEVICE_TYPE_PM) && (intval($devInfo->Link->Parent->DevID) == $PM[$adpId]->PM_Info[$j]->Link->Self->DevID))
				SetEntry($adpId, $pmLinks[$adpId], $devInfo);
		}
	}
	
	// ------------------------------------------------------------------------------------------------
	// Build menu
	// ------------------------------------------------------------------------------------------------
	
	$menu[$adpId]  = new HTML_TreeMenu();
	
	//
	// Create first layer adapter node
	// 
	$detail ="<table border=1>"; 
	$detail .= "<tr><th class=topoTh colspan=2>".gettext("Adapter")." ".$adpId."</th></tr>";
	$detail .= "<tr><td class=topo>".gettext("Number of ports")."</td><td class=topo>".$Adapter[$adpId]->AdapterInfo->PortCount."</td></tr>";
	$detail .= "<tr><td class=topo>".gettext("Vendor ID")."</td><td class=topo>".dechex($Adapter[$adpId]->AdapterInfo->VenDevID)."</td></tr>";
	$detail .= "<tr><td class=topo>".gettext("Sub Vendor ID")."</td><td class=topo>".dechex($Adapter[$adpId]->AdapterInfo->SubVenDevID)."</td></tr>";
	$detail .= "</table>";
	
	$text = " Adapter [" . $adpId ."]";
	
	$Anchor = anchorLink(DeviceType::DEVICE_TYPE_PORT, $adpId); 
	$AdpNode[$adpId]   = new HTML_TreeNode(array('text' => $text, 'link' => "$Anchor", 'icon' => deviceImage(DeviceType::DEVICE_TYPE_PORT), 'expandedIcon' => deviceImage(DeviceType::DEVICE_TYPE_PORT), 'expanded' => true), array('onmouseover' => "displayDetail('$detail', event)", 'onmouseout' => "hideDetail()"));
    $menu[$adpId]->addItem($AdpNode[$adpId]);

	//
	// Create the rest of the nodes
	//
	buildTree($Adapter[$adpId], $AdpNode[$adpId], DeviceType::DEVICE_TYPE_PORT, $hbaLinks[$adpId], $expLinks[$adpId], $pmLinks[$adpId]);
	
	$treeMenu[$adpId] = &new HTML_TreeMenu_DHTML($menu[$adpId], array('images' => 'images', 'defaultClass' => 'treeMenuDefault'));
}
?>

<?php

// The following code is added specifically for QA to get the topology by using the
// URL http://localhost/topology.php?qa=1
// Topology.php normally is embedded in TopologyPage.tpl.
if (isset($forQA))
{
	echo('
		<script src="./javascript/TreeMenu.js" language="JavaScript" type="text/javascript"></script>
	    <style type="text/css">
		a:link {
			color: black;
			text-decoration: none;
		}
		a:visited {
			color: black;
			text-decoration: none;
		}
	    </style>
    ');
}	
?>

<?php
for ($i = 0; $i < $AdpCount; $i++)
{
	echo "<br>";
	$treeMenu[$i]->printMenu();
}
	
?>
