/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.DataStore;
import pdtEditor.Device;
import pdtEditor.InformationStore;
import pdtEditor.PdtFile;
import pdtEditor.Sensor;
import pdtEditor.gui.MultiPdtEditAddDevices;
import pdtEditor.gui.SensorModifier;
import pdtEditor.gui.SensorModifierOpener;

public class MultiPdtEdit
implements SensorModifierOpener {
    protected static final int MINIMAL_COL_WIDTH = 50;
    private static Display display;
    private DataBindingContext m_bindingContext;
    private DataStore _dataStore = DataStore.getInstance();
    private String _lastDirPath = new File(".").getAbsolutePath();
    protected Shell shell;
    private Table sensorTable;
    private Table DeviceTable;
    private Group grpDeviceVsPdt;
    private Button button;
    private Button button_1;
    private TableViewer sensorTableViewer;
    private TableColumn tblclmnNewColumn;
    private TableViewerColumn tableViewerColumn;
    private TableColumn tblclmnNewColumn_1;
    private TableViewerColumn tableViewerColumn_1;
    private TableColumn tblclmnNewColumn_2;
    private TableViewerColumn tableViewerColumn_2;
    private TableColumn tblclmnNewColumn_3;
    private TableViewerColumn tableViewerColumn_3;
    private CheckboxTableViewer devicesTableViewer;
    private TableColumn tblclmnNewColumn_4;
    private TableViewerColumn tableViewerColumn_4;
    private Button addDevices;
    private Button AddPdtFile;
    private Button btnAddDirectory;
    private Button btnGeneratePdtFiles;
    private Button btnClearAll;
    private Label lblNewLabel;
    private boolean _autoExportXml;

    public static void main(String[] args) {
        display = Display.getDefault();
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)display), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    MultiPdtEdit window = new MultiPdtEdit(false);
                    window.open();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public MultiPdtEdit(boolean autoExportXml) {
        this._autoExportXml = autoExportXml;
    }

    public void open() {
        display = Display.getDefault();
        this.createContents();
        try {
            InformationStore.verifyMandatoryFiles();
        }
        catch (FileNotFoundException e) {
            MessageBox messageBox = new MessageBox(this.shell, 33);
            messageBox.setText("Missing files");
            messageBox.setMessage(e.getMessage());
            messageBox.open();
            return;
        }
        this.shell.open();
        this.shell.layout();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public void loadDirectory() {
        DirectoryDialog dialog = new DirectoryDialog(this.shell);
        dialog.setFilterPath(this._lastDirPath);
        dialog.setText("Load PDT binary image");
        String path = dialog.open();
        if (path == null || path.isEmpty()) {
            return;
        }
        File dir = new File(path);
        if (!dir.exists() || !dir.isDirectory()) {
            System.err.println("No such directory: " + path);
            return;
        }
        this._lastDirPath = dir.getAbsolutePath();
        StringBuilder errors = new StringBuilder();
        for (File file : dir.listFiles()) {
            if (!file.isFile()) continue;
            try {
                this.addPdtFrom(file.getAbsolutePath(), false);
            }
            catch (Exception e) {
                errors.append("\n>>> '" + file.getName() + "'" + (e.getMessage() != null ? ": " + e.getMessage() : ""));
            }
        }
        if (errors.length() > 0) {
            MessageBox messageBox = new MessageBox(this.shell, 40);
            messageBox.setText("Loading Errors");
            messageBox.setMessage("The following files could not be loaded:" + errors);
            messageBox.open();
        }
        this.refresh();
    }

    public void addPdtFile() {
        FileDialog fd = new FileDialog(this.shell, 4096);
        fd.setText("Load PDT binary image");
        fd.setFilterPath(this._lastDirPath);
        String[] filterExt = new String[]{"*.bin; *.*"};
        fd.setFilterExtensions(filterExt);
        String path = fd.open();
        if (path == null || path.isEmpty()) {
            return;
        }
        this._lastDirPath = new File(path).getParent();
        try {
            this.addPdtFrom(path, true);
        }
        catch (UnsupportedOperationException e) {
            MessageBox messageBox = new MessageBox(this.shell, 33);
            messageBox.setText("Loading Error");
            messageBox.setMessage(new File(path).getName() + "Could not be loaded.");
            messageBox.open();
        }
        catch (Exception e) {
            MessageBox messageBox = new MessageBox(this.shell, 33);
            messageBox.setText("Loading Error");
            messageBox.setMessage(new File(path).getName() + ": " + e.getMessage());
            messageBox.open();
        }
    }

    public void addPdtFrom(String path, boolean refresh) throws IOException {
        PdtFile pdtFile = new PdtFile(path);
        this._dataStore.loadFromPdtBin(pdtFile);
        this._dataStore.setCurrentPdtFile(null);
        if (refresh) {
            this.refresh();
        }
    }

    public void generatePdtFiles() {
        MessageBox messageBox;
        if (this._dataStore.getPdtFiles().size() == 0) {
            MessageBox messageBox2 = new MessageBox(this.shell, 33);
            messageBox2.setText("Generating PDT files");
            messageBox2.setMessage("There are no PDT file to generate.");
            messageBox2.open();
        }
        boolean error = false;
        for (PdtFile pdtFile : this._dataStore.getPdtFiles()) {
            try {
                System.out.println("Saving " + pdtFile.getPath());
                if (this._autoExportXml) {
                    this._dataStore.setXmlDestPath(new File(pdtFile.getPath() + ".xml"));
                }
                this._dataStore.saveToPdtBin(pdtFile);
            }
            catch (Exception e) {
                e.printStackTrace();
                error = true;
            }
        }
        if (error) {
            messageBox = new MessageBox(this.shell, 33);
            messageBox.setText("Generating PDT files");
            messageBox.setMessage("One or more of the PDT files failed to be generated.");
            messageBox.open();
        } else {
            messageBox = new MessageBox(this.shell, 34);
            messageBox.setText("Generating PDT files");
            messageBox.setMessage("The PDT files have been generated successfully.");
            messageBox.open();
        }
    }

    public void updateDevicesPerSensorList(Sensor sensor) {
        this.DeviceTable.setEnabled(true);
        ArrayList<Device> devicesOfSensor = this._dataStore.getDevicesOfSensor(sensor);
        for (int i = 0; i < this.DeviceTable.getItemCount(); ++i) {
            this.DeviceTable.getItem(i).setChecked(false);
        }
        for (Device device : devicesOfSensor) {
            for (int i = 0; i < this.DeviceTable.getItemCount(); ++i) {
                if (!this.DeviceTable.getItem(i).getData().equals(device)) continue;
                this.DeviceTable.getItem(i).setChecked(true);
            }
        }
    }

    public void onDevicePerSensorSelection() {
        if (this.sensorTable.getSelection().length == 0) {
            System.err.println("sensorTable has no selection");
            return;
        }
        Sensor sensor = (Sensor)this.sensorTable.getSelection()[0].getData();
        for (int i = 0; i < this.DeviceTable.getItemCount(); ++i) {
            Device device = (Device)this.DeviceTable.getItem(i).getData();
            if (this.devicesTableViewer.getTable().getItem(i).getChecked()) {
                device.addSensor(sensor);
                continue;
            }
            device.removeSensor(sensor);
        }
    }

    public void editSelectedSensor() {
        if (this.sensorTable.getSelectionCount() == 0) {
            return;
        }
        Sensor sensor = (Sensor)this.sensorTable.getSelection()[0].getData();
        Sensor preChangeSensor = sensor.clone();
        new SensorModifier(this, null, sensor, true).open();
        this._dataStore.replaceSensor(preChangeSensor, sensor);
    }

    private void addNewPhysicalSensor() {
        SensorModifier modifier = new SensorModifier(this, null, true, null, true);
        modifier.open();
    }

    private void addNewVirtualSensor() {
        SensorModifier modifier = new SensorModifier(this, null, false, null, true);
        modifier.open();
    }

    public void addNewDevices() {
        new MultiPdtEditAddDevices(this, this._dataStore).open();
    }

    @Override
    public void setModified() {
    }

    @Override
    public void refresh() {
        this._dataStore.removeDuplicatedGlobalSensors();
        if (this._dataStore.getDevices().size() > 0) {
            this.btnGeneratePdtFiles.setEnabled(true);
        } else {
            this.btnGeneratePdtFiles.setEnabled(false);
        }
        this.sensorTableViewer.refresh();
        this.devicesTableViewer.refresh();
    }

    @Override
    public void selectSensor(Sensor sensor) {
    }

    @Override
    public void onSensorModifierClose(SensorModifier modifier) {
    }

    @Override
    public void addSensor(Sensor sensor) {
        this._dataStore.addGlobalSensor(sensor);
    }

    protected void createContents() {
        this.shell = new Shell(224);
        this.shell.setImage(SWTResourceManager.getImage(MultiPdtEdit.class, "/resources/Intel.ico"));
        this.shell.setSize(1022, 557);
        this.shell.setText("Intel\u00ae Integrated Sensor Solution - Platform Description Table (PDT) Editor");
        Monitor primary = display.getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = this.shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        this.shell.setLocation(x, y);
        this.shell.setLayout(null);
        Group grpSensorVsDevices = new Group((Composite)this.shell, 0);
        grpSensorVsDevices.setText("Sensor VS. Devices");
        grpSensorVsDevices.setBounds(10, 107, 987, 358);
        this.sensorTableViewer = new TableViewer((Composite)grpSensorVsDevices, 67584);
        this.sensorTable = this.sensorTableViewer.getTable();
        this.sensorTable.setLinesVisible(true);
        this.sensorTable.setHeaderVisible(true);
        this.sensorTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                MultiPdtEdit.this.editSelectedSensor();
            }
        });
        this.sensorTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                Sensor sensor = (Sensor)MultiPdtEdit.this.sensorTable.getSelection()[0].getData();
                MultiPdtEdit.this.updateDevicesPerSensorList(sensor);
            }
        });
        this.sensorTable.setBounds(10, 22, 671, 296);
        ControlAdapter resizeColHandler = new ControlAdapter(){

            public void controlResized(ControlEvent arg0) {
                if (((TableColumn)arg0.getSource()).getWidth() < 50) {
                    ((TableColumn)arg0.getSource()).setWidth(50);
                }
            }
        };
        TableViewerColumn tableViewerColumn_5 = new TableViewerColumn(this.sensorTableViewer, 0);
        TableColumn tblclmnType = tableViewerColumn_5.getColumn();
        tblclmnType.setWidth(67);
        tblclmnType.setText("Physical");
        tblclmnType.addControlListener((ControlListener)resizeColHandler);
        this.tableViewerColumn_3 = new TableViewerColumn(this.sensorTableViewer, 0);
        this.tblclmnNewColumn_3 = this.tableViewerColumn_3.getColumn();
        this.tblclmnNewColumn_3.setWidth(172);
        this.tblclmnNewColumn_3.setText("Sensor Type");
        this.tblclmnNewColumn_3.addControlListener((ControlListener)resizeColHandler);
        this.tableViewerColumn = new TableViewerColumn(this.sensorTableViewer, 0);
        this.tblclmnNewColumn = this.tableViewerColumn.getColumn();
        this.tblclmnNewColumn.setWidth(128);
        this.tblclmnNewColumn.setText("Model");
        this.tblclmnNewColumn.addControlListener((ControlListener)resizeColHandler);
        this.tableViewerColumn_2 = new TableViewerColumn(this.sensorTableViewer, 0);
        this.tblclmnNewColumn_2 = this.tableViewerColumn_2.getColumn();
        this.tblclmnNewColumn_2.setWidth(117);
        this.tblclmnNewColumn_2.setText("Vendor");
        this.tblclmnNewColumn_2.addControlListener((ControlListener)resizeColHandler);
        this.tableViewerColumn_1 = new TableViewerColumn(this.sensorTableViewer, 0);
        this.tblclmnNewColumn_1 = this.tableViewerColumn_1.getColumn();
        this.tblclmnNewColumn_1.setWidth(155);
        this.tblclmnNewColumn_1.setText("Luid");
        this.tblclmnNewColumn_1.addControlListener((ControlListener)resizeColHandler);
        this.devicesTableViewer = CheckboxTableViewer.newCheckList((Composite)grpSensorVsDevices, (int)67584);
        this.DeviceTable = this.devicesTableViewer.getTable();
        this.DeviceTable.setHeaderVisible(true);
        this.DeviceTable.setLinesVisible(true);
        this.DeviceTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MultiPdtEdit.this.onDevicePerSensorSelection();
            }
        });
        this.DeviceTable.setBounds(687, 22, 285, 265);
        this.DeviceTable.setEnabled(false);
        this.tableViewerColumn_4 = new TableViewerColumn((TableViewer)this.devicesTableViewer, 0);
        this.tblclmnNewColumn_4 = this.tableViewerColumn_4.getColumn();
        this.tblclmnNewColumn_4.setWidth(257);
        this.tblclmnNewColumn_4.setText("Device");
        this.button = new Button((Composite)grpSensorVsDevices, 0);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MultiPdtEdit.this.addNewPhysicalSensor();
            }
        });
        this.button.setText("Add Physical Sensor");
        this.button.setBounds(10, 324, 118, 25);
        this.button_1 = new Button((Composite)grpSensorVsDevices, 0);
        this.button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MultiPdtEdit.this.addNewVirtualSensor();
            }
        });
        this.button_1.setText("Add Virtual Sensor");
        this.button_1.setBounds(134, 324, 109, 25);
        this.addDevices = new Button((Composite)grpSensorVsDevices, 0);
        this.addDevices.setBounds(687, 293, 285, 25);
        this.addDevices.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MultiPdtEdit.this.addNewDevices();
            }
        });
        this.addDevices.setText("Add Devices");
        this.grpDeviceVsPdt = new Group((Composite)this.shell, 0);
        this.grpDeviceVsPdt.setBounds(10, 10, 314, 90);
        this.AddPdtFile = new Button((Composite)this.grpDeviceVsPdt, 0);
        this.AddPdtFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MultiPdtEdit.this.addPdtFile();
            }
        });
        this.AddPdtFile.setText("Load PDT File");
        this.AddPdtFile.setBounds(10, 21, 118, 25);
        this.btnAddDirectory = new Button((Composite)this.grpDeviceVsPdt, 0);
        this.btnAddDirectory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MultiPdtEdit.this.loadDirectory();
            }
        });
        this.btnAddDirectory.setText("Load Directory");
        this.btnAddDirectory.setBounds(134, 21, 118, 25);
        this.btnClearAll = new Button((Composite)this.grpDeviceVsPdt, 0);
        this.btnClearAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MultiPdtEdit.this._dataStore.clearData();
                MultiPdtEdit.this.refresh();
            }
        });
        this.btnClearAll.setBounds(10, 52, 118, 25);
        this.btnClearAll.setText("Clear All");
        this.btnGeneratePdtFiles = new Button((Composite)this.shell, 0);
        this.btnGeneratePdtFiles.setEnabled(false);
        this.btnGeneratePdtFiles.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MultiPdtEdit.this.generatePdtFiles();
            }
        });
        this.btnGeneratePdtFiles.setText("Generate PDT files");
        this.btnGeneratePdtFiles.setBounds(832, 493, 174, 25);
        this.lblNewLabel = new Label((Composite)this.shell, 0);
        this.lblNewLabel.setFont(SWTResourceManager.getFont("Segoe UI", 10, 1));
        this.lblNewLabel.setBounds(10, 501, 779, 17);
        this.lblNewLabel.setText("Status");
        this.lblNewLabel.setVisible(false);
        this.m_bindingContext = this.initDataBindings();
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ObservableListContentProvider listContentProvider = new ObservableListContentProvider();
        IObservableMap[] observeMaps = PojoObservables.observeMaps((IObservableSet)listContentProvider.getKnownElements(), Sensor.class, (String[])new String[]{"luid.isPhysical", "luid.sensorTypeIdStr", "luid.sensorSubTypeIdStr", "luid.vendorIdStr", "luid.hexValue"});
        this.sensorTableViewer.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMaps));
        this.sensorTableViewer.setContentProvider((IContentProvider)listContentProvider);
        IObservableList selfList = Properties.selfList(Sensor.class).observe(this._dataStore.getGlobalSensors());
        this.sensorTableViewer.setInput((Object)selfList);
        ObservableListContentProvider listContentProvider_1 = new ObservableListContentProvider();
        IObservableMap observeMap = PojoObservables.observeMap((IObservableSet)listContentProvider_1.getKnownElements(), Device.class, (String)"deviceNameWithPdtPath");
        this.devicesTableViewer.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap));
        this.devicesTableViewer.setContentProvider((IContentProvider)listContentProvider_1);
        IObservableList devices_dataStoreObserveList = PojoProperties.list((String)"devices").observe((Object)this._dataStore);
        this.devicesTableViewer.setInput((Object)devices_dataStoreObserveList);
        return bindingContext;
    }
}

