#ifndef LINUX_VERSION_CODE
#include <stdint.h> // only include if we're not compiling against the kernel
#endif

#define AQDIAG_IOCTL_MAGIC 'Q'
#define AQDIAG_ALLOC_MEM _IOR(AQDIAG_IOCTL_MAGIC, 0x1, long)
#define AQDIAG_FREE_MEM _IOW(AQDIAG_IOCTL_MAGIC, 0x2, long)
#define AQDIAG_REQ_INT _IOWR(AQDIAG_IOCTL_MAGIC, 0x3, long)
#define AQDIAG_INT_CANCEL _IOWR(AQDIAG_IOCTL_MAGIC, 0x4, long)

struct aqdiag_alloc_mem {
	uint32_t size;
	uint32_t index;
};

struct aqdiag_req_int {
	uint32_t vector;
	uint32_t reset_count;
	uint64_t timeout;
	uint32_t count;
	uint64_t time_last;
	uint64_t time_min;
	uint64_t time_max;
};
