/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.model.service;

import com.intel.sensing.fdk.common.log.ISSLogger;
import com.intel.sensing.fdk.model.ObservableModel;
import com.intel.sensing.fdk.model.dao.ModuleDao;
import com.intel.sensing.fdk.model.entity.ModuleEntity;
import com.intel.sensing.fdk.model.entity.ProjectEntity;
import com.intel.sensing.fdk.model.service.PersistenceServiceListenName;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ProjectUserSensorService
extends ObservableModel
implements PropertyChangeListener {
    private List<ModuleEntity> userModuleList;
    private ProjectEntity project;
    private ModuleDao _moduleDao;

    public ProjectUserSensorService(ProjectEntity project) {
        this.setUserModuleList(this.parseModule());
    }

    private List<ModuleEntity> parseModule() {
        List<ModuleEntity> moduleEntityList = new ArrayList<ModuleEntity>();
        try {
            List moduleStrList = Files.walk(this.project.getModuleFolder(), 2, new FileVisitOption[0]).filter(file -> file.toFile().exists() && file.toFile().isDirectory() && file.resolve("module.json").toFile().exists()).map(jsonFile -> jsonFile.toAbsolutePath().toString()).collect(Collectors.toList());
            moduleEntityList = moduleStrList.stream().map(module -> this._moduleDao.getEntityByFilePath((String)module)).filter(module -> module != null).collect(Collectors.toList());
        }
        catch (IOException e) {
            ISSLogger.e((Exception)e);
        }
        return moduleEntityList;
    }

    public List<ModuleEntity> getUserModuleList() {
        return this.userModuleList;
    }

    public void setUserModuleList(List<ModuleEntity> userModuleList) {
        List<ModuleEntity> oldValue = this.userModuleList;
        this.userModuleList = userModuleList;
        if (oldValue != null && !oldValue.equals(userModuleList)) {
            this.firePropertyChange(PersistenceServiceListenName.InstalledModuleService.getServiceListenName(), oldValue, userModuleList);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().contentEquals(PersistenceServiceListenName.ModuleCacheService.getServiceListenName())) {
            this.setUserModuleList(this.parseModule());
        }
    }
}

