/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui;

import entity.SensorEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import manager.utils.ManagerEnums;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.DataStore;
import pdtEditor.Device;
import pdtEditor.InformationStore;
import pdtEditor.Luid;
import pdtEditor.PdtUpdateModes;
import pdtEditor.Sensor;
import pdtEditor.gui.BusInfo;
import pdtEditor.gui.CustomValueGetter;
import pdtEditor.gui.DependenciesUtils;
import pdtEditor.gui.GPIO;
import pdtEditor.gui.GpioInfo;
import pdtEditor.gui.GuiUtils;
import pdtEditor.gui.SensorModifierOpener;
import pdtEditor.gui.calibration.CalibrationEditorOpener;
import pdtEditor.payloads.BusPayload;
import pdtEditor.payloads.GpioPayload;
import pdtEditor.payloads.GuidPayload;
import pdtEditor.payloads.PayloadUtils;
import pdtEditor.payloads.calibrations.CalibrationPayload;
import pdtEditor.payloads.calibrations.VirtualAcclCalibrationPayload;
import pdtEditor.payloads.calibrations.VirtualGyroCalibrationPayload;
import pdtEditor.payloads.calibrations.VirtualMagCalibrationPayload;
import pdtEditor.payloads.configurations.ConfigurationPayload;
import pdtEditor.validation.Issue;
import resources.CustomSpinner;

public class SensorModifier
implements CalibrationEditorOpener {
    private static final String NO_CALIBRATION_TEXT = "No calibration or configuration data.";
    private static final String NEW_CALIBRATION_TEXT = "New Calibration";
    private static final String MODIFY_CALIBRATION_TEXT = "Modify Calibration";
    private static final String NEW_CONFIGURATION_TEXT = "New Configuration";
    private static final String MODIFY_CONFIGURATION_TEXT = "Modify Configuration";
    private static final String CUSTOM_VALUE_TEXT = "Custom value...";
    private static final String CALIBRATION_UPDATE_INFO_MESSAGE = "Upon updating your platform's PDT:\nKeep: The calibration data entered here should be ignored; the calibration data already on the platform will be kept.\nOverwrite: The calibration data entered here should overwrite the calibration data currently on the platform.\nAppend: The calibration data entered here will be ignored if there is already calibration data on the platform, otherwise will be appended to the sensor if there is no calibration data on the platform.\n";
    private Display display;
    protected Shell shlSensorModifier;
    protected SensorModifier _thisModifier = this;
    private Sensor _sensor;
    private Sensor _initialValuesHolder = null;
    private Device _device;
    private CalibrationPayload _calibration = null;
    private SensorModifierOpener _parent;
    private InformationStore infoStore = null;
    private ConfigurationPayload _configuration;
    private BusInfo _busInfo;
    private GpioInfo _gpioInfo;
    private Issue.IssueType _highlightFlags = null;
    private Issue.IssueType _highlightBus = null;
    private Issue.IssueType _highlightCalibration = null;
    private Issue.IssueType _highlightGpio = null;
    private Issue.IssueType _highlightBusInstance;
    private Issue.IssueType _highlightBasic;
    private Issue.IssueType _highlightSensorInstance;
    private boolean _newPhysicalSensor;
    private boolean _modelValIntelRangeNotified = false;
    private boolean _enableSensorType = true;
    private boolean _enableModel = true;
    private boolean _calibratedFlagEditable = true;
    private boolean _modal;
    private boolean _setBusFieldsFromMetadata = false;
    private boolean _flagsModified = true;
    private boolean _setFlagsModified = false;
    private String _fieldLockedInfoText = "";
    private String _fixDescription;
    private CustomSpinner txtInstance;
    private Label lblSensorTypeId;
    private Label lblSensorModelId;
    private Label lblVendorId;
    private Label lblInstance;
    private Label lblIsPhysicalSensor;
    private Label lblCalibrationType;
    private Label lblUponPdtUpdate;
    private Group grpBasicDetails;
    private Group grpFlags;
    private Group grpBus;
    private Group grpGpio;
    private Group grpSensorIo;
    private Group grpCalibration;
    private Group grpDependencies;
    private Button chbWakeable;
    private Button chbCalibrated;
    private Button chbIsPhysical;
    private Button chbMsExt;
    private Button chbAndroidExt;
    private Button chbSyntethic;
    private Button chbNotExposed;
    private Button btnManageGpio;
    private Button btnUpdateModeInfo;
    private Button btnModelInfo;
    private Button btnCalibratedInfo;
    private Button btnConfigurationModify;
    private Button chbCustom;
    private Button btnCalibrationDelete;
    private Button btnCalibrationModify;
    private Button btnConfigurationDelete;
    private Button btnSensorTypeInfo;
    private Button btnOk;
    private Button btnCancel;
    private TableViewer interruptsTableViewer;
    private Combo cmbSensorTypeId;
    private Combo cmbVendorID;
    private Combo cmbModelID;
    private Combo cmbCalibUpdateMode;
    private ToolTip modelHoverTooltip;
    private Table tblDependencies;
    private TableColumn tblclmnType;
    private TableColumn tblclmnDpnSensType;
    private TableColumn tblclmnDpnVendor;
    private TableColumn tblclmnDpnModel;
    private TableColumn tblclmnDpnInstance;
    private TableColumn tblclmnDpnFlags;
    private TableViewerColumn tblVwrClmDependencyType;
    private TableViewerColumn tblVwrClmDependencySensType;
    private TableViewerColumn tblVwrClmDependencyVendor;
    private TableViewerColumn tblVwrClmDependencyModel;
    private TableViewerColumn tblVwrClmDependencyInstance;
    private TableViewerColumn tblVwrClmDependencyFlags;
    private GridData gd_grpBus;
    private GridData gd_grpSensorIo;
    private GridData gd_grpGpio;
    private GridData gd_grpDependencies;
    private GridData gd_chbMsExt;
    private GridData gd_chbAndroidExt;
    private GridData gd_chbSyntethic;
    private Text txtGuid;
    GuiUtils.WindowProperties _properties = new GuiUtils.WindowProperties(){

        @Override
        protected void onModification() {
        }
    };

    public static void main(String[] args) {
        Display display = Display.getDefault();
        Realm.runWithDefault((Realm)SWTObservables.getRealm((Display)display), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    SensorModifier window = new SensorModifier(null, null, true, null, false);
                    window.open();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public SensorModifier(SensorModifierOpener parent, Device device, boolean isPhysicalSensor, Sensor initialValuesHolder, boolean modal) {
        this._device = device;
        this._parent = parent;
        this._newPhysicalSensor = isPhysicalSensor;
        this._initialValuesHolder = initialValuesHolder;
        this._modal = modal;
    }

    public SensorModifier(SensorModifierOpener parent, Device device, Sensor sensor, boolean modal) {
        this._device = device;
        this._sensor = sensor;
        this._parent = parent;
        this._modal = modal;
    }

    public void open() {
        this.display = Display.getDefault();
        this.createContents();
        try {
            this.infoStore = InformationStore.getInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageBox messageBox = new MessageBox(this.shlSensorModifier, 513);
            messageBox.setText("Cannot load file");
            messageBox.setMessage("Cannot load the sensor definitions file - the file is missing or damaged. Aborting.");
            messageBox.open();
            return;
        }
        this.initScreen();
        this.fillSensorData();
        this._flagsModified = this._flagsModified || this._setFlagsModified;
        this.highlightControls();
        this._properties.setModified(false);
        this.shlSensorModifier.open();
        this.shlSensorModifier.layout();
        while (!this.shlSensorModifier.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    public void adjustWindowToPhysical(boolean physical) {
        if (physical) {
            this.lblIsPhysicalSensor.setText("Physical Sensor");
        } else {
            this.lblIsPhysicalSensor.setText("Virtual Sensor");
        }
        if (!physical) {
            this.grpBus.setVisible(false);
            this.gd_grpBus.exclude = true;
            this.grpGpio.setVisible(false);
            this.gd_grpGpio.exclude = true;
            this.grpDependencies.setVisible(true);
            this.gd_grpDependencies.exclude = false;
            this.grpSensorIo.setVisible(true);
            this.gd_grpSensorIo.exclude = false;
        }
    }

    private ArrayList<Control> getGpioControls() {
        ArrayList<Control> res = new ArrayList<Control>();
        if (this.chbIsPhysical.getSelection()) {
            res.add((Control)this.grpGpio);
        } else {
            res.add((Control)this.btnManageGpio);
        }
        return res;
    }

    private void refreshDependencies() {
        if (this.chbIsPhysical.getSelection()) {
            return;
        }
        Sensor dependenciesHolder = null;
        Luid luid = this.getSensorLuidFromFields(true);
        if (luid != null) {
            dependenciesHolder = new Sensor(luid);
        }
        List<SensorEntity> dependencies = null;
        if (dependenciesHolder != null) {
            if (this._sensor != null && this._sensor.getLuid().staticEquals(luid)) {
                dependenciesHolder = this._sensor;
            } else {
                this.infoStore.setDependeciesInfoToSensor(dependenciesHolder);
            }
            dependencies = dependenciesHolder.getDependencies();
        }
        this.tblDependencies.removeAll();
        if (dependencies == null || dependencies.size() == 0) {
            this.tblDependencies.setEnabled(false);
        } else {
            if (DataStore.getInstance().getCurrentPdtFile() == null) {
                return;
            }
            this.tblDependencies.setEnabled(true);
            List<SensorEntity> unfulfiledDependencies = DataStore.getInstance().getCurrentPdtFile().getUnfulfilledDependecies(dependenciesHolder);
            for (SensorEntity dependency : dependencies) {
                Color itemColor;
                TableItem item = new TableItem(this.tblDependencies, 0);
                DependenciesUtils.initInfoStore();
                String[] itemData = new String[]{dependency.getDependencyType() == null ? "" : dependency.getDependencyType().name(), DependenciesUtils.getDependencySensorType(dependency), DependenciesUtils.getDependencyVendor(dependency), DependenciesUtils.getDependencyModel(dependency), String.valueOf(DependenciesUtils.getDependencyInstance(dependency, dependenciesHolder)), DependenciesUtils.getDependencyFlags(dependency)};
                item.setText(itemData);
                boolean unfulfiledDependency = false;
                if (unfulfiledDependencies != null) {
                    Luid dependencyLuid = new Luid(dependency);
                    for (SensorEntity sensorEntity : unfulfiledDependencies) {
                        if (!new Luid(sensorEntity).equals(dependencyLuid)) continue;
                        unfulfiledDependency = true;
                        break;
                    }
                }
                if (unfulfiledDependency) {
                    if (dependency.getDependencyType() == ManagerEnums.DependencyTypes.MANDATORY) {
                        itemColor = new Color((org.eclipse.swt.graphics.Device)Display.getCurrent(), 255, 0, 0);
                        item.setForeground(itemColor);
                        itemColor.dispose();
                        continue;
                    }
                    itemColor = new Color((org.eclipse.swt.graphics.Device)Display.getCurrent(), 0, 0, 204);
                    item.setForeground(itemColor);
                    itemColor.dispose();
                    continue;
                }
                itemColor = new Color((org.eclipse.swt.graphics.Device)Display.getCurrent(), 0, 153, 76);
                item.setForeground(itemColor);
                FontData fontData = new FontData("Arial", 9, 2);
                Font itemFont = new Font((org.eclipse.swt.graphics.Device)this.tblDependencies.getDisplay(), fontData);
                item.setFont(itemFont);
                itemColor.dispose();
                itemFont.dispose();
            }
        }
    }

    public void initScreen() {
        ArrayList<String> sensorTypes = this.infoStore.getAllSensorTypeNames(this._sensor != null && this._sensor.getLuid().getIsPhysical() || this._newPhysicalSensor);
        for (String sensorTypeName : sensorTypes) {
            this.cmbSensorTypeId.add(sensorTypeName);
        }
        this.cmbSensorTypeId.add(CUSTOM_VALUE_TEXT);
        ArrayList<String> vendors = this.infoStore.getAllVendorNames();
        for (String vendor : vendors) {
            this.cmbVendorID.add(vendor);
        }
        this.cmbVendorID.add(CUSTOM_VALUE_TEXT);
        this.updateModelList();
        this.refreshDependencies();
    }

    public void updateModelList() {
        ArrayList<String> models;
        String oldData = this.cmbModelID.getText();
        boolean modified = this._properties.isModified();
        this.cmbModelID.removeAll();
        Integer sensorTypeId = this.infoStore.getSensorTypeId(this.cmbSensorTypeId.getText(), this.chbIsPhysical.getSelection());
        Integer vendorId = this.infoStore.getVendorId(this.cmbVendorID.getText());
        if (sensorTypeId != null && vendorId != null && (models = this.infoStore.getAllModelsOfVendorAndSensorType(this.chbIsPhysical.getSelection(), sensorTypeId, vendorId)) != null && models.size() != 0) {
            for (String model : models) {
                this.cmbModelID.add(model);
            }
        }
        this.cmbModelID.add(CUSTOM_VALUE_TEXT);
        this.cmbModelID.setText(oldData);
        GuiUtils.chooseComboItemByValue(this.cmbModelID);
        this._properties.setModified(modified);
    }

    public void fillSensorData() {
        Sensor sensor = this._sensor;
        if (this._device != null) {
            this.shlSensorModifier.setText(this._device.getDeviceName() + " - " + this.shlSensorModifier.getText());
        }
        if (sensor == null) {
            if (this._initialValuesHolder != null) {
                sensor = this._initialValuesHolder;
            } else {
                this.chbIsPhysical.setSelection(this._newPhysicalSensor);
                this.adjustWindowToPhysical(this._newPhysicalSensor);
            }
        }
        if (DataStore.getInstance().getPdtFormatVersion() >= 4) {
            this.chbMsExt.setEnabled(false);
            this.chbAndroidExt.setEnabled(false);
            this.chbSyntethic.setVisible(false);
            this.gd_chbSyntethic.exclude = true;
        }
        if (sensor != null) {
            this.adjustWindowToPhysical(sensor.getLuid().getIsPhysical());
            this.chbCalibrated.setSelection(sensor.getLuid().getIsCalibrated());
            this.chbIsPhysical.setSelection(sensor.getLuid().getIsPhysical());
            this.chbMsExt.setSelection(sensor.getLuid().getIsMsExt());
            this.chbAndroidExt.setSelection(sensor.getLuid().getIsAndroidExt());
            this.chbSyntethic.setSelection(sensor.getLuid().getIsSynthetic());
            this.chbNotExposed.setSelection(sensor.getLuid().getIsNotExposed());
            this.chbCustom.setSelection(sensor.getLuid().getIsCustom());
            this.chbWakeable.setSelection(sensor.getLuid().getIsWakeable());
            if (sensor.isMetadataAvalible()) {
                this.chbCalibrated.setEnabled(false);
                this._calibratedFlagEditable = false;
                this._enableSensorType = false;
                this._enableModel = false;
                this.cmbVendorID.setEnabled(false);
            }
            if (sensor.getLuid().isCodeDefinesNotExposed()) {
                this.chbNotExposed.setEnabled(false);
            }
            if (sensor.getLuid().isCodeDefinesCustom()) {
                this.chbCustom.setEnabled(false);
            }
            this.cmbSensorTypeId.setText(this.infoStore.getSensorTypeName(sensor.getLuid().getSensorTypeId(), sensor.getLuid().getIsPhysical()));
            GuiUtils.chooseComboItemByValue(this.cmbSensorTypeId);
            this.cmbVendorID.setText(this.infoStore.getVendorName(sensor.getLuid().getVendorId()));
            GuiUtils.chooseComboItemByValue(this.cmbVendorID);
            this.updateModelList();
            this.cmbModelID.setText(this.infoStore.getModelName(sensor.getLuid().getIsPhysical(), sensor.getLuid().getSensorTypeId(), sensor.getLuid().getVendorId(), sensor.getLuid().getSensorSubTypeId(), sensor.getLuid().getFlags()));
            GuiUtils.chooseComboItemByValue(this.cmbModelID);
            this.txtInstance.setSelection(sensor.getLuid().getInstanceId());
            PdtUpdateModes.SensorUpdateModes updateModes = sensor.getSensorUpdateMode();
            if (updateModes != null) {
                this.cmbCalibUpdateMode.setText(updateModes.calibrationUpdateMode.getFriendlyName());
                GuiUtils.chooseComboItemByValue(this.cmbCalibUpdateMode);
            }
            CalibrationPayload clibrationPayload = (CalibrationPayload)sensor.getPayloadByClass(CalibrationPayload.class);
            ConfigurationPayload configurationPayload = (ConfigurationPayload)sensor.getPayloadByClass(ConfigurationPayload.class);
            GuidPayload guidPayload = (GuidPayload)sensor.getPayloadByClass(GuidPayload.class);
            BusPayload busPayload = (BusPayload)sensor.getPayloadByClass(BusPayload.class);
            if (clibrationPayload != null) {
                this._calibration = clibrationPayload.clone();
            }
            if (configurationPayload != null) {
                this._configuration = configurationPayload.clone();
            }
            if (guidPayload != null) {
                this.txtGuid.setText(guidPayload.getGuid());
            }
            this.refreshCalibrationData();
            this._busInfo.fillData(busPayload, sensor);
            GpioPayload gpioPayload = (GpioPayload)sensor.getPayloadByClass(GpioPayload.class);
            if (gpioPayload != null) {
                this._gpioInfo.fillData(gpioPayload);
            }
            if (this._setBusFieldsFromMetadata) {
                this._busInfo.autofillBusFromMetadata(sensor);
            }
            this._flagsModified = sensor.getLuid().isFlagsModified();
        }
    }

    public Shell getShell() {
        return this.shlSensorModifier;
    }

    private void onLuidFieldModification() {
        this.enableConfAndCalibAddButtons();
        this.refreshDependencies();
    }

    public Luid getSensorLuidFromFields(boolean silentMode) {
        int sensType = -1;
        if (this.cmbSensorTypeId.getSelectionIndex() < 0) {
            try {
                int res = Integer.valueOf(this.cmbSensorTypeId.getText());
                if (res < 0 || res > Luid.SENSOR_TYPE_FIELD_MAX_VALUE) {
                    throw new NumberFormatException();
                }
                sensType = res;
            }
            catch (NumberFormatException e) {
                if (!silentMode) {
                    MessageBox messageBox = new MessageBox(this.shlSensorModifier, 513);
                    messageBox.setText("Invalid Sensor Type Value");
                    messageBox.setMessage("Invalid sensor type value. Please choose a value from the list or enter an integer in the range [0," + Luid.SENSOR_TYPE_FIELD_MAX_VALUE + "].");
                    messageBox.open();
                    this.cmbSensorTypeId.setFocus();
                }
                return null;
            }
        } else {
            Integer value = this.infoStore.getSensorTypeId(this.cmbSensorTypeId.getText().trim(), this.chbIsPhysical.getSelection());
            sensType = value != null ? value : sensType;
        }
        int vendorID = -1;
        if (this.cmbVendorID.getSelectionIndex() < 0) {
            try {
                int res = Integer.valueOf(this.cmbVendorID.getText());
                if (res < 0 || res > Luid.VENDOR_FIELD_MAX_VALUE) {
                    throw new NumberFormatException();
                }
                vendorID = res;
            }
            catch (NumberFormatException e) {
                if (!silentMode) {
                    MessageBox messageBox = new MessageBox(this.shlSensorModifier, 513);
                    messageBox.setText("Invalid Vendor Value");
                    messageBox.setMessage("Invalid vendor value. Please choose a value from the list or enter an integer in the range [0," + Luid.VENDOR_FIELD_MAX_VALUE + "].");
                    messageBox.open();
                    this.cmbVendorID.setFocus();
                }
                return null;
            }
        } else {
            Integer value = this.infoStore.getVendorId(this.cmbVendorID.getText().trim());
            vendorID = value != null ? value : vendorID;
        }
        int modelType = -1;
        if (this.cmbModelID.getSelectionIndex() < 0) {
            try {
                modelType = Integer.valueOf(this.cmbModelID.getText());
            }
            catch (NumberFormatException e) {
                if (!silentMode) {
                    MessageBox messageBox = new MessageBox(this.shlSensorModifier, 513);
                    messageBox.setText("Invalid Sensor Model Value");
                    messageBox.setMessage("Invalid sensor model value. Please choose a value from the list or enter an integer in the range [0," + Luid.MODEL_FIELD_MAX_VALUE + "].");
                    messageBox.open();
                    this.cmbModelID.setFocus();
                }
                return null;
            }
            if (modelType < 0 || modelType > Luid.MODEL_FIELD_MAX_VALUE) {
                if (!silentMode) {
                    MessageBox messageBox = new MessageBox(this.shlSensorModifier, 513);
                    messageBox.setText("Invalid Sensor Model Value");
                    messageBox.setMessage("Invalid sensor model value. Please choose a value from the list or enter an integer in the range [0," + Luid.MODEL_FIELD_MAX_VALUE + "].");
                    messageBox.open();
                    this.cmbModelID.setFocus();
                }
                return null;
            }
        } else {
            Integer value = this.infoStore.getModelId(this.chbIsPhysical.getSelection(), sensType, vendorID, this.cmbModelID.getText().trim());
            modelType = value != null ? value : modelType;
        }
        int instanceId = this.txtInstance.getSelection();
        try {
            Luid luid = new Luid(sensType, modelType, vendorID, instanceId, 0);
            luid.setIsCalibrated(this.chbCalibrated.getSelection());
            luid.setIsPhysical(this.chbIsPhysical.getSelection());
            luid.setIsMsExt(this.chbMsExt.getSelection());
            luid.setIsAndroidExt(this.chbAndroidExt.getSelection());
            luid.setIsSynthetic(this.chbSyntethic.getSelection());
            luid.setIsNotExposed(this.chbNotExposed.getSelection());
            luid.setIsCustom(this.chbCustom.getSelection());
            luid.setFlagsModified(this._flagsModified);
            luid.setIsWakeable(this.chbWakeable.getSelection());
            return luid;
        }
        catch (NumberFormatException e) {
            if (!silentMode) {
                MessageBox messageBox = new MessageBox(this.shlSensorModifier, 513);
                messageBox.setText("Input Error");
                messageBox.setMessage("One of the basic details fields does not contain a valid number");
                messageBox.open();
            }
            return null;
        }
    }

    public void onModelLostFocus() {
        if (this.cmbModelID.getSelectionIndex() < 0) {
            if (this.cmbModelID.getText().isEmpty()) {
                Color background = new Color((org.eclipse.swt.graphics.Device)this.display, 255, 255, 255);
                this.cmbModelID.setBackground(background);
                background.dispose();
                return;
            }
            try {
                int res = Integer.valueOf(this.cmbModelID.getText());
                if (res < 0 || res > Luid.MODEL_FIELD_MAX_VALUE) {
                    MessageBox messageBox = new MessageBox(this.shlSensorModifier, 33);
                    messageBox.setText("Invalid Sensor Model Value");
                    messageBox.setMessage("Invalid sensor model value. Please choose a value from the list or enter an integer in the range [0," + Luid.MODEL_FIELD_MAX_VALUE + "].");
                    messageBox.open();
                    return;
                }
                if (!(this._sensor != null && this._sensor.getLuid() != null && this._sensor.getLuid().isModelIdEqualToMetadatas(res) || res > Luid.MODEL_ID_INTEL_MANAGED_RANGE[1] || this._modelValIntelRangeNotified)) {
                    Color background = new Color((org.eclipse.swt.graphics.Device)this.display, 255, 255, 204);
                    this.cmbModelID.setBackground(background);
                    background.dispose();
                    this.modelHoverTooltip = GuiUtils.showBaloon(this.shlSensorModifier, (Control)this.cmbModelID, "The value you entered under Model is in the range managed by Intel ([" + Luid.MODEL_ID_INTEL_MANAGED_RANGE[0] + "," + Luid.MODEL_ID_INTEL_MANAGED_RANGE[1] + "]).");
                } else {
                    if (this.modelHoverTooltip != null && !this.modelHoverTooltip.isDisposed()) {
                        this.modelHoverTooltip.setVisible(false);
                        this.modelHoverTooltip.dispose();
                        this.modelHoverTooltip = null;
                    }
                    Color background = new Color((org.eclipse.swt.graphics.Device)this.display, 255, 255, 255);
                    this.cmbModelID.setBackground(background);
                    background.dispose();
                }
            }
            catch (NumberFormatException e) {
                MessageBox messageBox = new MessageBox(this.shlSensorModifier, 33);
                messageBox.setText("Invalid Sensor Model Value");
                messageBox.setMessage("Invalid sensor model value. Please choose a value from the list or enter an integer in the range [0," + Luid.MODEL_FIELD_MAX_VALUE + "].");
                messageBox.open();
            }
        }
    }

    public void autoAddDefaultCalibration() {
        List<CalibrationPayload.PayloadFormatInfo> suggestions;
        if (this._calibration != null || this._configuration != null) {
            return;
        }
        try {
            Luid luid = this.getSensorLuidFromFields(true);
            if (luid == null) {
                return;
            }
            suggestions = CalibrationPayload.getCalibrationType(luid, -1, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        if (suggestions == null) {
            return;
        }
        Integer suggestion = suggestions.get((int)0).format;
        if (suggestion == null) {
            return;
        }
        switch (suggestion) {
            case 2: {
                this._calibration = new VirtualAcclCalibrationPayload();
                break;
            }
            case 3: {
                this._calibration = new VirtualGyroCalibrationPayload();
                break;
            }
            case 4: {
                this._calibration = new VirtualMagCalibrationPayload();
                break;
            }
            default: {
                return;
            }
        }
    }

    public void saveSensorData() {
        Luid luid;
        boolean newSensor = false;
        Sensor sensor = this._sensor;
        if (sensor == null) {
            newSensor = true;
            sensor = new Sensor(new Luid(0, 0, 0, 0, 0));
            if (this._initialValuesHolder != null) {
                sensor.updateMetaData(this._initialValuesHolder);
            }
        }
        if ((luid = this.getSensorLuidFromFields(false)) == null) {
            return;
        }
        if (this._sensor != null && sensor.isMetadataAvalible()) {
            luid.setMetadataFlags(sensor.getLuid());
        }
        if (this._device != null && DataStore.getInstance().getCurrentPdtFile() != null && DataStore.getInstance().getCurrentPdtFile().containsSensorWithEquivalentLuid(luid, this._sensor, false)) {
            MessageBox messageBox = new MessageBox(this.shlSensorModifier, 513);
            messageBox.setText("Duplicated Sensor");
            messageBox.setMessage("The PDT already contains a sensor with the same basic details and flags. Such duplications are forbidden.");
            messageBox.open();
            return;
        }
        if (sensor.getLuid() != null && !sensor.getLuid().staticEquals(luid)) {
            sensor.setDependencies(null);
        }
        sensor.setLuid(luid);
        try {
            PdtUpdateModes.SensorUpdateModes updateModes = new PdtUpdateModes.SensorUpdateModes();
            updateModes.calibrationUpdateMode = PdtUpdateModes.CalibrationUpdateMode.getValueOfName(this.cmbCalibUpdateMode.getText());
            sensor.setSensorUpdateMode(updateModes);
        }
        catch (Exception e) {
            MessageBox messageBox = new MessageBox(this.shlSensorModifier, 33);
            messageBox.setText("Invalid value");
            messageBox.setMessage("Please choose one the value for the calibration update mode from the list.");
            messageBox.open();
            this.cmbCalibUpdateMode.setFocus();
            return;
        }
        if (!this.txtGuid.getText().isEmpty() && this._device != null && DataStore.getInstance().getCurrentPdtFile() != null && DataStore.getInstance().getCurrentPdtFile().containsSensorWithEquivalentGuid(this.txtGuid.getText(), this._sensor)) {
            MessageBox messageBox = new MessageBox(this.shlSensorModifier, 513);
            messageBox.setText("Duplicated GUID");
            messageBox.setMessage("The PDT already contains a sensor with the same GUID. Such duplications are forbidden.");
            messageBox.open();
            return;
        }
        this.autoAddDefaultCalibration();
        if (this._calibration == null) {
            sensor.removeAllPayloadsByClass(CalibrationPayload.class);
        } else {
            CalibrationPayload clibrationPayload = (CalibrationPayload)sensor.getPayloadByClass(CalibrationPayload.class);
            sensor.replacePayload(clibrationPayload, this._calibration);
        }
        if (this._configuration == null) {
            sensor.removeAllPayloadsByClass(ConfigurationPayload.class);
        } else {
            ConfigurationPayload configurationPayload = (ConfigurationPayload)sensor.getPayloadByClass(ConfigurationPayload.class);
            sensor.replacePayload(configurationPayload, this._configuration);
        }
        try {
            BusPayload bus = this._busInfo.busPayloadFromFields();
            if (bus == null) {
                sensor.removeAllPayloadsByClass(BusPayload.class);
            } else {
                BusPayload busPayload = (BusPayload)sensor.getPayloadByClass(BusPayload.class);
                sensor.replacePayload(busPayload, bus);
            }
        }
        catch (Exception e) {
            MessageBox messageBox = new MessageBox(this.shlSensorModifier, 513);
            messageBox.setText("Bus Information");
            messageBox.setMessage(e.getMessage() != null ? e.getMessage() : "Unknown Error: " + e.getStackTrace());
            messageBox.open();
            return;
        }
        try {
            GpioPayload gpioPayload = this._gpioInfo.gpioPayloadFromFields();
            if (gpioPayload == null || gpioPayload.getGpios().size() == 0) {
                sensor.removeAllPayloadsByClass(GpioPayload.class);
            } else {
                GpioPayload gpioPayloadSrc = (GpioPayload)sensor.getPayloadByClass(GpioPayload.class);
                sensor.replacePayload(gpioPayloadSrc, gpioPayload);
            }
        }
        catch (Exception e) {
            MessageBox messageBox = new MessageBox(this.shlSensorModifier, 513);
            messageBox.setText("GPIO Information");
            messageBox.setMessage(e.getMessage() != null ? e.getMessage() : "Unknown Error: " + e.getStackTrace());
            messageBox.open();
            return;
        }
        if (!this.txtGuid.getText().isEmpty()) {
            GuidPayload guidPayload = new GuidPayload(this.txtGuid.getText());
            sensor.removeAllPayloadsByClass(GuidPayload.class);
            sensor.addPayload(guidPayload);
        } else {
            sensor.removeAllPayloadsByClass(GuidPayload.class);
        }
        if (newSensor) {
            if (this._device != null) {
                this._device.addSensor(sensor);
            } else {
                this._parent.addSensor(sensor);
            }
        }
        this._sensor = sensor;
        this._properties.setModified(false);
        this._parent.refresh();
        this._parent.setModified();
        this.shlSensorModifier.close();
        this._parent.selectSensor(this._sensor);
    }

    public void editCalibration() {
        Luid luid = this.getSensorLuidFromFields(false);
        if (luid == null) {
            return;
        }
        Sensor detailsHolderSensor = new Sensor(luid);
        if (this._sensor != null) {
            detailsHolderSensor.updateMetaData(this._sensor);
        }
        try {
            PayloadUtils.openCalibrationWindow(this._calibration, detailsHolderSensor, this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void refresh() {
        this.interruptsTableViewer.refresh();
    }

    public Sensor getSensor() {
        return this._sensor;
    }

    public String getModelId() {
        return this.cmbModelID.getText() == null ? "" : this.cmbModelID.getText();
    }

    private void onTextboxModification() {
        this.setModified();
    }

    private void onBasicInfoFieldSelection(Combo combo, Control nextControl) {
        GuiUtils.chooseComboItemByValue(combo);
        if (combo.getSelectionIndex() == combo.getItemCount() - 1) {
            combo.setText("");
            combo.deselectAll();
            new CustomValueGetter(this, combo, nextControl).open();
        }
    }

    @Override
    public void addNewCalibration(Sensor sensor, CalibrationPayload calibration) {
        this._calibration = calibration;
        this.refreshCalibrationData();
        this.setModified();
    }

    @Override
    public boolean hasSensorInTable(Sensor sensor) {
        return sensor.equals(this._sensor);
    }

    @Override
    public Device getCurrentDevice() {
        return this._device;
    }

    @Override
    public void setModified() {
        this._properties.setModified(true);
    }

    public void addNewConfiguration(ConfigurationPayload configuration) {
        this._configuration = configuration;
        this.refreshCalibrationData();
        this.setModified();
    }

    public void fillBusFileds(BusInfo busInfo) {
        this._busInfo.copyBusInfo(busInfo);
    }

    public void setBusInfoFromMetadata(boolean autoFill) {
        this._setBusFieldsFromMetadata = autoFill;
    }

    public BusInfo getBusInfo() {
        return this._busInfo;
    }

    public GpioInfo getGpioInfo() {
        return this._gpioInfo;
    }

    public void setCalibUpdateModeEnability(boolean enable) {
        if (this.lblUponPdtUpdate != null && !this.lblUponPdtUpdate.isDisposed()) {
            this.lblUponPdtUpdate.setEnabled(enable);
        }
        if (this.cmbCalibUpdateMode != null && !this.cmbCalibUpdateMode.isDisposed()) {
            this.cmbCalibUpdateMode.setEnabled(enable);
        }
    }

    @Override
    public void refreshCalibrationData() {
        boolean hasConfiguration;
        boolean hasCalibration = this._calibration != null;
        boolean bl = hasConfiguration = this._configuration != null;
        if (hasConfiguration) {
            this.lblCalibrationType.setText("Configuration Format:\n" + this._configuration.getConfigurationFormatString());
            this.btnCalibrationDelete.setEnabled(false);
            this.btnCalibrationModify.setEnabled(false);
            this.btnConfigurationModify.setEnabled(true);
            this.btnConfigurationModify.setText(MODIFY_CONFIGURATION_TEXT);
            this.btnConfigurationDelete.setEnabled(true);
            this.cmbCalibUpdateMode.select(PdtUpdateModes.CalibrationUpdateMode.OVERWRITE.getValue());
            this.setCalibUpdateModeEnability(false);
        } else if (hasCalibration) {
            this.lblCalibrationType.setText("Calibration Format:\n" + this._calibration.getCalibrationFormatString());
            this.btnCalibrationDelete.setEnabled(true);
            this.btnCalibrationModify.setEnabled(true);
            this.btnCalibrationModify.setText(MODIFY_CALIBRATION_TEXT);
            this.btnConfigurationModify.setEnabled(false);
            this.btnConfigurationDelete.setEnabled(false);
            this.setCalibUpdateModeEnability(true);
        } else {
            this.lblCalibrationType.setText(NO_CALIBRATION_TEXT);
            this.btnCalibrationDelete.setEnabled(false);
            this.btnCalibrationModify.setText(NEW_CALIBRATION_TEXT);
            this.btnConfigurationModify.setText(NEW_CONFIGURATION_TEXT);
            this.btnConfigurationDelete.setEnabled(false);
            this.setCalibUpdateModeEnability(false);
            this.cmbCalibUpdateMode.select(PdtUpdateModes.CalibrationUpdateMode.DEFAULT.getValue());
            this.enableConfAndCalibAddButtons();
        }
        this.cmbSensorTypeId.setEnabled(this._enableSensorType && !hasCalibration && !hasConfiguration);
        this._fieldLockedInfoText = hasCalibration ? "In order to modify this field, the sensor calibration data must first be deleted." : (hasConfiguration ? "In order to modify this field, the sensor configuration data must first be deleted." : "");
        this.cmbSensorTypeId.setToolTipText(this._fieldLockedInfoText);
        this.btnSensorTypeInfo.setToolTipText(this._fieldLockedInfoText);
        this.cmbModelID.setEnabled(this._enableModel && !hasCalibration && !hasConfiguration);
        this.btnSensorTypeInfo.setVisible(this._enableSensorType && (hasCalibration || hasConfiguration));
        this.btnModelInfo.setToolTipText(this._fieldLockedInfoText);
        this.btnModelInfo.setVisible(this._enableModel && (hasCalibration || hasConfiguration));
        this.chbCalibrated.setEnabled(this._calibratedFlagEditable && !hasCalibration && !hasConfiguration);
        this.btnCalibratedInfo.setToolTipText(this._fieldLockedInfoText);
        this.btnCalibratedInfo.setVisible(this._calibratedFlagEditable && (hasCalibration || hasConfiguration));
        if (!this.chbCalibrated.getEnabled() && this.chbCalibrated.getSelection()) {
            this.btnCalibrationDelete.setEnabled(false);
        }
    }

    public void enableConfAndCalibAddButtons() {
        if (this._calibration != null || this._configuration != null) {
            return;
        }
        Luid luid = this.getSensorLuidFromFields(true);
        if (luid == null) {
            if (this.btnCalibrationModify != null && !this.btnCalibrationModify.isDisposed()) {
                this.btnCalibrationModify.setEnabled(false);
            }
            if (this.btnConfigurationModify != null && !this.btnConfigurationModify.isDisposed()) {
                this.btnConfigurationModify.setEnabled(false);
            }
            return;
        }
        try {
            List<CalibrationPayload.PayloadFormatInfo> payloadSuggestions = CalibrationPayload.getCalibrationType(luid, -1, false);
            for (CalibrationPayload.PayloadFormatInfo payloadSuggestion : payloadSuggestions) {
                if (payloadSuggestion.dataType == 0) {
                    this.btnCalibrationModify.setEnabled(true);
                    continue;
                }
                if (payloadSuggestion.dataType != 1) continue;
                this.btnConfigurationModify.setEnabled(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public void editSensorConfiguration() {
        Luid luid = this.getSensorLuidFromFields(false);
        if (luid == null) {
            return;
        }
        Sensor detailsHolderSensor = new Sensor(luid);
        if (this._sensor != null) {
            detailsHolderSensor.updateMetaData(this._sensor);
        }
        try {
            PayloadUtils.openConfigurationWindow(this._configuration, detailsHolderSensor, this);
        }
        catch (Exception e) {
            MessageBox messageBox = new MessageBox(this.shlSensorModifier, 34);
            messageBox.setText("Sensor Configuration");
            messageBox.setMessage(e.getMessage());
            messageBox.open();
        }
    }

    public void setFixDescription(String description) {
        this._fixDescription = description;
    }

    public void highlightControls() {
        HashMap<Object, Issue.IssueType> toHighlight = new HashMap<Object, Issue.IssueType>();
        if (this._highlightBasic != null) {
            toHighlight.put(this.grpBasicDetails, this._highlightBasic);
        }
        if (this._highlightSensorInstance != null) {
            toHighlight.put(this.txtInstance, this._highlightSensorInstance);
        }
        if (this._highlightBus != null) {
            toHighlight.put(this.grpBus, this._highlightBus);
        }
        if (this._highlightCalibration != null) {
            toHighlight.put(this.grpCalibration, this._highlightCalibration);
        }
        if (this._highlightFlags != null) {
            toHighlight.put(this.grpFlags, this._highlightFlags);
        }
        if (this._highlightGpio != null) {
            for (Control control : this.getGpioControls()) {
                toHighlight.put(control, this._highlightGpio);
            }
        }
        if (this._highlightBusInstance != null) {
            toHighlight.put(this._busInfo.getBusInstanceControl(), this._highlightBusInstance);
        }
        for (Object object : toHighlight.keySet()) {
            switch ((Issue.IssueType)toHighlight.get(object)) {
                case CRITICAL: {
                    GuiUtils.highlightItemError(object);
                    break;
                }
                case WARNING: {
                    GuiUtils.highlightItemWarning(object);
                    break;
                }
                case NOTIFICATION: {
                    GuiUtils.highlightItemInfo(object);
                }
            }
        }
    }

    public void highlightBasicInfo(Issue.IssueType type) {
        this._highlightBasic = type;
    }

    public void highlightSensorInstance(Issue.IssueType type) {
        this._highlightSensorInstance = type;
    }

    public void highlightBusInfo(Issue.IssueType type) {
        this._highlightBus = type;
    }

    public void highlightFlagsInfo(Issue.IssueType type) {
        this._highlightFlags = type;
    }

    public void highlightCalibrationInfo(Issue.IssueType type) {
        this._highlightCalibration = type;
    }

    public void highlightGpioInfo(Issue.IssueType type) {
        this._highlightGpio = type;
    }

    public void highlightBusInstance(Issue.IssueType type) {
        this._highlightBusInstance = type;
    }

    public void markFlagsModified(boolean modified) {
        this._setFlagsModified = modified;
    }

    protected void createContents() {
        int modal = this._modal ? 65536 : 0;
        this.shlSensorModifier = new Shell(0xE0 | modal);
        this.shlSensorModifier.setImage(SWTResourceManager.getImage(SensorModifier.class, "/resources/Intel.ico"));
        this.shlSensorModifier.setText("Sensor Modifier");
        GuiUtils.setGridLayoutToComposite((Composite)this.shlSensorModifier, 2, true);
        this.shlSensorModifier.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                if (SensorModifier.this._properties.isModified()) {
                    MessageBox messageBox = new MessageBox(SensorModifier.this.shlSensorModifier, 296);
                    messageBox.setText("Closing the Sensor Modifier");
                    messageBox.setMessage("Some changes will be lost. Are you sure that you want to close the 'Sensor Modifier' window?");
                    if (messageBox.open() != 32) {
                        e.doit = false;
                        return;
                    }
                }
                SensorModifier.this._parent.onSensorModifierClose(SensorModifier.this._thisModifier);
            }

            public void shellActivated(ShellEvent arg0) {
                SensorModifier.this.refreshDependencies();
            }
        });
        this.lblIsPhysicalSensor = new Label((Composite)this.shlSensorModifier, 0);
        this.lblIsPhysicalSensor.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.lblIsPhysicalSensor.setFont(SWTResourceManager.getFont("Segoe UI", 9, 3));
        this.lblIsPhysicalSensor.setText("Physical/Virtual ");
        this.chbIsPhysical = new Button((Composite)this.shlSensorModifier, 32);
        GridData gd_chbIsPhysical = new GridData(131072, 0x1000000, false, false, 1, 1);
        this.chbIsPhysical.setLayoutData((Object)gd_chbIsPhysical);
        this.chbIsPhysical.setEnabled(false);
        this.chbIsPhysical.setSelection(true);
        this.chbIsPhysical.setText("Physical");
        this.chbIsPhysical.setVisible(false);
        this.chbIsPhysical.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        Text txtFixDescription = new Text((Composite)this.shlSensorModifier, 2082);
        txtFixDescription.setBackground(SWTResourceManager.getColor(29));
        GridData gd_txtFixDescription = new GridData(4, 0x1000000, true, false, 2, 1);
        txtFixDescription.setLayoutData((Object)gd_txtFixDescription);
        txtFixDescription.setEditable(false);
        gd_txtFixDescription.heightHint = this.lblIsPhysicalSensor.computeSize((int)-1, (int)-1).y * 2;
        if (this._fixDescription == null) {
            txtFixDescription.setVisible(false);
            gd_txtFixDescription.exclude = true;
        } else {
            txtFixDescription.setText(this._fixDescription);
        }
        this.grpBasicDetails = new Group((Composite)this.shlSensorModifier, 0);
        this.grpBasicDetails.setText("Basic Details");
        this.grpBasicDetails.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        GuiUtils.setGridLayoutToComposite((Composite)this.grpBasicDetails, 3);
        this.lblSensorTypeId = new Label((Composite)this.grpBasicDetails, 0);
        this.lblSensorTypeId.setFont(SWTResourceManager.getFont("Segoe UI", 9, 1));
        this.lblSensorTypeId.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.lblSensorTypeId.setText("Sensor Type:");
        this.btnSensorTypeInfo = new Button((Composite)this.grpBasicDetails, 0);
        GridData gd_btnSensorTypeInfo = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_btnSensorTypeInfo.widthHint = this.btnSensorTypeInfo.computeSize((int)-1, (int)-1).y;
        this.btnSensorTypeInfo.setLayoutData((Object)gd_btnSensorTypeInfo);
        this.btnSensorTypeInfo.setText("?");
        this.btnSensorTypeInfo.setVisible(false);
        this.btnSensorTypeInfo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MessageBox messageBox = new MessageBox(SensorModifier.this.shlSensorModifier, 34);
                messageBox.setText("Sensor Type");
                messageBox.setMessage(SensorModifier.this._fieldLockedInfoText);
                messageBox.open();
            }
        });
        this.cmbSensorTypeId = new Combo((Composite)this.grpBasicDetails, 0);
        this.cmbSensorTypeId.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.cmbSensorTypeId.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SensorModifier.this.onTextboxModification();
                GuiUtils.chooseComboItemByValue(SensorModifier.this.cmbSensorTypeId);
                SensorModifier.this.onBasicInfoFieldSelection(SensorModifier.this.cmbSensorTypeId, (Control)SensorModifier.this.cmbVendorID);
                SensorModifier.this.onLuidFieldModification();
            }
        });
        this.cmbSensorTypeId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                SensorModifier.this.onTextboxModification();
                SensorModifier.this.onLuidFieldModification();
                GuiUtils.chooseComboItemByValue(SensorModifier.this.cmbSensorTypeId);
                SensorModifier.this.updateModelList();
            }
        });
        this.cmbSensorTypeId.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
            }
        });
        this.lblVendorId = new Label((Composite)this.grpBasicDetails, 0);
        this.lblVendorId.setFont(SWTResourceManager.getFont("Segoe UI", 9, 1));
        this.lblVendorId.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.lblVendorId.setText("Vendor:");
        this.cmbVendorID = new Combo((Composite)this.grpBasicDetails, 0);
        this.cmbVendorID.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.cmbVendorID.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                GuiUtils.chooseComboItemByValue(SensorModifier.this.cmbVendorID);
                SensorModifier.this.onBasicInfoFieldSelection(SensorModifier.this.cmbVendorID, (Control)SensorModifier.this.cmbModelID);
            }
        });
        this.cmbVendorID.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                SensorModifier.this.onTextboxModification();
                GuiUtils.chooseComboItemByValue(SensorModifier.this.cmbVendorID);
                SensorModifier.this.updateModelList();
            }
        });
        this.cmbVendorID.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
            }
        });
        this.lblSensorModelId = new Label((Composite)this.grpBasicDetails, 0);
        this.lblSensorModelId.setFont(SWTResourceManager.getFont("Segoe UI", 9, 1));
        this.lblSensorModelId.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.lblSensorModelId.setText("Model:");
        this.btnModelInfo = new Button((Composite)this.grpBasicDetails, 0);
        GridData gd_btnModelInfo = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_btnModelInfo.widthHint = this.btnModelInfo.computeSize((int)-1, (int)-1).y;
        this.btnModelInfo.setLayoutData((Object)gd_btnModelInfo);
        this.btnModelInfo.setVisible(false);
        this.btnModelInfo.setText("?");
        this.btnModelInfo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MessageBox messageBox = new MessageBox(SensorModifier.this.shlSensorModifier, 34);
                messageBox.setText("Sensor Model");
                messageBox.setMessage(SensorModifier.this._fieldLockedInfoText);
                messageBox.open();
            }
        });
        this.cmbModelID = new Combo((Composite)this.grpBasicDetails, 0);
        this.cmbModelID.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.cmbModelID.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                GuiUtils.chooseComboItemByValue(SensorModifier.this.cmbModelID);
                SensorModifier.this.onBasicInfoFieldSelection(SensorModifier.this.cmbModelID, (Control)SensorModifier.this.txtInstance.getBasicSpinner());
            }
        });
        this.cmbModelID.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                SensorModifier.this.onModelLostFocus();
            }
        });
        this.cmbModelID.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GuiUtils.chooseComboItemByValue(SensorModifier.this.cmbModelID);
                SensorModifier.this.onTextboxModification();
                SensorModifier.this.onLuidFieldModification();
                SensorModifier.this._modelValIntelRangeNotified = false;
            }
        });
        this.lblInstance = new Label((Composite)this.grpBasicDetails, 0);
        this.lblInstance.setFont(SWTResourceManager.getFont("Segoe UI", 9, 1));
        this.lblInstance.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.lblInstance.setText("Instance:");
        this.txtInstance = new CustomSpinner((Composite)this.grpBasicDetails, 2048, this.shlSensorModifier);
        this.txtInstance.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtInstance.setMaximum(Luid.INSTANCE_FIELD_MAX_VALUE);
        this.txtInstance.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                SensorModifier.this.onTextboxModification();
                SensorModifier.this.onLuidFieldModification();
            }
        });
        Label lblGuid = new Label((Composite)this.grpBasicDetails, 0);
        lblGuid.setFont(SWTResourceManager.getFont("Segoe UI", 9, 1));
        lblGuid.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        lblGuid.setText("GUID:");
        this.txtGuid = new Text((Composite)this.grpBasicDetails, 2082);
        this.txtGuid.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.grpFlags = new Group((Composite)this.shlSensorModifier, 0);
        this.grpFlags.setText("Flags");
        this.grpFlags.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        GuiUtils.setGridLayoutToComposite((Composite)this.grpFlags, 2);
        this.chbCalibrated = new Button((Composite)this.grpFlags, 32);
        this.chbCalibrated.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.chbCalibrated.setText("Calibrated");
        this.chbCalibrated.setToolTipText("This sensor is, in and of itself, a dynamic calibration of another sensor.");
        this.chbCalibrated.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SensorModifier.this._flagsModified = true;
                SensorModifier.this.onLuidFieldModification();
            }
        });
        this.btnCalibratedInfo = new Button((Composite)this.grpFlags, 0);
        GridData gd_btnCalibratedInfo = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_btnCalibratedInfo.widthHint = this.btnCalibratedInfo.computeSize((int)-1, (int)-1).y;
        this.btnCalibratedInfo.setLayoutData((Object)gd_btnCalibratedInfo);
        this.btnCalibratedInfo.setVisible(false);
        gd_btnCalibratedInfo.exclude = true;
        this.btnCalibratedInfo.setText("?");
        this.btnCalibratedInfo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MessageBox messageBox = new MessageBox(SensorModifier.this.shlSensorModifier, 34);
                messageBox.setText("The Calibrated Flag");
                messageBox.setMessage(SensorModifier.this._fieldLockedInfoText);
                messageBox.open();
            }
        });
        this.chbMsExt = new Button((Composite)this.grpFlags, 32);
        this.gd_chbMsExt = new GridData(4, 0x1000000, false, false, 2, 1);
        this.chbMsExt.setLayoutData((Object)this.gd_chbMsExt);
        this.chbMsExt.setText("Microsoft extended");
        this.chbMsExt.setVisible(false);
        this.gd_chbMsExt.exclude = true;
        this.chbMsExt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SensorModifier.this._flagsModified = true;
                SensorModifier.this.onLuidFieldModification();
            }
        });
        this.chbAndroidExt = new Button((Composite)this.grpFlags, 32);
        this.gd_chbAndroidExt = new GridData(4, 0x1000000, false, false, 2, 1);
        this.chbAndroidExt.setLayoutData((Object)this.gd_chbAndroidExt);
        this.chbAndroidExt.setText("Android extended ");
        this.chbAndroidExt.setVisible(false);
        this.gd_chbAndroidExt.exclude = true;
        this.chbAndroidExt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SensorModifier.this._flagsModified = true;
                SensorModifier.this.onLuidFieldModification();
            }
        });
        this.chbNotExposed = new Button((Composite)this.grpFlags, 32);
        this.chbNotExposed.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.chbNotExposed.setText("Not Exposed");
        this.chbNotExposed.setToolTipText("This sensor will not be visible to the host.");
        this.chbNotExposed.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SensorModifier.this._flagsModified = true;
                SensorModifier.this.onLuidFieldModification();
            }
        });
        this.chbWakeable = new Button((Composite)this.grpFlags, 32);
        this.chbWakeable.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.chbWakeable.setText("Wakeable");
        this.chbWakeable.setToolTipText("This sensor is wakeable source.");
        this.chbWakeable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SensorModifier.this._flagsModified = true;
                SensorModifier.this.onLuidFieldModification();
            }
        });
        this.chbCustom = new Button((Composite)this.grpFlags, 32);
        this.chbCustom.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.chbCustom.setText("Custom");
        this.chbCustom.setToolTipText("This sensor will be exposed to the host only as an unrecognized, custom sensor.");
        this.chbCustom.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SensorModifier.this._flagsModified = true;
                SensorModifier.this.onLuidFieldModification();
            }
        });
        this.chbSyntethic = new Button((Composite)this.grpFlags, 32);
        this.gd_chbSyntethic = new GridData(4, 0x1000000, false, false, 2, 1);
        this.chbSyntethic.setLayoutData((Object)this.gd_chbSyntethic);
        this.chbSyntethic.setText("Synthetic");
        this.chbSyntethic.setEnabled(false);
        this.chbSyntethic.setVisible(false);
        this.gd_chbSyntethic.exclude = true;
        this.chbSyntethic.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SensorModifier.this._flagsModified = true;
                SensorModifier.this.onLuidFieldModification();
            }
        });
        try {
            this._busInfo = new BusInfo(this._properties);
            this._busInfo.filterBusTypes(InformationStore.getInstance().getSensorRelevantBusTypes());
            this.grpBus = this._busInfo.drawBusInfo(this.shlSensorModifier, (Composite)this.shlSensorModifier);
            this.gd_grpBus = new GridData(4, 4, true, false, 1, 1);
            this.grpBus.setLayoutData((Object)this.gd_grpBus);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.grpSensorIo = new Group((Composite)this.shlSensorModifier, 0);
        this.grpSensorIo.setText("Sensor I/O");
        this.gd_grpSensorIo = new GridData(4, 4, true, false, 1, 1);
        this.grpSensorIo.setLayoutData((Object)this.gd_grpSensorIo);
        GuiUtils.setGridLayoutToComposite((Composite)this.grpSensorIo, 1);
        this.grpSensorIo.setVisible(false);
        this.gd_grpSensorIo.exclude = true;
        this.btnManageGpio = new Button((Composite)this.grpSensorIo, 0);
        GridData gd_btnManageGpio = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_btnManageGpio.widthHint = GuiUtils.getButtonWidth((Control)this.shlSensorModifier);
        this.btnManageGpio.setLayoutData((Object)gd_btnManageGpio);
        this.btnManageGpio.setText("Manage GPIOs");
        this.btnManageGpio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    new GPIO(SensorModifier.this._gpioInfo).open();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.grpCalibration = new Group((Composite)this.shlSensorModifier, 0);
        this.grpCalibration.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        GuiUtils.setGridLayoutToComposite((Composite)this.grpCalibration, 3);
        this.grpCalibration.setText("Calibration and Configuration");
        this.lblCalibrationType = new Label((Composite)this.grpCalibration, 0);
        GridData gd_lblCalibrationType = new GridData(4, 4, true, true, 3, 1);
        gd_lblCalibrationType.heightHint = this.lblCalibrationType.computeSize((int)-1, (int)-1).y * 2;
        this.lblCalibrationType.setLayoutData((Object)gd_lblCalibrationType);
        this.lblCalibrationType.setText(NO_CALIBRATION_TEXT);
        this.btnCalibrationModify = new Button((Composite)this.grpCalibration, 0);
        this.btnCalibrationModify.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.btnCalibrationModify.setText(NEW_CALIBRATION_TEXT);
        this.btnCalibrationModify.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SensorModifier.this.editCalibration();
            }
        });
        this.btnCalibrationDelete = new Button((Composite)this.grpCalibration, 0);
        GridData gd_btnCalibrationDelete = new GridData(4, 0x1000000, true, false, 1, 1);
        this.btnCalibrationDelete.setLayoutData((Object)gd_btnCalibrationDelete);
        this.btnCalibrationDelete.setEnabled(false);
        this.btnCalibrationDelete.setText("Delete Calibration");
        this.btnCalibrationDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SensorModifier.this._calibration = null;
                SensorModifier.this.setModified();
                SensorModifier.this.refreshCalibrationData();
            }
        });
        this.btnConfigurationModify = new Button((Composite)this.grpCalibration, 0);
        this.btnConfigurationModify.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.btnConfigurationModify.setText(NEW_CONFIGURATION_TEXT);
        this.btnConfigurationModify.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SensorModifier.this.editSensorConfiguration();
            }
        });
        this.btnConfigurationDelete = new Button((Composite)this.grpCalibration, 0);
        GridData gd_btnConfigurationDelete = new GridData(4, 0x1000000, false, false, 1, 1);
        this.btnConfigurationDelete.setLayoutData((Object)gd_btnConfigurationDelete);
        this.btnConfigurationDelete.setEnabled(false);
        this.btnConfigurationDelete.setText("Delete Configuration");
        this.btnConfigurationDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (SensorModifier.this._configuration != null) {
                    int selection;
                    MessageBox messageBox;
                    if (SensorModifier.this._configuration.controllsBusData()) {
                        boolean removeBusData = true;
                        if (SensorModifier.this.grpBus.isVisible()) {
                            messageBox = new MessageBox(SensorModifier.this.shlSensorModifier, 456);
                            messageBox.setText("Deleting Bus Information");
                            messageBox.setMessage("The configuration that you're about to delete contains bus information. Do you want to delete the bus information?");
                            selection = messageBox.open();
                            if (selection == 256) {
                                return;
                            }
                            if (selection == 128) {
                                removeBusData = false;
                            }
                        }
                        if (removeBusData) {
                            SensorModifier.this._busInfo.clear();
                        }
                    }
                    if (SensorModifier.this._configuration.controllsGpioData()) {
                        boolean removeGpioData = true;
                        if (SensorModifier.this._gpioInfo != null && SensorModifier.this.grpGpio.isVisible()) {
                            messageBox = new MessageBox(SensorModifier.this.shlSensorModifier, 456);
                            messageBox.setText("Deleting GPIO Information");
                            messageBox.setMessage("The configuration that you're about to delete contains GPIO information. Do you want to delete the GPIO information?");
                            selection = messageBox.open();
                            if (selection == 256) {
                                return;
                            }
                            if (selection == 128) {
                                removeGpioData = false;
                            }
                        }
                        if (removeGpioData && SensorModifier.this._gpioInfo != null) {
                            SensorModifier.this._gpioInfo.clear();
                        }
                    }
                    SensorModifier.this._configuration = null;
                }
                SensorModifier.this.setModified();
                SensorModifier.this.refreshCalibrationData();
            }
        });
        this.btnUpdateModeInfo = new Button((Composite)this.grpCalibration, 0);
        GridData gd_btnUpdateModeInfo = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_btnUpdateModeInfo.widthHint = this.btnUpdateModeInfo.computeSize((int)-1, (int)-1).y;
        this.btnUpdateModeInfo.setLayoutData((Object)gd_btnUpdateModeInfo);
        this.btnUpdateModeInfo.setVisible(true);
        this.btnUpdateModeInfo.setText("?");
        this.btnUpdateModeInfo.setToolTipText(CALIBRATION_UPDATE_INFO_MESSAGE);
        this.btnUpdateModeInfo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MessageBox messageBox = new MessageBox(SensorModifier.this.shlSensorModifier, 34);
                messageBox.setText("Calibration Data Update Mode");
                messageBox.setMessage(SensorModifier.CALIBRATION_UPDATE_INFO_MESSAGE);
                messageBox.open();
            }
        });
        this.lblUponPdtUpdate = new Label((Composite)this.grpCalibration, 0);
        this.lblUponPdtUpdate.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.lblUponPdtUpdate.setText("Upon PDT Update:");
        this.cmbCalibUpdateMode = new Combo((Composite)this.grpCalibration, 8);
        this.cmbCalibUpdateMode.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.setCalibUpdateModeEnability(false);
        for (PdtUpdateModes.CalibrationUpdateMode mode : PdtUpdateModes.CalibrationUpdateMode.values()) {
            this.cmbCalibUpdateMode.add(mode.getFriendlyName());
        }
        this.cmbCalibUpdateMode.select(0);
        try {
            this._gpioInfo = new GpioInfo(this._properties);
            this._gpioInfo.setSensor(this._sensor);
            this.grpGpio = this._gpioInfo.drawGpioInfo(this.shlSensorModifier, (Composite)this.shlSensorModifier);
            this.gd_grpGpio = new GridData(4, 4, true, false, 2, 1);
            this.grpGpio.setLayoutData((Object)this.gd_grpGpio);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.grpDependencies = new Group((Composite)this.shlSensorModifier, 0);
        this.grpDependencies.setText("Dependencies");
        this.gd_grpDependencies = new GridData(4, 4, true, true, 2, 1);
        this.grpDependencies.setLayoutData((Object)this.gd_grpDependencies);
        GuiUtils.setGridLayoutToComposite((Composite)this.grpDependencies, 1);
        this.grpDependencies.setVisible(false);
        this.gd_grpDependencies.exclude = true;
        TableViewer tblVwrDependencies = new TableViewer((Composite)this.grpDependencies, 67586);
        this.tblDependencies = tblVwrDependencies.getTable();
        GridData gd_tblDependencies = new GridData(4, 4, true, true, 1, 1);
        gd_tblDependencies.heightHint = GuiUtils.getButtonWidth((Control)this.grpDependencies);
        this.tblDependencies.setLayoutData((Object)gd_tblDependencies);
        this.tblDependencies.setTouchEnabled(true);
        this.tblDependencies.setLinesVisible(true);
        this.tblDependencies.setHeaderVisible(true);
        ControlAdapter resizeColHandler = new ControlAdapter(){

            public void controlResized(ControlEvent arg0) {
                if (((TableColumn)arg0.getSource()).getWidth() < 50) {
                    ((TableColumn)arg0.getSource()).setWidth(50);
                }
            }
        };
        this.tblVwrClmDependencyType = new TableViewerColumn(tblVwrDependencies, 0);
        this.tblclmnType = this.tblVwrClmDependencyType.getColumn();
        this.tblclmnType.setText("Dependency Type");
        this.tblclmnType.addControlListener((ControlListener)resizeColHandler);
        this.tblVwrClmDependencySensType = new TableViewerColumn(tblVwrDependencies, 0);
        this.tblclmnDpnSensType = this.tblVwrClmDependencySensType.getColumn();
        this.tblclmnDpnSensType.setText("Sensor Type");
        this.tblclmnDpnSensType.addControlListener((ControlListener)resizeColHandler);
        this.tblVwrClmDependencyVendor = new TableViewerColumn(tblVwrDependencies, 0);
        this.tblclmnDpnVendor = this.tblVwrClmDependencyVendor.getColumn();
        this.tblclmnDpnVendor.setText("Vendor");
        this.tblclmnDpnVendor.addControlListener((ControlListener)resizeColHandler);
        this.tblVwrClmDependencyModel = new TableViewerColumn(tblVwrDependencies, 0);
        this.tblclmnDpnModel = this.tblVwrClmDependencyModel.getColumn();
        this.tblclmnDpnModel.setText("Model");
        this.tblclmnDpnModel.addControlListener((ControlListener)resizeColHandler);
        this.tblVwrClmDependencyInstance = new TableViewerColumn(tblVwrDependencies, 0);
        this.tblclmnDpnInstance = this.tblVwrClmDependencyInstance.getColumn();
        this.tblclmnDpnInstance.setText("Instance");
        this.tblclmnDpnInstance.addControlListener((ControlListener)resizeColHandler);
        this.tblVwrClmDependencyFlags = new TableViewerColumn(tblVwrDependencies, 0);
        this.tblclmnDpnFlags = this.tblVwrClmDependencyFlags.getColumn();
        this.tblclmnDpnFlags.setText("Flags");
        this.tblclmnDpnFlags.addControlListener((ControlListener)resizeColHandler);
        this.tblDependencies.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int oneWidth = ((SensorModifier)SensorModifier.this).tblDependencies.getClientArea().width / 11;
                SensorModifier.this.tblclmnType.setWidth(oneWidth * 2);
                SensorModifier.this.tblclmnDpnSensType.setWidth(oneWidth * 2);
                SensorModifier.this.tblclmnDpnVendor.setWidth(oneWidth * 2);
                SensorModifier.this.tblclmnDpnModel.setWidth(oneWidth * 2);
                SensorModifier.this.tblclmnDpnInstance.setWidth(oneWidth);
                SensorModifier.this.tblclmnDpnFlags.setWidth(oneWidth * 2);
            }
        });
        Composite cmpsOkCancel = new Composite((Composite)this.shlSensorModifier, 0);
        cmpsOkCancel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 10;
        cmpsOkCancel.setLayout((Layout)gridLayout);
        this.btnOk = new Button(cmpsOkCancel, 0);
        GridData gd_btnOk = new GridData(131072, 0x1000000, true, false, 1, 1);
        this.btnOk.setLayoutData((Object)gd_btnOk);
        gd_btnOk.widthHint = GuiUtils.getButtonWidth((Control)this.shlSensorModifier);
        this.btnOk.setText("OK");
        this.btnOk.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SensorModifier.this.saveSensorData();
            }
        });
        this.btnCancel = new Button(cmpsOkCancel, 0);
        GridData gd_btnCancel = new GridData(4, 0x1000000, false, false, 1, 1);
        this.btnCancel.setLayoutData((Object)gd_btnCancel);
        gd_btnCancel.widthHint = GuiUtils.getButtonWidth((Control)this.shlSensorModifier);
        this.btnCancel.setText("Cancel");
        this.btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SensorModifier.this.shlSensorModifier.close();
            }
        });
        ((GridLayout)this.grpBasicDetails.getLayout()).verticalSpacing = 5;
        ((GridLayout)this.grpFlags.getLayout()).verticalSpacing = 5;
        ((GridLayout)this.grpSensorIo.getLayout()).verticalSpacing = 5;
        ((GridLayout)this.grpCalibration.getLayout()).verticalSpacing = 5;
        this.shlSensorModifier.setTabList(new Control[]{this.grpBasicDetails, this.grpFlags, this.grpBus, this.grpSensorIo, this.grpCalibration, this.grpGpio, this.grpDependencies, this.chbIsPhysical, cmpsOkCancel});
        this.shlSensorModifier.setSize(this.shlSensorModifier.computeSize(-1, -1));
        this.shlSensorModifier.setLocation(GuiUtils.getMiddleLocation(this.shlSensorModifier, this.display));
        this.initDataBindings();
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        return bindingContext;
    }
}

