/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.CycleBaseHandler;
import org.eclipse.ui.internal.EditorReference;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;

public class CycleEditorHandler
extends CycleBaseHandler {
    protected void addItems(Table table, WorkbenchPage page) {
        List<EditorReference> refs = page.getSortedEditorReferences();
        for (EditorReference ref : refs) {
            TableItem item = null;
            item = new TableItem(table, 0);
            if (ref.isDirty()) {
                item.setText("*" + ref.getTitle());
            } else {
                item.setText(ref.getTitle());
            }
            item.setImage(ref.getTitleImage());
            item.setData((Object)ref);
        }
    }

    protected ParameterizedCommand getBackwardCommand() {
        ICommandService commandService = (ICommandService)this.window.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand("org.eclipse.ui.window.previousEditor");
        ParameterizedCommand commandBack = new ParameterizedCommand(command, null);
        return commandBack;
    }

    protected ParameterizedCommand getForwardCommand() {
        ICommandService commandService = (ICommandService)this.window.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand("org.eclipse.ui.window.nextEditor");
        ParameterizedCommand commandF = new ParameterizedCommand(command, null);
        return commandF;
    }

    protected String getTableHeader(IWorkbenchPart activePart) {
        return WorkbenchMessages.CycleEditorAction_header;
    }
}

