/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.CustomDataEntryTable;
import pdtEditor.DataStore;
import pdtEditor.IMainWindow;
import pdtEditor.gui.GuiUtils;
import pdtEditor.gui.calibration.CustomCalibrationEditor;

public class CustomDataEntry {
    protected Shell shlEditCalibration;
    private Display display;
    private byte[] customDataEntry = null;
    private boolean _modified = false;
    private Button btnVenDataBrowse;
    private Button btnVenDataExport;
    private Label lblDataStatus;
    private Button btnClear;
    private DataStore _dataStore;
    private IMainWindow _parent = null;

    public CustomDataEntry(DataStore dataStore, IMainWindow parent) {
        this._dataStore = dataStore;
        this._parent = parent;
    }

    public void browseVendorData() {
        if (this.customDataEntry != null && this.customDataEntry.length > 0) {
            MessageBox messageBox = new MessageBox(this.shlEditCalibration, 296);
            messageBox.setText("Loading New Custom Data");
            messageBox.setMessage("Loading new data will override the old data. Do you want to continue?");
            if (messageBox.open() != 32) {
                return;
            }
        }
        FileDialog fd = new FileDialog(this.shlEditCalibration, 4096);
        fd.setText("Import Vendor Data");
        fd.setFilterPath("C:/");
        String[] filterExt = new String[]{"*.*"};
        fd.setFilterExtensions(filterExt);
        String path = fd.open();
        if (path == null || path.isEmpty()) {
            return;
        }
        try {
            byte[] binaryData = Files.readAllBytes(Paths.get(path, new String[0]));
            if (binaryData.length > 1024) {
                MessageBox messageBox = new MessageBox(this.shlEditCalibration, 33);
                messageBox.setText("Loading Failed");
                messageBox.setMessage("The size of the selected file (" + binaryData.length + " bytes) exceeds the maximal file size (" + 1024 + " bytes).");
                messageBox.open();
                return;
            }
            this.customDataEntry = binaryData;
        }
        catch (IOException e) {
            MessageBox messageBox = new MessageBox(this.shlEditCalibration, 33);
            messageBox.setText("Loading Failed");
            messageBox.setMessage("Loading the new data failed");
            messageBox.open();
        }
        this.updateVendorDataComponents();
        this._modified = true;
    }

    public void exportVendorData() {
        if (this.customDataEntry != null && this.customDataEntry.length == 0) {
            return;
        }
        FileDialog fd = new FileDialog(this.shlEditCalibration, 8192);
        fd.setText("Export Vendor Data");
        fd.setFilterPath("C:/");
        String[] filterExt = new String[]{"*.*"};
        fd.setFilterExtensions(filterExt);
        String path = fd.open();
        if (path == null || path.isEmpty()) {
            return;
        }
        try {
            Files.write(Paths.get(path, new String[0]), this.customDataEntry, new OpenOption[0]);
        }
        catch (IOException e) {
            MessageBox messageBox = new MessageBox(this.shlEditCalibration, 33);
            messageBox.setText("Exporting Custom Data");
            messageBox.setMessage("Exporting The Custom Data Failed");
            messageBox.open();
        }
    }

    public void updateVendorDataComponents() {
        if (this.customDataEntry != null && this.customDataEntry.length > 0) {
            this.lblDataStatus.setText("Contains Data: " + this.customDataEntry.length + " Bytes");
            this.lblDataStatus.setSize(this.lblDataStatus.computeSize(-1, -1));
            this.btnVenDataExport.setEnabled(true);
            this.btnClear.setEnabled(true);
        } else {
            this.lblDataStatus.setText("No Data");
            this.btnVenDataExport.setEnabled(false);
            this.btnClear.setEnabled(false);
        }
    }

    public void fillData() {
        CustomDataEntryTable customDataEntryTable = this._dataStore.getCurrentPdtFile().getCustomDataEntryTable();
        if (customDataEntryTable != null && customDataEntryTable.getCustomDataEntry() != null) {
            this.customDataEntry = customDataEntryTable.getCustomDataEntry();
        }
        this.updateVendorDataComponents();
        this._modified = false;
    }

    public void saveData() {
        if (this.customDataEntry == null || this.customDataEntry.length == 0) {
            if (this._dataStore.getCurrentPdtFile().getCustomDataEntryTable() != null) {
                this._dataStore.getCurrentPdtFile().getBdtObjects().remove(this._dataStore.getCurrentPdtFile().getCustomDataEntryTable());
            }
        } else {
            CustomDataEntryTable customDataEntryBdtObject = this._dataStore.getCurrentPdtFile().getCustomDataEntryTable();
            if (customDataEntryBdtObject == null) {
                customDataEntryBdtObject = new CustomDataEntryTable();
                this._dataStore.getCurrentPdtFile().addBdtObject(customDataEntryBdtObject);
            }
            customDataEntryBdtObject.setCustomDataEntry(this.customDataEntry);
        }
        this._modified = false;
        this._parent.setModified();
        this.shlEditCalibration.close();
    }

    public void open() {
        this.display = Display.getDefault();
        this.createContents();
        this.fillData();
        this.shlEditCalibration.open();
        this.shlEditCalibration.layout();
        while (!this.shlEditCalibration.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    protected void createContents() {
        int shortButtonMinWidth;
        this.shlEditCalibration = new Shell(65760);
        this.shlEditCalibration.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                if (CustomDataEntry.this._modified) {
                    MessageBox messageBox = new MessageBox(CustomDataEntry.this.shlEditCalibration, 296);
                    messageBox.setText("Closing The 'PDT Custom Data Entry' Window");
                    messageBox.setMessage("Some changes will be lost. Are you sure that you want to close the 'PDT Custom Data Entry' window?");
                    if (messageBox.open() != 32) {
                        e.doit = false;
                        return;
                    }
                }
            }
        });
        this.shlEditCalibration.setImage(SWTResourceManager.getImage(CustomCalibrationEditor.class, "/resources/Intel.ico"));
        this.shlEditCalibration.setText("PDT Custom Data Entry");
        GuiUtils.setGridLayoutToComposite((Composite)this.shlEditCalibration, 1);
        Group grpVendorDefinedData = GuiUtils.addGroupToComposite("Custom Data (Binary files only)", (Composite)this.shlEditCalibration, 0, 4, 128, true, false, 1, 1, 1);
        this.lblDataStatus = GuiUtils.addLabelToComposite("No Data", (Composite)grpVendorDefinedData, 0, 16384, 0x1000000, false, false, 1, 1);
        Composite compositeBusInfoButton = GuiUtils.addCompositeToComposite((Composite)grpVendorDefinedData, 0, 4, 0x1000000, false, false, 1, 1, 3);
        this.btnVenDataBrowse = GuiUtils.addButtonToComposite("Browse", "", compositeBusInfoButton, 0, 16384, 0x1000000, true, false, 1, 1);
        this.btnVenDataExport = GuiUtils.addButtonToComposite("Export", "", compositeBusInfoButton, 0, 16384, 0x1000000, true, false, 1, 1);
        this.btnClear = GuiUtils.addButtonToComposite("Clear", "", compositeBusInfoButton, 0, 16384, 0x1000000, true, false, 1, 1);
        Composite compositeShellButton = GuiUtils.addCompositeToComposite((Composite)this.shlEditCalibration, 0, 131072, 0x1000000, false, false, 1, 1, 2);
        Button btnSave = GuiUtils.addButtonToComposite("Save and Close", "", compositeShellButton, 0, 131072, 0x1000000, true, false, 1, 1);
        Button btnCancel = GuiUtils.addButtonToComposite("Cancel", "", compositeShellButton, 0, 131072, 0x1000000, true, false, 1, 1);
        this.btnVenDataBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomDataEntry.this.browseVendorData();
            }
        });
        this.btnVenDataExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomDataEntry.this.exportVendorData();
            }
        });
        this.btnClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CustomDataEntry.this.customDataEntry != null && CustomDataEntry.this.customDataEntry.length > 0) {
                    MessageBox messageBox = new MessageBox(CustomDataEntry.this.shlEditCalibration, 296);
                    messageBox.setText("Clearing The Vendor Defined Data");
                    messageBox.setMessage("You are about to clear the vendor defined data. Do you want to continue?");
                    if (messageBox.open() != 32) {
                        return;
                    }
                }
                CustomDataEntry.access$102(CustomDataEntry.this, null);
                CustomDataEntry.this.updateVendorDataComponents();
            }
        });
        btnSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomDataEntry.this.saveData();
            }
        });
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomDataEntry.this.shlEditCalibration.close();
            }
        });
        this.btnVenDataExport.setEnabled(false);
        this.btnClear.setEnabled(false);
        int longButtonMinWidth = (int)((double)GuiUtils.getButtonWidth((Control)this.shlEditCalibration) * 1.5);
        ((GridData)this.btnVenDataBrowse.getLayoutData()).minimumWidth = shortButtonMinWidth = GuiUtils.getButtonWidth((Control)this.shlEditCalibration);
        ((GridData)this.btnVenDataExport.getLayoutData()).minimumWidth = shortButtonMinWidth;
        ((GridData)this.btnClear.getLayoutData()).minimumWidth = shortButtonMinWidth;
        ((GridData)btnSave.getLayoutData()).minimumWidth = longButtonMinWidth;
        ((GridData)btnCancel.getLayoutData()).minimumWidth = shortButtonMinWidth;
        ((GridLayout)compositeShellButton.getLayout()).marginHeight = 0;
        ((GridLayout)compositeShellButton.getLayout()).marginWidth = 0;
        ((GridLayout)compositeBusInfoButton.getLayout()).marginHeight = 0;
        ((GridLayout)compositeBusInfoButton.getLayout()).marginWidth = 0;
        this.shlEditCalibration.setSize(this.shlEditCalibration.computeSize(-1, -1));
        this.shlEditCalibration.setLocation(GuiUtils.getMiddleLocation(this.shlEditCalibration, this.display));
    }

    static /* synthetic */ byte[] access$102(CustomDataEntry x0, byte[] x1) {
        x0.customDataEntry = x1;
        return x1;
    }
}

