/*
 * Decompiled with CFR 0.152.
 */
package manager.sensor;

import java.util.Comparator;
import manager.common.SensorsDefinitionsMapping;
import manager.configure.Platform;
import manager.pack.data.ISSPackage;
import manager.sensor.SensorData;
import manager.utils.ManagerEnums;
import org.w3c.dom.Element;

public class SensorDataWrapper {
    private ManagerEnums.ComponentOwner owner;
    private String fileName;
    private SensorData data;
    private ISSPackage issPackage;

    public SensorDataWrapper(Element parent) {
        this.setXMLData(parent);
    }

    public SensorDataWrapper(ManagerEnums.ComponentOwner owner, String fileName, SensorData data) {
        this.owner = owner;
        this.fileName = fileName;
        this.data = data;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public SensorData getData() {
        return this.data;
    }

    public void setData(SensorData data) {
        this.data = data;
    }

    public ManagerEnums.ComponentOwner getOwner() {
        return this.owner;
    }

    public void setOwner(ManagerEnums.ComponentOwner owner) {
        this.owner = owner;
    }

    public ISSPackage getIssPackage() {
        return this.issPackage;
    }

    public void setIssPackage(ISSPackage issPackage) {
        this.issPackage = issPackage;
    }

    public boolean equals(Object arg0) {
        if (arg0 == null || !(arg0 instanceof SensorDataWrapper)) {
            return false;
        }
        SensorDataWrapper other = (SensorDataWrapper)arg0;
        return (this.owner == null && other.owner == null || this.owner != null && this.owner == other.owner) && (this.fileName == null && other.fileName == null || this.fileName != null && this.fileName.equals(other.fileName)) && (this.data == null && other.data == null || this.data != null && this.data.equals(other.data));
    }

    public void setXMLData(Element parent) {
        if (this.data == null) {
            this.data = new SensorData();
        }
    }

    public void setXMLPartialData(Element parent, Platform platform) throws Exception {
        if (this.data == null) {
            this.data = new SensorData();
        }
        this.data.setObjectType(ManagerEnums.ObjectTypes.getValueByFriendlyName(parent.getAttribute("ObjectType")));
        if (this.data.getObjectType() != ManagerEnums.ObjectTypes.LIBRARY) {
            this.data.setName(parent.getAttribute("SensorName"));
            this.data.setTypeId(Integer.parseInt(parent.getAttribute("SensorTypeId")));
            this.data.setFlags(Integer.parseInt(parent.getAttribute("Flags")));
            String typeName = this.data.getObjectType() == ManagerEnums.ObjectTypes.PHYSICAL ? SensorsDefinitionsMapping.getInstance().getPhysicalSensorTypesDefinitions(platform).getForward(this.data.getTypeId()) : SensorsDefinitionsMapping.getInstance().getVirtualSensorTypesDefinitions(platform).getForward(this.data.getTypeId());
            if (typeName == null) {
                typeName = Integer.toString(this.data.getTypeId());
            }
            this.data.setTypeName(typeName);
            this.data.setModelName(parent.getAttribute("ModelName"));
            this.data.setModelId(Integer.parseInt(parent.getAttribute("ModelId")));
        } else {
            this.data.setName(parent.getAttribute("LibraryName"));
            this.data.setModelName(parent.getAttribute("VersionName"));
            this.data.setModelId(Integer.parseInt(parent.getAttribute("VersionId")));
        }
        this.data.setVendorId(Integer.parseInt(parent.getAttribute("VendorId")));
        String vendorName = SensorsDefinitionsMapping.getInstance().getVendorsDefinitions(platform).getForward(this.data.getVendorId());
        if (vendorName == null) {
            vendorName = Integer.toString(this.data.getVendorId());
        }
        this.data.setVendorName(vendorName);
        if (platform != null) {
            this.data.setPlatform(platform);
        }
    }

    public final void getXMLData(Element parent) {
    }

    public final void getXMLPartialData(Element sensorElement) {
        sensorElement.setAttribute("SensorFileName", this.fileName);
        if (this.data.getObjectType() != ManagerEnums.ObjectTypes.LIBRARY) {
            sensorElement.setAttribute("SensorName", this.data.getName());
            sensorElement.setAttribute("SensorTypeId", Integer.toString(this.data.getTypeId()));
            sensorElement.setAttribute("Flags", Integer.toString(this.data.getFlagsAsInteger()));
            sensorElement.setAttribute("ModelId", Integer.toString(this.data.getModelId()));
            sensorElement.setAttribute("ModelName", this.data.getModelName());
            if (this.data.getAutoStart()) {
                sensorElement.setAttribute("AutoStart", String.valueOf(this.data.getAutoStart()));
                sensorElement.setAttribute("AutoStartSensitivity", Integer.toString(this.data.getAutoStartSensitivity()));
                sensorElement.setAttribute("AutoStartMinReportInterval", Integer.toString(this.data.getAutoStartMinRi()));
            } else {
                sensorElement.removeAttribute("AutoStart");
                sensorElement.removeAttribute("AutoStartSensitivity");
                sensorElement.removeAttribute("AutoStartMinReportInterval");
            }
        } else {
            sensorElement.setAttribute("LibraryName", this.data.getName());
            sensorElement.setAttribute("VersionId", Integer.toString(this.data.getModelId()));
            sensorElement.setAttribute("VersionName", this.data.getModelName());
        }
        sensorElement.setAttribute("VendorId", Integer.toString(this.data.getVendorId()));
        sensorElement.setAttribute("ObjectType", this.data.getObjectType().getFriendlyName());
        sensorElement.setAttribute("Owner", this.owner.getFriendlyName());
        sensorElement.setAttribute("OemProjectVersion", this.data.getBuildVersion().toString());
    }

    public static SensorDataWrapper clone(SensorDataWrapper val) {
        SensorDataWrapper newSd = new SensorDataWrapper(val.getOwner(), val.getFileName(), val.getData());
        newSd.setIssPackage(val.getIssPackage());
        return newSd;
    }

    public static class DataWrapperComparator
    implements Comparator<SensorDataWrapper> {
        @Override
        public int compare(SensorDataWrapper data1, SensorDataWrapper data2) {
            SensorData.DataComparator comparator = new SensorData.DataComparator();
            if (data1.getOwner() == data2.getOwner() || data1.getOwner() != ManagerEnums.ComponentOwner.USER && data2.getOwner() != ManagerEnums.ComponentOwner.USER) {
                return comparator.compare(data1.getData(), data2.getData());
            }
            if (data1.getOwner() == ManagerEnums.ComponentOwner.USER) {
                return 1;
            }
            return -1;
        }
    }
}

