<?php
//include_once("Container.class.php");

class UserDtl
{
	//login info
	public $loginName;
	public $passwd;
		
	//user info
	//email notify user when event of certain type happened.
	public $eventNotify = 0;
	//displayed name
	public $nickName;
	//mail addr
	public $emailAddr;
	
	public $userType;
	
	public function setUserDtl($user)
	{
		$this->loginName = $user->getLoginName();
		$this->emailAddr = $user->getEmailAddr();
		$this->nickName = $user->getNickName();
		$this->passwd = $user->getPasswd();
		$this->userType = $user->isAdmin() ? gettext(UserType::ADMIN_STR) : gettext(UserType::GUEST_STR);
		$this->eventNotify = $user->getEventNotify() ? gettext('Configured') : gettext("Unconfigured");
	}
}

class CtnUsers
{
	protected $smarty;
	
	private $pageID;
	
	public function setPageID($pageID)
	{
		$this->pageID = $pageID;
	}
	
	public function initContainer()
	{
		$da = new UserDataAccess();
		$users = $da->getAllUser();
		
		$users = array_reverse($users);
		
		//sort data
		/*
		$list = array();
		foreach ($users as $user)
		{
			$list[$user->getLoginName()] = $user;
		}
		ksort($list);
		*/

		//construct pager
		$pager = new Pager();
		$pager->setDataList($users);
		
		if ($this->pageID == null) {
			$users = $pager->goFirstPage();
		}else if ($this->pageID == -1) {
			$users = $pager->goLastPage();
		}
		else 
		{
			$pager->setPageID($this->pageID);
			$users = $pager->getPage();
		}
	
		//convert to UserDtl
		$userList = array();
		foreach ($users as $user)
		{
			$usrDtl = new UserDtl();
			$usrDtl->setUserDtl($user);
			$userList[] = $usrDtl;
		}
		
		//set data to page
		if ($pager->pageCount() != 0) 
			$this->smarty->assign('curPageID',$pager->getPageID() + 1);
		else 
			$this->smarty->assign('curPageID',0);
		$this->smarty->assign('pageNum',$pager->pageCount());
		$this->smarty->assign('pageID',$pager->getPageID());
		$this->smarty->assign('isFirst',$pager->isFirst());
		$this->smarty->assign('isLast',$pager->isLast());
		$this->smarty->assign('userList',$userList);
	}
	
	public function smartyAssign($smarty)
	{
		$this->smarty = $smarty;
	}
	
	public function display($TPLFile)
	{
		$this->smarty->display($TPLFile);
	}
}
?>