<?php
class EventList extends BaseData
{
	//const default_len = 4;
	private $StartNo;
	private $EventNum;
	private $EventMaxNum;
	private $EventStartNo;
	
	public function setStartNo($startNo)
	{
		$this->StartNo = $startNo;
	}
	
	public static function GetEventEndNo()
	{
		if (parent::DebugTest) {
			return 40;
		}
		
		$XMLApiCmd = new XMLAPICommand();
		$XMLApiCmd->setCommand(XMLAPICommand::ZA_MV_EVT_GetEvents);
		$XMLApiCmd->setCommandPara("Num", "0");// 0 stand for get event start no and end no
		$XMLApiCmd->setCommandPara("Start", "0");
	
		if ($XMLApiCmd->issueCommand()) {
			$XMLRoot = $XMLApiCmd->getResult();
			$totalNum = intval(trim($XMLRoot->n));
                        if($totalNum > 0)
                            return $totalNum;
		}
		
		return 0;
	}
	
	public static function GetEventStartNo()
	{
		if (parent::DebugTest) {
			return 40;
		}
		
		$XMLApiCmd = new XMLAPICommand();
		$XMLApiCmd->setCommand(XMLAPICommand::ZA_MV_EVT_GetEvents);
		$XMLApiCmd->setCommandPara("Num", "0");// 0 stand for get event start no and end no
		$XMLApiCmd->setCommandPara("Start", "0");
		
                if ($XMLApiCmd->issueCommand()) {
			$XMLRoot = $XMLApiCmd->getResult();
			return intval(trim($XMLRoot->s));
		}

		return 0;
	}
	
	public static function GetEventNum()
	{
		if (parent::DebugTest) {
			return 40;
		}
		
		$XMLApiCmd = new XMLAPICommand();
		$XMLApiCmd->setCommand(XMLAPICommand::ZA_MV_EVT_GetEvents);
		$XMLApiCmd->setCommandPara("Num", "0");// 0 stand for get event start no and end no
		$XMLApiCmd->setCommandPara("Start", "0");
	
		if ($XMLApiCmd->issueCommand()) {
                    $result = $XMLApiCmd->getResult();
                    if(isset($result)) {
			$XMLRoot = $result;
                        return intval(trim($XMLRoot->n));
                    }
		}
		
		return 0;
	}
	
	/*   The StartNo >= 0 and <=$MaxNo - $len + 1   */
	public function checkPara()
	{
		if (self::GetEventNum() == 0) {
			$this->StartNo = 0;
			$this->EventNum = 0;
			return;
		}
		$MaxNo = self::GetEventEndNo();
		$this->EventMaxNum = self::GetEventNum();
		$this->EventStartNo = self::GetEventStartNo();
		if ($this->StartNo == -1 or $this->StartNo + $this->EventNum > $MaxNo) {
			$this->StartNo = $MaxNo - $this->EventNum;
		}
		else {
			$this->StartNo += $this->EventStartNo;
		}
		if($this->StartNo < $this->EventStartNo)
			$this->StartNo = $this->EventStartNo;
	}
	
	public function getEventMaxNum()
	{
		return ($this->EventMaxNum);
	}
	
	public function getEvtStartNo()
	{
		return $this->EventStartNo;
	}
	
	public function getStartNo()
	{
		return $this->StartNo;
	}
	
	public function setEventNum($EventNum)
	{
		$this->EventNum = $EventNum;
	}
	
	public function prepareAPICommands()
	{
		$this->checkPara();
		
		$XMLApiCmd = new XMLAPICommand();
		$XMLApiCmd->setCommand(XMLAPICommand::ZA_MV_EVT_GetEvents);
		$StartNo = $this->StartNo;
		
		if ($StartNo < 0 || $StartNo === null) {
			$StartNo = $this->EventStartNo;
		}
		
		//$this->
		$XMLApiCmd->setCommandPara("Num", $this->EventNum ."");
		$XMLApiCmd->setCommandPara("Start", $StartNo . "");
		
		$this->StartNo -= $this->EventStartNo;
		
		$this->XMLAPICommandList['setEventToBaseClass'] = $XMLApiCmd;
	}
	
	protected function setEventToBaseClass($data)
	{
		$XMLRoot = $data;
		if (isset($XMLRoot->Event)) {
			foreach ($XMLRoot->Event as $EventInfo)
			{
				$evt = new Event();
				$evt->setEventInfo($EventInfo);
				$this->BaseClasses[] = $evt;
			}
		}
	}
	
	public function setDataToBaseClass()
	{
		
	}
	
	public function loadTestData()
	{
		$Path = "../phpsrc/baseclass/testdata/eventlist/";
		$Files = array("ZA_MV_EVT_GetEvents10_14_25.xml");
		
		$this->EventMaxNum = self::GetEventNum();
		$this->checkPara();
		
		foreach ($Files as $File)
		{
			$data = simplexml_load_file($Path . $File);
			$this->setEventToBaseClass($data);
		}
	}
}

?>