<?php
class GetAllSSDStatus {
	
	private $TplFile;
	private $smarty;
	private $HBAID = 0;
	private $ApiCmd;
	private $xmlRet;//the xml result
	private $status;
	
	private function initPara()
	{
		$this->HBAID = getRequestPara("HBAID");
	}
	
	public function setAdapterID($HBAID)
	{
		$this->HBAID = $HBAID;
	}
	
	public function getStatus()
	{
		return $this->status;
	}
	
	public function setAllSSDStatus()
	{
		$this->ApiCmd = new XMLAPICommand();
		$this->ApiCmd->setCommand(XMLAPICommand::MV_SSD_GetStatusALL);
		$this->ApiCmd->setCommandPara("AdapterID",$this->HBAID);
		
		//debug
			//$this->smarty->assign("Percentage",10);
			//$this->smarty->assign("Status",$this->status);
			//$this->status = 13;
		if ($this->ApiCmd->issueCommand() && $this->ApiCmd->getResult()) {
			$percentage = $this->ApiCmd->getResult()->SSDStatus->Percentage;
			$this->status = $this->ApiCmd->getResult()->SSDStatus->Status;
			$this->smarty->assign("Percentage",$percentage);
			$this->smarty->assign("Status",$this->status);
		}
		
	}
	
	private function setCreateVolumeCmdXmlRetSuccess()
	{
		$this->xmlRet = new SuccessXMLRet();
		$this->xmlRet->Msg = "";
		$this->xmlRet->Url = "JumpPage.php?Target=" . Target::getSSDVolumeDetail . "&HBAID=" . $this->HBAID . "&newCreate=1";
		
		$display = new XMLRetDisplayer();
		$display->assignSmarty($this->smarty);
		$display->display($this->xmlRet);
	}
	
	private function setCreateVolumeCmdXmlRetFailed()
	{
		$this->xmlRet = new FailXMLRet();
		//$XMLRoot = $this->ApiCmd->getResult();
		//if ($XMLRoot->RetVal . "") {
		$errStatus = $this->ApiCmd->getResult()->SSDStatus->Status;
			if ($errStatus == ComError::ERR_INVALID_ADAPTER_ID 
				) {
				$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target=" . Target::getSystemSubPage;
			}
			else
			{
				$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target=" . Target::getHBADetail . "&ID=" . $this->HBAID;
			}
			//$Err = ComError::getErrStr(ComError::ERR_FAIL);
			$Err = SSDCreateVolumeStatus::getErrorMsg($errStatus);
			$this->xmlRet->Msg = $Err;
		//}
		
		$display = new XMLRetDisplayer();
		$display->assignSmarty($this->smarty);
		$display->display($this->xmlRet);
	}
	
	public function displayResultXML()
	{
		$this->TplFile = "XML_AllSSDStatus.tpl";
		$this->initPara();
		$this->setAllSSDStatus();
		
		if ($this->status >= SSDCreateVolumeStatus::CREATE_VD_FAIL){
			$this->setCreateVolumeCmdXmlRetFailed();
		}
		elseif ($this->status == SSDCreateVolumeStatus::CREATE_VD_SUCCESS ){
			$this->setCreateVolumeCmdXmlRetSuccess();
		}
		else 
		{
			$this->smarty->display($this->TplFile);
			//$this->setCreateVolumeCmdXmlRetSuccess();
		}
		
	}
	
	public function smartyAssign($smarty)
	{
		$this->smarty = $smarty;
	}
}

?>