<?php
class Event
{
	private $Class;
	private $Code;
	private $Severity;
	private $AdapterID;
	private $Time;
	private $SenseDataLength;
	private $SenseData;
	private $EvtLog;
	
	public function setEvtLog($EvtLog)
	{
		$this->EvtLog = $EvtLog;
	}
	
	public function getEvtLog()
	{
		return $this->EvtLog;
	}
	
	public function setClass($Class)
	{
		$this->Class = $Class;
	}
	
	public function getClass()
	{
		return $this->Class;
	}
	
	public function setCode($Code)
	{
		$this->Code = $Code;
	}
	
	public function getCode()
	{
		return $this->Code;
	}
	
	public function setSeverity($Severity)
	{
		$this->Severity = $Severity;
	}
	
	public function getSeverity()
	{
		return $this->Severity;
	}
	
	public function getAdapterID()
	{
		return $this->AdapterID;
	}
	
	public function setTime($Time)
	{
		$this->Time = $Time;
	}
	
	public function getTime()
	{
		return $this->Time;
	}
	
	public function getSenseDataLength()
	{
		return $this->SenseDataLength;
	}
	public function getSenseData()
	{
		return $this->SenseData;
	}

	// set events information from xml element
	public function setEventInfo($EventInfo)
	{
		if(isset($EventInfo->Class))
		{
			$this->Class = trim($EventInfo->Class);
		}
		
		if(isset($EventInfo->Code))
		{
			$this->Code = trim($EventInfo->Code);
		}
		
		if(isset($EventInfo->Severity))
		{
			$this->Severity = intval($EventInfo->Severity);
		}
		
		if(isset($EventInfo->AdapterID))
		{
			$this->AdapterID = trim($EventInfo->AdapterID);
		}
		
		if(isset($EventInfo->SenseDataLength))
		{
			$this->SenseDataLength = intval($EventInfo->SenseDataLength);
			if($this->SenseDataLength > 0 && isset($EventInfo->SenseData))
			{
				$this->SenseData = trim($EventInfo->SenseData);
			}
		}

                if(isset($EventInfo->Msg))
                {
                    $str = trim($EventInfo->Msg);                    
                    $this->EvtLog = $str;
                }

                if(isset($EventInfo->Time))
                {
                    $arr = explode(" ", trim($EventInfo->Time));
                    $newArr = array();
                    foreach($arr as $val)
                        if(trim($val) !== '') $newArr[] = $val;
                    list($weekday, $month, $date, $time, $year) = $newArr;
                    $tmpDate = strtotime($date. $month. $year. " ". $time);
                    $convDate = date("m/d/Y H:i", $tmpDate);
                    $this->Time = $convDate;
                }
	}
}

?>