<?php

class EnclDetail extends EnclBase
{
	private $EnclID;
	
	public function setEnclID($EnclID)
	{
		$this->EnclID = $EnclID;
	}
	
	protected function setRequestSender()
	{
		$this->reqSender = new BaseSingleRequestSender();
		$this->reqSender->setID($this->EnclID);
	}
	
	public function toGetEnclElementInfo()
	{
		$handler = new EncElementInfoXmlHandler();
		
		$XMLApiCmd = new XMLAPICommand();
		$XMLApiCmd->setCommand(XMLAPICommand::MV_ENC_GetElementInfo );		
		$XMLApiCmd->setCommandPara("ENC_ID", $this->EnclID);
		
		$this->runCommand($XMLApiCmd->getCommand(), $handler);
	}
	
	public function toGetEnclElementCfg()
	{
		$handler = new EncElementCfgXmlHandler();
		
		$XMLApiCmd = new XMLAPICommand();
		$XMLApiCmd->setCommand(XMLAPICommand::MV_ENC_GetElementConfig );
		$XMLApiCmd->setCommandPara("ENC_ID", $this->EnclID);
		
		$this->runCommand($XMLApiCmd->getCommand(), $handler);
	}
	
	private function removeUnrelatedEnclosure()
	{
		$toDeleted = array();
		//remove enclosure this class not care
		//for when getting expander and pm info, it may simulate AIR enclosure
		foreach ($this->BaseClasses as $key=>$enc)
		{
			if ($enc->getDeviceID() != $this->EnclID) {
				$toDeleted[] = $key;
			}
		}
		
		foreach ($toDeleted as $key)
		{
			unset($this->BaseClasses[$key]);
		}
	}
	
	public function getBaseClasses()
	{
		$this->removeUnrelatedEnclosure();
		return parent::getBaseClasses();
	}
	
	public function getBaseDetail()
	{
		$this->removeUnrelatedEnclosure();
		return parent::getBaseDetail();
	}
}
?>