<?php
class ActionSetSSDOpLevel extends UserAction 
{
	private $HD_ID;
	private $opLevel;
	
	protected function validatePara()
	{
		//check the http request parameters
	}
	protected function initActionPara()
	{
		$this->HD_ID = getRequestPara("HDID");
		$this->opLevel = getRequestPara("opLevel");
	}
	
	private function doSetSSDOpLevel()
	{
		$this->ApiCmd = new XMLAPICommand();
		$this->ApiCmd->setCommand(XMLAPICommand::MV_SSD_SetPercentage_Single);
		$this->ApiCmd->setCommandPara("AdapterID",$this->getAdapterID());
		$this->ApiCmd->setCommandPara("DeviceID",$this->HD_ID);
		$this->ApiCmd->setCommandPara("Percentage",$this->opLevel);
		//var_dump($this->ApiCmd);
		$this->ApiCmd->issueCommand();
		
		if ($this->ApiCmd->getResult()->RetVal . "") {
			$this->setSSDCmdXmlRetFail();
		}
		else {
			$this->setSSDCmdXmlRetSuccess();
		}
		
	}
	
	private function setSSDCmdXmlRetFail()
	{
		$pageName = Target::getSSDDetail;
		$pageName_Default = Target::getSystemSubPage;
		
		$this->xmlRet = new FailXMLRet();
		$XMLRoot = $this->ApiCmd->getResult();
		if ($XMLRoot->RetVal . "") {
			if ($XMLRoot->RetVal == ComError::ERR_INVALID_HD_ID 
				|| $XMLRoot->RetVal == ComError::ERR_HD_NOT_EXIST 
				) {
				$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target=" . $pageName_Default  ;
			}
			else
			{
				$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target=" . $pageName  . "&ID=" . getRequestPara("HDID") . "&HBAID=" . $this->getAdapterID();
			}
			$Err =  ComError::getErrStr(intval($XMLRoot->RetVal));
			$this->xmlRet->Msg = $Err;
		}
	}
	
	private function setSSDCmdXmlRetSuccess()
	{
		$pageName = "";
		
		$pageName = Target::getSSDDetail;
		
		$this->xmlRet = new SuccessXMLRet();
		$this->xmlRet->Msg = "";
		$this->xmlRet->Url = 
			getBaseURL() . PHPPageName::TargetPageName ."?Target=" . $pageName . "&ID=" . getRequestPara("HDID") . "&HBAID=" . $this->getAdapterID();
	}
	
	protected function doAction()
	{
		$this->doSetSSDOpLevel();
	}
}
?>