<?php
class ActionClearSpare extends UserAction 
{
	private $HD_ID;
    const ToStopMP = "ToStopMP";
    private $isRunningMP = 0;
	
	protected function validatePara()
	{
		//check the http request parameters
	}
	protected function initActionPara()
	{
		$this->HD_ID = getRequestPara("HDID");
	}

    private function setFlag()
    {
		include_once("../phpsrc/baseclass/Device.class.php");
		include_once("../phpsrc/baseclass/SASDevice.class.php");
		include_once("../phpsrc/baseclass/ExpanderDevice.class.php");
		include_once("../phpsrc/baseclass/DeviceFactory.class.php");
		include_once("../phpsrc/baseclass/HD.class.php");
		include_once("../phpsrc/baseclass/HdBase.class.php");
		include_once("../phpsrc/baseclass/HdDetail.class.php");

		$hd = new HdDetail();
		$hd->setAdapterID($this->getAdapterID());
		$hd->setID($this->HD_ID);
		$hd->toGetHDInfo();
        $hd->toGetHDRaidStatus();

		$hdDtl = $hd->getBaseDetail();
        $this->isRunningMP = $hdDtl->isMP();
    }

    private function doMPCheck()
    {
        $cmdName = trim(getRequestPara("cmdName"));

        $YesUrl = getBaseURL() . PHPPageName::CmdPageName
        . "?cmdName=" . $cmdName ;
        $YesUrl .=  "&HDID" . "=" . $this->HD_ID . "&HBAID=" . $this->getAdapterID();
        $YesUrl .=  "&" . self::ToStopMP  . "=1";

        $NoUrl = getBaseURL()
        . PHPPageName::TargetPageName ."?Target=" . Target::getHdDetail
        . "&ID=" . $this->HD_ID . "&HBAID=" . $this->getAdapterID();

        $this->xmlRet = new ContXMLRet();
        $this->xmlRet->Msg = AlertMsg::CLEARSPARE_PD_STOP_MP;
        $this->xmlRet->YesUrl = $YesUrl;
        $this->xmlRet->NoUrl = $NoUrl;
        $this->xmlRet->YesUrlType = XMLRetUrlType::CmdUrl;
        $this->xmlRet->NoUrlType = XMLRetUrlType::PageUrl;
    }

	private function doClearSpare()
	{
		$this->ApiCmd = new XMLAPICommand();
		$this->ApiCmd->setCommand(XMLAPICommand::MV_PD_Spare2FreeHD);
		$this->ApiCmd->setCommandPara("AdapterID",$this->getAdapterID());
		$this->ApiCmd->setCommandPara("HD_ID",$this->HD_ID);
		$this->ApiCmd->issueCommand();
		
		if ($this->ApiCmd->getResult()->RetVal . "") {
			$this->setHDCmdXmlRetFail();
		}
		else {
			$this->setHDCmdXmlRetSuccess();
		}
	}
	
	protected function doAction()
	{
        $this->setFlag();
        if ((getRequestPara(self::ToStopMP) == null)
            && $this->isRunningMP){
            $this->doMPCheck();
        }
		if ($this->xmlRet == null) {
            $this->doClearSpare();
        }
	}
}
?>