<?php
//base device class
abstract class Device
{
	private $DeviceID;
	private $DevType;
	private $Name;
	
	private $ParentDevice;
	private $ParentPhyID;
	private $SelfPhyID;
	
	public abstract function isSAS();
	
	public function getParentDevice()
	{
		return $this->ParentDevice;
	}
	
	public function setParentDevice($parent)
	{
		$this->ParentDevice = $parent;
		//add more ID
	}
	
	public function getParentPhyID()
	{
		return $this->ParentPhyID;
	}
	
	public function getSelfPhyID()
	{
		return $this->SelfPhyID;
	}
	
	public function getDeviceID()
	{
		return $this->DeviceID;
	}
	public function setDeviceID($DeviceID)
	{
		$this->DeviceID = $DeviceID;
	}
	
	public function getDevType()
	{
		return $this->DevType;
	}
	
	public function setDevType($DeviceType)
	{
		$this->DevType = $DeviceType;
	}
	
	public function getName()
	{
		return $this->Name;
	}
	
	public function setName($Name)
	{
		$this->Name = $Name;
	}
	
	//set topology link info
	public function setTopologyLink($LinkXML)
	{
		foreach ($LinkXML->Self as $SelfInfo)
		{
			$this->setSelfInfo($SelfInfo);	
		}
		foreach ($LinkXML->Parent as $ParentInfo)
		{
			$this->setParent($ParentInfo);
		}
	}
	
	//set self info from xml parent element
	protected function setSelfInfo($SelfInfo)
	{
		if (isset($SelfInfo->DevID)) {
			$this->DeviceID = trim($SelfInfo->DevID);
		}
		if (isset($SelfInfo->DevType)) {
			$this->setDevType(trim($SelfInfo->DevType));
		}
		$PhyCnt =  intval($SelfInfo->PhyCnt);
		$PhyIDs = trim($SelfInfo->PhyID);
	
		$this->SelfPhyID = $this->formPhyID($PhyCnt,$PhyIDs);
	}
	
	protected function formPhyID($Cnt,$PhyIDs)
	{
		$PhyIDs = explode(" ",$PhyIDs);
		$newPhyIDs = array();
		$i = 0;
		foreach ($PhyIDs as $PhyID)
		{
			if (trim($PhyID) !== "") {
				$newPhyIDs[] = trim($PhyID);
				$i++;
				if ($i >= $Cnt) {
					break;
				}
			}
		}
		
		$strPhyID = "";
		$i = 0;
		foreach ($newPhyIDs as $PhyID)
		{
			if ($i == 0) {
				$strPhyID = $PhyID;
				$i++;
			}
			else {
				$strPhyID .= ", " . $PhyID;
			}
		}
		
		return $strPhyID;
	}
	
	//set parent info from xml parent element
	protected function setParent($ParentInfo)
	{	
		$ParentDevice = DeviceFactory::createDevice(trim($ParentInfo->DevType));
		
		if ($ParentDevice != null) {
			if (isset($ParentInfo->DevID)) {
				$ParentDevice->setDeviceID(trim($ParentInfo->DevID));
			}
			if (isset($ParentInfo->DevType)) {
                if (DeviceType::DEVICE_TYPE_I2C_ENCLOSURE == $ParentInfo->DevType) {
                    $ParentDevice->setDevType(trim($ParentInfo->DevType));
                }
			}
			
			$this->ParentDevice = $ParentDevice;
		}
		
		$PhyCnt =  intval($ParentInfo->PhyCnt);
		$PhyIDs = $ParentInfo->PhyID;
		
		$this->ParentPhyID = $this->formPhyID($PhyCnt,$PhyIDs);
	}
}

?>