<?php
//define success xml return result
class SuccessXMLRet
{
	public $RetVal=XMLRet::Success ;
	public $Msg;//the msg will alert out
	public $Url;//the url of page jumpped to.
}
//define failure xml return result
class FailXMLRet
{
	public $RetVal=XMLRet::Fail ;
	public $Msg;//the msg will alert out
	public $Url;
}

class ContXMLRet
{
	public $RetVal=XMLRet::Cont;
	public $Msg;//the msg will alert out
	public $YesUrlType;
	public $YesUrl;//the url of page jumpped to.
	public $NoUrlType;
	public $NoUrl;//the url of page jumpped to.
}

class XMLRet
{
	const Success = 0;
	const Fail = 2;
	const Cont = 1;
}

class XMLRetUrlType
{
	const PageUrl = 0;//url of this type jump to some page.
	const CmdUrl = 1;//url of this type run as a command by ajax.
}

//the class Display xml result by smarty
class XMLRetDisplayer
{
	private $smarty;
	public function assignSmarty($smarty)
	{
		$this->smarty = $smarty;
	}
	
	public function display($CmdXmlRet)
	{
		switch (intval($CmdXmlRet->RetVal))
		{
			case XMLRet::Success :
				$TplFile = "XMLRetSuccess.tpl";
				$CmdXmlRet->Url = htmlspecialchars($CmdXmlRet->Url, ENT_QUOTES);
				break;
			case XMLRet::Fail:
				$TplFile = "XMLRetFail.tpl";
				$CmdXmlRet->Url = htmlspecialchars($CmdXmlRet->Url, ENT_QUOTES);
				break;
			case XMLRet::Cont :
				$TplFile = "XMLRetContinue.tpl";
				$CmdXmlRet->YesUrl = htmlspecialchars($CmdXmlRet->YesUrl, ENT_QUOTES);
				$CmdXmlRet->NoUrl = htmlspecialchars($CmdXmlRet->NoUrl, ENT_QUOTES);
				break;
		}
		$this->smarty->assign("cmdRet",$CmdXmlRet);
		$this->smarty->display($TplFile);
	}
}
?>