/*
 * Decompiled with CFR 0.152.
 */
package resources;

import java.text.DecimalFormat;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DoubleHolder {
    private Text _text;
    private double _lastValidInput = Double.NaN;
    Shell _shell;
    private double _maxValue = Double.MAX_VALUE;
    private double _minValue = Double.MIN_VALUE;
    private boolean _isMaxClosedInterval = true;
    private boolean _isMinClosedInterval = true;
    boolean _focusListenerEnabled = true;
    private int _precision;

    public boolean isMaxClosedInterval() {
        return this._isMaxClosedInterval;
    }

    public void setMaxClosedInterval(boolean isMaxClosedInterval) {
        this._isMaxClosedInterval = isMaxClosedInterval;
    }

    public boolean isMinClosedInterval() {
        return this._isMinClosedInterval;
    }

    public void setMinClosedInterval(boolean isMinClosedInterval) {
        this._isMinClosedInterval = isMinClosedInterval;
    }

    public DoubleHolder(Composite parent, int style, Shell shell, int precision) {
        this._text = new Text(parent, style);
        this._shell = shell;
        this._precision = precision;
        this._text.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent arg0) {
                if (arg0.keyCode == 0x1000001 || arg0.keyCode == 0x1000002 || arg0.keyCode == 0x1000003 || arg0.keyCode == 0x1000004 || arg0.keyCode == 131072 || arg0.keyCode == 262144 || arg0.keyCode == 0x1000008 || arg0.keyCode == 0x1000007) {
                    return;
                }
                DoubleHolder.this.checkInput(true, false);
            }

            public void keyPressed(KeyEvent arg0) {
            }
        });
        this._text.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent arg0) {
                if (DoubleHolder.this._shell.getDisplay().getActiveShell() != DoubleHolder.this._shell) {
                    return;
                }
                if (!DoubleHolder.this._focusListenerEnabled) {
                    return;
                }
                DoubleHolder.this.checkInput(true, true);
            }

            public void focusGained(FocusEvent arg0) {
                DoubleHolder.this._text.selectAll();
            }
        });
    }

    public void checkInput(boolean allowEmpty, boolean refresh) {
        double value;
        try {
            String rightBracket;
            String leftBracket;
            String text = this._text.getText().replaceAll(",", "");
            value = Double.valueOf(text);
            boolean isValid = true;
            if (this._isMinClosedInterval) {
                leftBracket = "[";
                if (value < this._minValue) {
                    isValid = false;
                }
            } else {
                leftBracket = "(";
                if (value < this._minValue) {
                    isValid = false;
                } else if (value == this._minValue && refresh) {
                    isValid = false;
                }
            }
            if (this._isMaxClosedInterval) {
                rightBracket = "]";
                if (value > this._maxValue) {
                    isValid = false;
                }
            } else {
                rightBracket = ")";
                if (value >= this._maxValue) {
                    isValid = false;
                }
            }
            if (!isValid) {
                MessageBox messageBox = new MessageBox(this._shell, 33);
                messageBox.setText("Invalid Value");
                messageBox.setMessage("The field's value must be in the range " + leftBracket + this._minValue + "," + this._maxValue + rightBracket + ". The value has been replaced by the last valid value.");
                this._focusListenerEnabled = false;
                messageBox.open();
                this._focusListenerEnabled = true;
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            if (allowEmpty && (this._text.getText().equals("-") || this._text.getText().length() == 0)) {
                return;
            }
            this.writeValue(this._lastValidInput);
            this._text.setSelection(this._text.getText().length());
            return;
        }
        if (refresh) {
            this._lastValidInput = value;
            this.writeValue(this._lastValidInput);
        }
    }

    public String formatDouble(double value) {
        StringBuilder format = new StringBuilder("#,###,###,##0.");
        for (int i = 0; i < this._precision; ++i) {
            format.append("0");
        }
        return new DecimalFormat(format.toString()).format(value);
    }

    public String readValue() {
        if (Double.isNaN(this._lastValidInput)) {
            return "";
        }
        return this.formatDouble(this._lastValidInput);
    }

    public void writeValue(double value) {
        if (!Double.isNaN(value)) {
            this._text.setText(this.formatDouble(value));
        } else {
            this._text.setText("");
        }
    }

    public double getValue() {
        if (Double.isNaN(this._lastValidInput)) {
            return 0.0;
        }
        return this._lastValidInput;
    }

    public void setValue(double value) {
        this._lastValidInput = value;
        this.writeValue(this._lastValidInput);
    }

    public Text getwidget() {
        return this._text;
    }

    public void setBounds(int i, int j, int k, int l) {
        this._text.setBounds(i, j, k, l);
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this._text.addModifyListener(modifyListener);
    }

    public void setMaximum(int i) {
        this._maxValue = i;
    }

    public void setMinimum(int i) {
        this._minValue = i;
    }

    public void setFont(Font font) {
        this._text.setFont(font);
    }

    public void setEnabled(boolean enabled) {
        this._text.setEnabled(enabled);
    }

    public void setLayoutData(Object layoutData) {
        this._text.setLayoutData(layoutData);
    }

    public Object getLayoutData() {
        return this._text.getLayoutData();
    }
}

