/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui.treeViewer;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.Device;
import pdtEditor.PdtFile;
import pdtEditor.Sensor;
import pdtEditor.gui.treeViewer.PdtContentProvider;
import pdtEditor.payloads.BusPayload;
import pdtEditor.validation.IValidatable;
import pdtEditor.validation.Issue;

public class PdtLabelProvider
implements ITableLabelProvider {
    private static final int ACTIVE_ISSUE = 1;
    private static final int IGNORED_ISSUE = 2;

    public void addListener(ILabelProviderListener arg0) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object arg0, String arg1) {
        return false;
    }

    public void removeListener(ILabelProviderListener arg0) {
    }

    public static Image getIssueImage(Issue.IssueType type, boolean active) {
        String file = null;
        String directory = "/resources/";
        if (type == null) {
            file = "OK.png";
        } else {
            switch (type) {
                case CRITICAL: {
                    file = active ? "error.png" : "error_gray.png";
                    break;
                }
                case WARNING: {
                    file = active ? "warning.png" : "warning_gray.png";
                    break;
                }
                case NOTIFICATION: {
                    String string = file = active ? "info.png" : "info_gray.png";
                }
            }
        }
        if (file != null) {
            return SWTResourceManager.getImage(PdtContentProvider.class, "/resources/" + file);
        }
        return null;
    }

    public static Image getObjectImage(Object object) {
        if (object instanceof IValidatable) {
            IValidatable valObject = (IValidatable)object;
            ArrayList<Issue> issues = valObject.getAllActiveIssues();
            Issue.IssueType highestIgnoredType = null;
            Issue.IssueType highestActiveType = null;
            for (Issue issue : issues) {
                switch (issue._issueType) {
                    case CRITICAL: {
                        if (issue.isIgnored() && (highestIgnoredType == null || highestIgnoredType.compareTo(Issue.IssueType.CRITICAL) > 0)) {
                            highestIgnoredType = Issue.IssueType.CRITICAL;
                            break;
                        }
                        if (issue.isIgnored() || highestActiveType != null && highestActiveType.compareTo(Issue.IssueType.CRITICAL) <= 0) break;
                        highestActiveType = Issue.IssueType.CRITICAL;
                        break;
                    }
                    case WARNING: {
                        if (issue.isIgnored() && (highestIgnoredType == null || highestIgnoredType.compareTo(Issue.IssueType.WARNING) > 0)) {
                            highestIgnoredType = Issue.IssueType.WARNING;
                            break;
                        }
                        if (issue.isIgnored() || highestActiveType != null && highestActiveType.compareTo(Issue.IssueType.WARNING) <= 0) break;
                        highestActiveType = Issue.IssueType.WARNING;
                        break;
                    }
                    case NOTIFICATION: {
                        if (issue.isIgnored() && (highestIgnoredType == null || highestIgnoredType.compareTo(Issue.IssueType.NOTIFICATION) > 0)) {
                            highestIgnoredType = Issue.IssueType.NOTIFICATION;
                            break;
                        }
                        if (issue.isIgnored() || highestActiveType != null && highestActiveType.compareTo(Issue.IssueType.NOTIFICATION) <= 0) break;
                        highestActiveType = Issue.IssueType.NOTIFICATION;
                        break;
                    }
                }
            }
            if (highestActiveType != null) {
                return PdtLabelProvider.getIssueImage(highestActiveType, true);
            }
            return PdtLabelProvider.getIssueImage(highestIgnoredType, false);
        }
        return null;
    }

    public Image getColumnImage(Object object, int col) {
        if (col != 0) {
            return null;
        }
        return PdtLabelProvider.getObjectImage(object);
    }

    public static String getColumnHeader(int col) {
        switch (col) {
            case 0: {
                return "";
            }
            case 1: {
                return "Sensor Type";
            }
            case 2: {
                return "Model";
            }
            case 3: {
                return "Instance";
            }
            case 4: {
                return "Flags";
            }
            case 5: {
                return "LUID";
            }
            case 6: {
                return "Bus Type";
            }
            case 7: {
                return "Bus Address";
            }
            case 8: {
                return "GPIO Interrupts";
            }
            case 9: {
                return "Calibration Set";
            }
        }
        return null;
    }

    public String getColumnText(Object arg0, int col) {
        if (arg0 instanceof PdtFile && col == 0) {
            return "PDT File";
        }
        if (arg0 instanceof Device && col == 0) {
            return ((Device)arg0).getDeviceShortName();
        }
        if (arg0 instanceof Sensor) {
            Sensor sensor = (Sensor)arg0;
            BusPayload busPayload = (BusPayload)sensor.getPayloadByClass(BusPayload.class);
            switch (col) {
                case 0: {
                    return (sensor.getLuid().getIsPhysical() ? "Physical" : "Virtual") + " Sensor";
                }
                case 1: {
                    return sensor.getLuid().getSensorTypeIdStr();
                }
                case 2: {
                    return sensor.getLuid().getSensorSubTypeIdStr();
                }
                case 3: {
                    return String.valueOf(sensor.getLuid().getInstanceId());
                }
                case 4: {
                    return sensor.getLuid().getFlagsStr();
                }
                case 5: {
                    return sensor.getLuid().getHexValue();
                }
                case 6: {
                    if (busPayload != null) {
                        return busPayload.getBusTypeName();
                    }
                    return null;
                }
                case 7: {
                    if (busPayload != null) {
                        return busPayload.getFormatedHexBusAddress();
                    }
                    return null;
                }
                case 8: {
                    return sensor.getUsedGPIOsStr();
                }
                case 9: {
                    return sensor.getCalibrationStatus();
                }
            }
            return null;
        }
        return null;
    }
}

