/*
 * Decompiled with CFR 0.152.
 */
package manager.utils.log;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

class HtmlFormatter
extends Formatter {
    HtmlFormatter() {
    }

    @Override
    public String format(LogRecord rec) {
        StringBuffer buf = new StringBuffer(1000);
        buf.append("<tr>\n");
        if (rec.getLevel().intValue() == Level.WARNING.intValue()) {
            buf.append("\t<td style=\"color:orange\">");
            buf.append("<b>");
            buf.append(rec.getLevel());
            buf.append("</b>");
        } else if (rec.getLevel().intValue() == Level.SEVERE.intValue()) {
            buf.append("\t<td style=\"color:red\">");
            buf.append("<b>");
            buf.append(rec.getLevel());
            buf.append("</b>");
        } else {
            buf.append("\t<td>");
            buf.append(rec.getLevel());
        }
        buf.append("</td>\n");
        buf.append("\t<td>");
        buf.append(this.calcDate(rec.getMillis()));
        buf.append("</td>\n");
        buf.append("\t<td>");
        buf.append(rec.getSourceClassName());
        buf.append("</td>\n");
        buf.append("\t<td>");
        buf.append(rec.getSourceMethodName());
        buf.append("</td>\n");
        buf.append("\t<td>");
        buf.append(this.formatMessage(rec));
        buf.append("</td>\n");
        buf.append("</tr>\n");
        return buf.toString();
    }

    private String calcDate(long millisecs) {
        SimpleDateFormat date_format = new SimpleDateFormat("MMM dd, yyyy HH:mm");
        Date resultdate = new Date(millisecs);
        return date_format.format(resultdate);
    }

    @Override
    public String getHead(Handler h) {
        return "<!DOCTYPE html>\n<head>\n<style>\ntable { width: 100% }\nth { font:bold 10pt Tahoma; }\ntd { font:normal 10pt Tahoma; }\nh1 {font:normal 11pt Tahoma;}\n</style>\n</head>\n<body>\n<h1>" + new Date() + "</h1>\n" + "<table border=\"0\" cellpadding=\"5\" cellspacing=\"3\">\n" + "<tr align=\"left\">\n" + "\t<th style=\"width:10%\">Loglevel</th>\n" + "\t<th style=\"width:10%\">Time</th>\n" + "\t<th style=\"width:8%\">Class</th>\n" + "\t<th style=\"width:8%\">Method</th>\n" + "\t<th style=\"width:64%\">Log Message</th>\n" + "</tr>\n";
    }

    @Override
    public String getTail(Handler h) {
        return "</table>\n</body>\n</html>";
    }
}

