/* SPDX-License-Identifier: GPL-2.0 or Linux-OpenIB */
/* Copyright (c) 2021 - 2023 Intel Corporation */
#ifndef IG3RDMA_HW_H
#define IG3RDMA_HW_H

#define IG3_MAX_APFS 1
#define IG3_MAX_AVFS 0
enum ig3rdma_device_caps_const {
	IG3RDMA_MAX_WQ_FRAGMENT_COUNT		= 14,
	IG3RDMA_MAX_SGE_RD			= 14,

	IG3RDMA_MAX_STATS_COUNT			= 128,

	IG3RDMA_MAX_IRD_SIZE			= 2048,
	IG3RDMA_MAX_ORD_SIZE			= 2048,
	IG3RDMA_MIN_WQ_SIZE			= 16 /* WQEs */,
	IG3RDMA_MAX_INLINE_DATA_SIZE		= 216,
	IG3RDMA_MAX_PF_PUSH_PAGE_COUNT		= 8192,
	IG3RDMA_MAX_VF_PUSH_PAGE_COUNT		= 16,
};

#endif /* IG3RDMA_HW_H*/
