/*************************************************************************************************************
 *                                                                                                           *
 *  Copyright (c) 2016 - 2023, Intel Corporation                                                             *
 *                                                                                                           *
 *  Redistribution and use in source and binary forms, with or without                                       *
 *  modification, are permitted provided that the following conditions are met:                              *
 *                                                                                                           *
 *      * Redistributions of source code must retain the above copyright notice,                             *
 *        this list of conditions and the following disclaimer.                                              *
 *      * Redistributions in binary form must reproduce the above copyright                                  *
 *        notice, this list of conditions and the following disclaimer in the                                *
 *        documentation and/or other materials provided with the distribution.                               *
 *      * Neither the name of Intel Corporation nor the names of its contributors                            *
 *        may be used to endorse or promote products derived from this software                              *
 *        without specific prior written permission.                                                         *
 *                                                                                                           *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"                              *
 *  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE                                *
 *  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE                           *
 *  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE                              *
 *  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL                               *
 *  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR                               *
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER                               *
 *  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,                            *
 *  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE                            *
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                                     *
 *                                                                                                           *
 *************************************************************************************************************
 *                                                                                                           *
 *  Module name:                                                                                             *
 *      freebsdnalioctl.h                                                                                    *
 *                                                                                                           *
 *  Abstract:                                                                                                *
 *      This file contains freebsdnalioctl.h                                                                 *
 *                                                                                                           *
 ************************************************************************************************************/
#ifndef INC_FREEBSD_FREEBSDTYPES_H_
#define INC_FREEBSD_FREEBSDTYPES_H_

#include <naltypes.h>
#include <freebsddefs.h>
#include <hwbus_t.h>

#ifdef NAL_DRIVER
#include <sys/bus.h>
#include <sys/rman.h>
#include <machine/resource.h>
#include <netinet/in.h>
#include <sys/socket.h>

#include <sys/types.h>
#include <sys/module.h>
#include <sys/systm.h>
#include <sys/param.h>
#include <sys/kernel.h>
#include <sys/conf.h>
#include <sys/uio.h>
#include <sys/malloc.h>
#else
#include <net/if.h>
#include <pthread.h>
#endif

/* This isnt used for user-mode but it needs SOME definition */
typedef UINTN       NAL_OS_SPECIFIC_DEVICE;

typedef struct _NAL_OS_SPEC_DEVICE_CONTEXT
{
    BOOLEAN     MarkedInUse;
    KVOID*      KernelModeContext;
    KVOID*      PciDevPtr;
    CHAR        InterfaceName[IFNAMSIZ];
    CHAR        InterfaceNameWithComma[IFNAMSIZ];
}   NAL_OS_SPEC_DEVICE_CONTEXT;

typedef struct _NAL_OS_SPEC_ISR_DEVICE
{
    UINT32          Signature;
    BOOLEAN         DeviceInterrupted;
    KVOID*          HardwareVirtualAddress;
    UINT32          Irq;
    UINT32          MacType;
} NAL_OS_SPEC_ISR_DEVICE;

#ifdef NAL_DRIVER
typedef struct _NAL_OS_SPEC_ADAPTER_IN_USE_TABLE
{
    NAL_DEVICE_LOCATION DeviceLocation;
    BOOLEAN             InUse;
} NAL_OS_SPEC_ADAPTER_IN_USE_TABLE;

typedef struct _NAL_OS_SPEC_PCI_ALLOCATION_SLOT
{
        KVOID*                      KernelAddress;
        NAL_PHYSICAL_ADDRESS        PhysicalAddress;
        struct resource *           Resource;
        int                         RegisterOffset;
        device_t                    Device;
} NAL_OS_SPEC_PCI_ALLOCATION_SLOT;

typedef struct _NAL_OS_SPEC_DMA_ALLOCATION_SLOT
{
        KVOID*                      KernelAddress;
        NAL_PHYSICAL_ADDRESS        PhysicalAddress;
        bus_dma_tag_t               DmaTag;
        bus_dmamap_t                DmaMap;
} NAL_OS_SPEC_DMA_ALLOCATION_SLOT;
#else

typedef struct _NAL_OS_SPEC_TIMER_OBJECT
{
    NAL_TIMER_CALLBACK  Callback;
    UINT32              ThreadId;
    struct itimerval    TimerVal;
    VOID*               Context;
} NAL_OS_SPEC_TIMER_OBJECT;

typedef struct _NAL_OS_SPEC_MEMORY_MAP_TABLE
{
    INT32                   ReferenceCount;
    VOID*                   VirtualAddress;
    VOID*                   AlignedVirtualAddress;
    NAL_PHYSICAL_ADDRESS    AlignedPhysicalAddress;
    UINT32                  Alignment;
    UINT32                  BytesAllocated;
} NAL_OS_SPEC_MEMORY_MAP_TABLE;

typedef struct NAL_OS_SPEC_NONPAGED_MEMORY_TABLE
{
    UINT32                  ReferenceCount;
    KVOID*                  VirtualAddress;
    VOID*                   MappedVirtualAddress;
} NAL_OS_SPEC_NONPAGED_MEMORY_TABLE;

typedef struct _NAL_OS_SPEC_DMA_PCI_MEMORY_TABLE
{
    UINT32                  ReferenceCount;
    KVOID*                  VirtualAddress;
    KVOID*                  KernelAddress;
    NAL_PHYSICAL_ADDRESS    PhysicalAddress;
    UINT32                  Size;
} NAL_OS_SPEC_DMA_PCI_MEMORY_TABLE;

typedef struct _NAL_OS_SPEC_THREAD_CONTEXT
{
        pthread_t           Thread;
        VOID*               Context;
        NAL_THREAD_FUNC     ThreadFunction;
        BOOLEAN             ThreadRunning;
} NAL_OS_SPEC_THREAD_CONTEXT;

typedef NAL_OS_SPEC_THREAD_CONTEXT NAL_THREAD_ID;

typedef struct _NAL_OS_SPEC_GLOBAL_VARIABLES
{
    BOOLEAN                           QvDriverMode;
    BOOLEAN                           MemMappingToUserSpaceDisabled;
    int                               NalFileDescriptor;
    int                               IoFileDescriptor;
    int                               MemFileDescriptor;
    int                               PciFileDescriptor;
    NAL_OS_SPEC_MEMORY_MAP_TABLE      MemoryMapTable[NAL_OS_SPEC_MAX_MEMORY_ALLOCATIONS];
    NAL_OS_SPEC_TIMER_OBJECT          TimerObjects[NAL_OS_SPEC_MAX_TIMERS];
    NAL_OS_SPEC_NONPAGED_MEMORY_TABLE NonPagedMapTable[NAL_OS_SPEC_MAX_MEMORY_ALLOCATIONS];
    NAL_OS_SPEC_DMA_PCI_MEMORY_TABLE  DmaPciMemoryTable[NAL_OS_SPEC_MAX_MEMORY_ALLOCATIONS];
} NAL_OS_SPEC_GLOBAL_VARIABLES;

#endif

#endif /* INC_FREEBSD_FREEBSDTYPES_H_ */
