ConvertFrom-StringData -StringData @'
AdaptiveIFS = Compensates for excessive Ethernet packet collisions by dynamically controlling back-to-back timing.

CPUSaver = Sets the number of frames the adapter receives before triggering an interrupt. Under normal operation, the adapter generates an interrupt every time a frame is received. 

UcodeSW = Optimizes performance based on the operating system.

Threshold = Specifies the number of bytes the adapter stores in its transmit buffer before sending. For example, if the Adaptive Transmit Threshold value is 100, the adapter stores 100 bytes in its buffer before sending the data.

NumCoalesce = Sets number of buffers available for transmit acceleration. Changing this setting can significantly increase transmit performance by enabling the adapter to join data segments before packet transmission.

*EncapsulatedPacketTaskOffloadNvgre = Selects Network Virtualization using Generic Routing Encapsulation (NVGRE) for encapsulated packet task processing. NVGRE encapsulates L2 packets for transmission over L3 networks. It leverages the Generic Routing Encapsulation protocol for greater compatibility with existing hardware and software stacks.

*EncapsulatedPacketTaskOffloadVxlan = Selects Virtual Extensible LAN (VXLAN) for encapsulated packet task processing. VXLAN encapsulates L2 packets leveraging standard UDP protocols, allowing an L2 network to be extended over an L3 network. VXLAN may be useful in multi-tenant environments such as cloud service providers where the number of VLANs exceeds the 4094 limit imposed by the 12 bit VLAN ID used in Ethernet data frames.

*EncapsulatedPacketTaskOffload = Allows you to enable or disable offloading encapsulated packet task processing from the CPU to the device, and select which type of processing to use. These features reduce CPU utilization.

*EncapOverhead = When you attach a Virtual Machine to a tenant overlay network through the Virtual NIC ports on a Virtual Switch, the encapsulation headers increase the Maximum Transmission Unit (MTU) size on the virtual port. The Encapsulation Overhead feature automatically adjusts the physical port's MTU size to compensate for this increase. This setting cannot be changed.

FECMode = Allows you to set the Forward Error Correction (FEC) mode. FEC improves link stability, but increases latency. Many high quality optics, direct attach cables, and backplane channels provide a stable link without FEC.

*FlowControl = Enables adapters to generate or respond to flow control frames, which help regulate network traffic.

GSOv4 = Sets the adapter to offload the task of segmenting TCP messages into valid Ethernet frames. Because the adapter hardware is able to complete data segmentation much faster than operating system software, this feature may improve transmission performance. In addition, the adapter uses fewer CPU resources. 

EnableRSC = Sets the adapter to offload the task of segmenting TCP messages into valid Ethernet frames. Because the adapter hardware is able to complete data segmentation much faster than operating system software, this feature may improve transmission performance. In addition, the adapter uses fewer CPU resources. 

GSOv6 = Sets the adapter to offload the task of segmenting TCP messages into valid Ethernet frames. Because the adapter hardware is able to complete data segmentation much faster than operating system software, this feature may improve transmission performance. In addition, the adapter uses fewer CPU resources.

GigabitPhyMode = Determines whether the adapter or link partner is designated as the primary. The other device is designated as the secondary device. Changing the setting may improve link quality with certain link partners.

*HeaderDataSplit = Enables the adapter to split the header information from an incoming packet so the CPU does not have to process the whole packet, reducing CPU utilization.

*RssOnHostVPorts = Enables Receive Side Scaling (RSS) for virtual ports attached to a physical port. This allows RSS to be used on a VMQ virtual machine, and offloads the RSS processing to the network adapter. RSS balances receive traffic across multiple CPUs or CPU cores. This setting has no effect if your system has only one processing unit.

ITR = This sets the rate at which the controller moderates or delays the generation of interrupts making it possible to optimize network throughput and CPU utilization. The Adaptive setting adjusts the interrupt rates dynamically depending on traffic type and network usage. Choosing a different setting may improve network and system performance in certain configurations. 

*InterruptModeration = Allows the adapter to moderate interrupts. When a packet arrives, the adapter generates an interrupt, which allows the driver to handle the packet. At greater link speeds, more interrupts are created, and CPU utilization also increases. This results in poor system performance. When you enable Interrupt Moderation, the interrupt rate is lower, and the result is better system performance.

*IPChecksumOffloadIPv4 = Enables the adapter to verify the IP checksum on received packets and compute checksum on transmitted packets. Enabling this feature may improve IP performance and reduce CPU utilization.

*IPChecksumOffloadIPv6 = Enables the adapter to verify the IP checksum on received packets and compute checksum on transmitted packets. Enabling this feature may improve IP performance and reduce CPU utilization.

*JumboPacket = Enables Jumbo Packet capability for TCP/IP packets. In situations where large packets make up the majority of traffic and additional latency can be tolerated, Jumbo Packets can reduce CPU utilization and improve wire efficiency. 

NetworkAddress = Changes the MAC address used by this network adapter. The address is a 12-digit hexadecimal number in this range: 0000 0000 0001 - FEFF FFFF FFFF.

LinkNegotiationProcess = Sets how link is established at 100Mbps and 10Mbps rates. When Enabled, the network connection will use the legacy Forced method to establish link. This can help to achieve link at the proper speed and duplex with some legacy switches. When Disabled, the network connection will use auto-negotiation to establish link at 100Mbps and 10Mbps speeds.

LinkOnIntDown = Sets if link is enabled or disabled when the interface is brought down. This setting is ignored and link will remain up if WoL or manageability is enabled on this device.

LogLinkState = Enables the logging of link state changes to the system event log.

LogLinkStateEvent = Enables the logging of link state changes to the system event log.

AlwaysConnectGoal = When this setting is enabled, the network adapter maintains network connectivity even if the system does not have enough resources to run all of the advanced settings, such as IPSec Offload and Large Send Offload. Advanced features resume only when you restart the computer.

MaxNumRssQueuesPerVPort = Sets the maximum number of Receive Side Scaling (RSS) queue pairs per VF.

*MaxRssProcessors = Sets the maximum number of logical processors available for Receive Side Scaling (RSS).

MDDAutoResetVFs = Automatically resets the virtual function immediately after the physical device detects a Malicious Driver Detection (MDD) event on the receive path.

*RssMaxProcNumber = Sets the highest CPU number that can be used for RSS (Receive Side Scaling).

*NetworkDirect = Allows the adapter to use Remote Direct Memory Access (RDMA).

*NetworkDirectTechnology = Allows you to set the RDMA mode.

NICPartitioning = Enables NPAR on this device. NPAR allows you to create multiple partitions for each physical port on a network adapter card. To the network and operating system, each partition appears as a separate physical port on the adapter.

*IPsecOffloadV2 = Saves CPU cycles by offloading IPSec encryption from the CPU to the adapter.

IPSecEnabled = Saves CPU cycles by offloading IPSec encryption from the CPU to the adapter.

IPSecOffv4 = Saves CPU cycles by offloading IPSec encryption from the CPU to the adapter.

ChecksumRxTcp = Enables the adapter to verify the TCP or UDP checksum of incoming packets. This feature enhances receive performance and reduces CPU utilization.

TcpSegmentation = Enables the adapter to offload the task of segmenting TCP messages into valid Ethernet frames. Because the adapter hardware is able to complete data segmentation much faster than operating system software, this feature may improve transmission performance. In addition, the adapter uses fewer CPU resources.

*LsoV2IPv4 = Enables the adapter to offload the task of segmenting TCP messages into valid Ethernet frames. Because the adapter hardware is able to complete data segmentation much faster than operating system software, this feature may improve transmission performance. In addition, the adapter uses fewer CPU resources.

*LsoV1IPv4 = Enables the adapter to offload the task of segmenting TCP messages into valid Ethernet frames. Because the adapter hardware is able to complete data segmentation much faster than operating system software, this feature may improve transmission performance. In addition, the adapter uses fewer CPU resources.

LSO = Enables the adapter to offload the task of segmenting TCP messages into valid Ethernet frames. Because the adapter hardware is able to complete data segmentation much faster than operating system software, this feature may improve transmission performance. In addition, the adapter uses fewer CPU resources.

*LsoV2IPv6 = Enables the adapter to offload the task of segmenting TCP messages into valid Ethernet frames. Because the adapter hardware is able to complete data segmentation much faster than operating system software, this feature may improve transmission performance. In addition, the adapter uses fewer CPU resources.

LargeSendEnabled = Enables the adapter to offload the task of segmenting TCP messages into valid Ethernet frames. Because the adapter hardware is able to complete data segmentation much faster than operating system software, this feature may improve transmission performance. In addition, the adapter uses fewer CPU resources.

Checksum = Enables the adapter to verify the TCP/IP checksum on received packets and compute checksum on transmitted packets. Enabling this feature may improve TCP/IP performance.

ChecksumRxIp = Enables the adapter to verify the TCP/IP checksum on received packets and compute checksum on transmitted packets. Enabling this feature may improve TCP/IP performance.

ChecksumTxIp = Enables the adapter to compute the IP checksum of transmitted packets. This feature may improve IP transmit performance and will reduce CPU utilization. With Offloading disabled, the operating system verifies the IP checksum.

ChecksumTxTcp = Enables the adapter to compute the TCP or UDP checksum of transmitted packets. This feature may improve TCP and UDP transmit performance and will reduce CPU utilization. With Offloading enabled, the adapter completes the verification for the operating system.

Coalesce = Combines transmit packet buffer fragments into a single buffer before sending them to the network.

EnableDca = Direct Cache Access (DCA) reduces the number of memory access operations required to process each packet by delivering packet data directly to system CPU cache.

DMACoalescing = Sets an upper limit on the maximum amount of latency applied to any network packet due to Direct Memory Access (DMA) Coalescing. DMA Coalescing synchronizes the DMA activity across all of a NIC's ports, decreasing the system's power consumption. Higher values increase the power savings, but may add latency to network sessions. To optimize the power savings, this setting should be set to the same value for all ports on a NIC.

EnableLLI = Enables adapters to bypass interrupt moderation and immediately generate an interrupt when certain TCP packets arrive, allowing the system to handle the packet more quickly. Certain applications will have faster access to network data because of the reduced data latency.

LLIPorts = Enables adapters to bypass interrupt moderation and immediately generate an interrupt when certain TCP packets arrive, allowing the system to handle the packet more quickly. Certain applications will have faster access to network data because of the reduced data latency.

*NumaNodeId = Allows the user to choose the preferred non-Uniform Memory Access (NUMA) node to be used for memory allocations made by the network adapter. In addition the system will attempt to use the CPUs from the preferred NUMA node first for the purposes of Receive Side Scaling (RSS). On NUMA platforms, memory access latency is dependent on the memory location. Allocation of memory from the closest node helps improve performance. The Windows* Task Manager shows the NUMA Node ID for each processor.

HPQPriorityLevel = If the computer has 802.1p/802.1Q tagging (QoS) enabled, you can define the priority levels serviced by the priority queues. Intel® Ethernet Adapters have two priority queues: high and low. The number you specify sets the lower limit of the high priority queue.

*PriorityVLANTag = This feature enables sending and receiving IEEE 802.3ac tagged frames.

PerformanceProfile = Specifies the Profile for the adapter. Selecting a profile sets several Advanced options for optimal performance for that role.

TaggingMode = When this feature is enabled, tagged packets use the queue settings defined by the operating system's Priority Level Definition. QoS Packet Tagging is automatically enabled when you set up a VLAN on the VLAN tab.

ConfigIFS = Increases the delay between frame retransmissions. Although there is a built-in Ethernet algorithm that adapters use for retransmitting frames after collisions, increasing the delay can improve network performance if there is an abnormally large number of collisions on the network.

*RSS = Enables Receive Side Scaling (RSS). RSS balances receive traffic across multiple CPUs or CPU cores. This setting has no effect if your system has only one processing unit.

RSSMode = Enables Receive Side Scaling (RSS). RSS balances receive traffic across multiple CPUs or CPU cores. This setting has no effect if your system has only one processing unit.

*RSSProfile = Configures how the Receive Side Scaling (RSS) load is balanced across the available processors.

*NumRssQueues = Configures the number of Receive Side Scaling (RSS) queues.

*ReceiveBuffers = Sets the number of Receive Buffers used by the adapter when copying data to memory. Increasing this value can enhance receive performance, but also consumes system memory.

NumRxDescriptors = Sets the number of Receive Descriptors used by the driver when copying data to the protocol memory. Increasing this value can enhance receive performance, but also consumes system memory.

NumRfd = Sets the number of Receive Descriptors used by the driver when copying data to the protocol memory. Increasing this value can enhance receive performance, but also consumes system memory.

SecurityAssociations = Specifies the number of simultaneous Security Associations that can be offloaded to the adapter. A security association is a communication session with another computer running IP Security software.

MaxNumSecAssoc = Specifies the number of simultaneous Security Associations that can be offloaded to the adapter. A security association is a communication session with another computer running IP Security software.

SmartSpeed = Enables the device downshift the link speed if the connection is of insufficient quality to support the highest speed. Set to disable if you don't want the device to downshift its link speed.

*RssBaseProcNumber = Allows the user to set the preferred starting Receive Side Scalling (RSS) processor. Change this setting if the current processor is dedicated to other processes.

*TCPChecksumOffloadIPv4 = Enables the adapter to verify the TCP checksum on received packets and compute checksum on transmitted packets. Enabling this feature may improve TCP performance and reduce CPU utilization.

*TCPChecksumOffloadIPv6 = Enables the adapter to verify the TCP checksum on received packets and compute checksum on transmitted packets. Enabling this feature may improve TCP performance and reduce CPU utilization.

*RSCIPv4 = Enables the adapter to collect packets from a TCP/IP stream and combine them into larger packets.

*RSCIPv6 = Enables the adapter to collect packets from a TCP/IP stream and combine them into larger packets.

*TransmitBuffers = Sets the number of Transmit Buffers used by the adapter when copying data to memory. Increasing this value can enhance transmission performance, but also consumes system memory.

NumTxDescriptors = Defines the number of Transmit Descriptors, which are data segments that enable the adapter to track transmit packets in the system memory. Depending on the size of the packet, each transmit packet requires one or more Transmit Descriptors.

NumTcb = Defines the number of Transmit Descriptors, which are data segments that enable the adapter to track transmit packets in the system memory. Depending on the size of the packet, each transmit packet requires one or more Transmit Descriptors.

*UDPChecksumOffloadIPv4 = Enables the adapter to verify the UDP checksum on received packets and compute checksum on transmitted packets. Enabling this feature may improve UDP performance and reduce CPU utilization.

*UDPChecksumOffloadIPv6 = Enables the adapter to verify the UDP checksum on received packets and compute checksum on transmitted packets. Enabling this feature may improve UDP performance and reduce CPU utilization.

*SRIOV = Enables SR-IOV (Single Root I/O Virtualization). This allows any attached virtual machine bound to the device to bypass the operating system's virtual switch and access the device directly. This setting is grayed out if Enable Virtual Machine Queues is not selected.

*VMQ = Enables Virtual Machine Queue (VMQ) Filter offloading. This offloads the filtering of receive and transmit traffic for each virtual machine into the adapter hardware. Filtering is based on MAC and/or VLAN filters. This increases receive and transmit performance, as the adapter hardware is able to perform these tasks faster than the operating system. Offloading also frees up CPU resources.

VlanId = Select the number for the VLAN bound to this device. The VLAN ID must match the VLAN ID configured on the switch. Adapters with VLANs must be connected to network devices that support IEEE 802.1Q. Note that if you enter a value greater than the maximum value of 4094 then VLAN ID 4094 will be assigned to this device.

WaitAutoNegComplete = Determines whether the driver waits for automatic detection or negotiation to be successful before reporting the link state.

ACBSMode = Enables the Intel® Auto Connect Battery Saver (Intel® ACBS) feature. This turns off the adapter when link is down or the network cable is disconnected. After a timeout period, the adapter will power off.

*PMARPOffload = Sets the adapter to respond to ARP requests without waking the system from sleep or hibernate. The system can remain in sleep or hibernate mode and still maintain its network presence.

DSPDMode = Turns off the adapter when link is down or the network cable is disconnected. After a timeout period, the adapter will power off. To the operating system, this appears as a hot-unplugged adapter. When the network cable is reconnected and link is restored, the NIC powers up and functionality is fully restored. This appears as a hot-plugged adapter.

EEELinkAdvertisement = Enables Energy Efficient Ethernet (EEE). EEE allows this device to transmit and receive packets with minimal bursts of energy and enter a low power state when idle.

EnhancedASPMPowerSaver = Saves power when the adapter is active by entering the L1 PCI Express low-power link state when there are no outstanding requests or pending transactions.

*PMNSOffload = Sets the adapter to respond to NS requests (NS requests are the IPv6 equivalent of ARP requests) without waking the system from sleep or hibernate. The system can remain in sleep or hibernate mode and still maintain its network presence.

AutoPowerSaverModeEnabled = Enables the Intel® Link Speed Battery Saver feature. Sets the adapter to negotiate the lowest possible speed setting while the computer is on battery power. 

SPDEnabled = Sets the adapter to reduce power consumption when the network cable is disconnected from the adapter or when the operating system is in Suspend mode. When the adapter regains a valid link, adapter power usage returns to its normal state (full power usage). 

*DeviceSleepOnDisconnect = Sets the adapter to reduce power consumption when the network cable is disconnected from the adapter or when the operating system is in Suspend mode. When the adapter regains a valid link, adapter power usage returns to its normal state (full power usage). 

SipsEnabled = Enables the Intel® System Idle Power Saver feature. Sets the adapter to negotiate the lowest possible speed setting when the system and network is idle. 

ReduceSpeedOnPowerDown = Sets the adapter to negotiate the lowest possible speed setting to save power while the computer is shut down.

SavePowerNowEnabled = Sets the adapter to negotiate the lowest possible speed setting to conserve power. 

Force10MbOnD3 = Sets the adapter to negotiate the lowest possible speed setting to save power while the computer is in standby mode.

*SelectiveSuspend = Enables the device to enter a low power state when the network is idle.

*SSIdleTimeout = Sets the length of time that the network is idle before the device enters a low power state. You must enable Selective Suspend for this setting to take effect.

ULPMode = Enabling Ultra Low Power (ULP) mode significantly reduces power consumption when the network cable is disconnected from the device.

EnablePME = Allows the adapter to wake an Advanced Power Management (APM) enabled system from a power-off (S5) state. ACPI systems can wake from an S5 state if the system's BIOS supports it.

*WakeOnMagicPacket = Enables a management station to bring the computer out of standby or hibernation when a Magic Packet* is sent directly to the adapter.

*WakeOnPattern = Enables this device to bring the computer out of standby or hibernation when it detects a packet with a specific pattern. The specific patterns are determined by the operating system.

*ModernStandbyWoLMagicPacket = Enables this device to bring the system out of the S0ix power state when the device receives a Magic Packet* .

WakeOnLink = Allows the adapter to wake an Advanced Power Management (APM) enabled system when the network connection establishes link. ACPI (Advanced Configuration and Power Interface) systems can wake from Standby (S3) or Hibernate (S4). If the system's BIOS supports it, ACPI systems can wake from a Power-off (S5) state.

STForwardDelay = Specifies the delay, in seconds, for the failover adapter to become active once link is established. Failover occurs when the current adapter loses link. This feature can be used to ensure Spanning Tree Protocol (STP) has sufficient convergence time before an adapter attempts to send traffic on the link. AFT, ALB, VMLB, and SFT teams use failover.

FailbackEnabled = Enables failback to the primary port of a team. This setting is only used if you set a port to Primary when you create or modify an AFT, SFT, VMLB, or ALB team. If you set a port to Primary and link is lost on that port, traffic on the team will failover to another port in the team (the Secondary port, if it was set). If link is regained on the Primary port, traffic on the team will failback to the Primary port. Disabling this setting prevents failback.

CheckTime = Specifies how often the software verifies team member status to ensure they are capable of sending and receiving traffic.

UserSelectedAddress = Changes the MAC address used by this network adapter. The address is a 12-digit hexadecimal number in this range: 0000 0000 0001 - FEFF FFFF FFFF.

BalanceInterval = Specifies the amount of time that passes before the software resets or refreshes the current load across Advanced Networking Services (ANS) team members. For best performance, keep this setting at the default or as low as possible.

NumRxPackets = Defines the number of packets used for receive packet flow. You might choose to increase the number of Receive packets if you notice a significant decrease in the performance of received traffic. If receive performance is not an issue, use the default setting. When using the default setting, the best value is automatically calculated based on team configuration and hardware capabilities.

NumTxPackets = Defines the number of packets used for transmit packet flow. You might choose to increase the number of Transmit packets if you notice a possible problem with transmit performance. If transmit performance is not an issue, use the default setting. When using the default setting, the best value is automatically calculated based on team configuration and hardware capabilities.

ProbeEnabled = Enables the use of probes for the team. Probes are packets passed over the network between team members to allow the Advanced Network Services (ANS) Teaming software to test the member's status. They do add a small amount of traffic to the network and should be turned off in near-capacity networks.

MaxNumProbeRetry = Defines the number of times a probe will be sent to an adapter, without a response from the adapter, before the adapter is marked disabled.
ProbePacketType = Broadcast probes are sent to all layer 2 Ethernet devices in the broadcast domain. Multicast probes can be configured to be sent to teamed adapter ports. Not all layer 2 devices support multicast. Check your switch documentation for details.

TeamTaggingMode = Enables the team to send and receive tagged frames meeting the 802.1Q VLAN and/or 802.1p QoS specifications.

ReceiveLoadBalancing = Allows you to enable or disable Receive Load Balancing (RLB). This is enabled by default on Adaptive Load Balancing teams. RLB requires a Primary adapter. Intel® PROSet will automatically assign a Primary adapter when the team is created.

RdmaMaxVfsEnabled = Sets the maximum number of Virtual Functions (VFs) bound to this port that support RDMA.

RdmaVfPreferredResourceProfile = Allocates a minimal number of RDMA resources (Queue Pairs, Completion Queues, etc.) to the host physical function (PF) so that more resources are available for any bound virtual function (VF).

*PtpHardwareTimestamp = Allows applications that use PTPv2 (Precision Time Protocol) to use hardware generated timestamps to synchronize clocks throughout your network.

*QosOffload = Configures the Quality of Service (QoS) offload setting for the miniport adapter. This feature allows you to set a bandwidth cap and reservation to one or more virtual machines on a physical device, including both software VMs and SR-IOV interfaces.

*SpeedDuplex = By default, Intel® devices are set to automatically detect and negotiate speed and duplex settings. If the adapter fails to connect, you can set the speed and duplex settings to match those of the link partner.

*SoftwareTimestamp = Allows applications that use PTPv2 (Precision Time Protocol) to use software generated timestamps to synchronize clocks throughout your network.

*UsoIPv4 = Enables the adapter to offload the task of segmenting UDP packets into valid Ethernet frames. Because the adapter hardware is able to complete data segmentation much faster than operating system software, this feature may improve transmission performance. In addition, the adapter uses fewer CPU resources.

*UsoIPv6 = Enables the adapter to offload the task of segmenting UDP packets into valid Ethernet frames. Because the adapter hardware is able to complete data segmentation much faster than operating system software, this feature may improve transmission performance. In addition, the adapter uses fewer CPU resources.
'@
