/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.payloads.calibrations;

import binTools.BinReader;
import binTools.BinWriter;
import binTools.Common;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import pdtEditor.DataStore;
import pdtEditor.Sensor;
import pdtEditor.exceptions.FeatureNotSupportedYetException;
import pdtEditor.payloads.calibrations.AgmVirtualCalibrationPayload;
import pdtEditor.validation.Validator;

public class VirtualAcclCalibrationPayload
extends AgmVirtualCalibrationPayload {
    public static final int CALIBRATION_TYPE = 2;
    public static final String CALIBRATION_FORMAT_STRING = "Calibrated Accelerometer Calibration";
    private static final String CALIBRATION_DATA_STRING = "Relevant data";
    public static final int LATEST_FORMAT_ID = 1;
    public static final int MINIMAL_PDT_FORMAT_VERSION = 4;
    private static final int NOISE_DEFAULT_VALUE = 8000;
    private static final int SCALE_FACTOR_DEFAULT_VALUE = 1;
    private static final int[] OFFSET_DEFAULT_VALUE = new int[]{0, 0, 0};
    private static final int[] SCALE_DEFAULT_VALUE = new int[]{1, 1, 1};
    private int _formatID = 1;
    private int _version;
    private int _sensorInBase;
    private int _lidAngle;
    private int _noise = 8000;

    public VirtualAcclCalibrationPayload() {
    }

    public VirtualAcclCalibrationPayload(VirtualAcclCalibrationPayload other) {
        super(other);
        this._formatID = other._formatID;
        this._version = other._version;
        this._sensorInBase = other._sensorInBase;
        this._lidAngle = other._lidAngle;
        this._noise = other._noise;
    }

    public VirtualAcclCalibrationPayload(int formatId, BinReader reader, Node payloadXmlNode) throws FeatureNotSupportedYetException {
        super(payloadXmlNode);
        this.checkPdtFormat();
        this._formatID = formatId;
        if (this._formatID > 1) {
            throw new FeatureNotSupportedYetException(this);
        }
        this._version = reader.readNewField((String)"Version", (int)1, (boolean)false, (Node)payloadXmlNode).value;
        Element virtualAcclCalibrationElement = reader.readNewField((String)"VirtualAcclCalibration", (Node)payloadXmlNode).xmlElement;
        this._noise = reader.readNewField((String)"Noise", (int)4, (boolean)false, (Node)virtualAcclCalibrationElement).value;
        this._sensorInBase = reader.readNewField((String)"SensorInBase", (int)1, (boolean)false, (Node)virtualAcclCalibrationElement).value;
        this._lidAngle = reader.readNewField((String)"LidAngle", (int)2, (boolean)false, (Node)virtualAcclCalibrationElement).value;
        reader.readNewField("ScaleFactor", 2, false, virtualAcclCalibrationElement);
        reader.readNewField("OffsetX", 4, false, virtualAcclCalibrationElement);
        reader.readNewField("OffsetY", 4, false, virtualAcclCalibrationElement);
        reader.readNewField("OffsetZ", 4, false, virtualAcclCalibrationElement);
        reader.readNewField("ScaleX", 2, false, virtualAcclCalibrationElement);
        reader.readNewField("ScaleY", 2, false, virtualAcclCalibrationElement);
        reader.readNewField("ScaleZ", 2, false, virtualAcclCalibrationElement);
    }

    @Override
    public boolean equals(Object arg0) {
        if (arg0 == null || !(arg0 instanceof VirtualAcclCalibrationPayload)) {
            return false;
        }
        VirtualAcclCalibrationPayload other = (VirtualAcclCalibrationPayload)arg0;
        return this._formatID == other._formatID && this._version == other._version && this._sensorInBase == other._sensorInBase && this._lidAngle == other._lidAngle && this._noise == other._noise;
    }

    @Override
    public VirtualAcclCalibrationPayload clone() {
        return new VirtualAcclCalibrationPayload(this);
    }

    private void checkPdtFormat() {
        if (DataStore.getInstance().getPdtFormatVersion() < 4) {
            throw new UnsupportedOperationException("The 'Calibrated Accelerometer Calibration' calibration is supported in PDT format version 4 and above.");
        }
    }

    @Override
    public void writeToPdt(BinWriter writer, Element parent) {
        super.writeToPdt(writer, parent);
        Common.Field payloadDataLength = writer.writeNewField("DataLength", 2, 0, (Node)parent);
        writer.addSizeCounter(payloadDataLength);
        writer.writeNewField("FormatId", 1, this._formatID, (Node)parent);
        writer.writeNewField("Version", 1, this._version, (Node)parent);
        Element virtualAcclCalibrationElement = writer.writeNewField((String)"VirtualAcclCalibration", (Node)parent).xmlElement;
        writer.writeNewField("Noise", 4, this._noise, (Node)virtualAcclCalibrationElement);
        writer.writeNewField("SensorInBase", 1, this._sensorInBase, (Node)virtualAcclCalibrationElement);
        writer.writeNewField("LidAngle", 2, this._lidAngle, (Node)virtualAcclCalibrationElement);
        writer.writeNewField("ScaleFactor", 2, 1, (Node)virtualAcclCalibrationElement);
        writer.writeNewField("OffsetX", 4, OFFSET_DEFAULT_VALUE[0], (Node)virtualAcclCalibrationElement);
        writer.writeNewField("OffsetY", 4, OFFSET_DEFAULT_VALUE[1], (Node)virtualAcclCalibrationElement);
        writer.writeNewField("OffsetZ", 4, OFFSET_DEFAULT_VALUE[2], (Node)virtualAcclCalibrationElement);
        writer.writeNewField("ScaleX", 2, SCALE_DEFAULT_VALUE[0], (Node)virtualAcclCalibrationElement);
        writer.writeNewField("ScaleY", 2, SCALE_DEFAULT_VALUE[1], (Node)virtualAcclCalibrationElement);
        writer.writeNewField("ScaleZ", 2, SCALE_DEFAULT_VALUE[2], (Node)virtualAcclCalibrationElement);
        writer.removeSizeCounter(payloadDataLength);
    }

    @Override
    public String getCalibrationFormatString() {
        return CALIBRATION_FORMAT_STRING;
    }

    @Override
    public String getCalibrationDataString() {
        return CALIBRATION_DATA_STRING;
    }

    @Override
    public int getFormatID() {
        return this._formatID;
    }

    @Override
    public void setFormatID(int formatID) {
        this._formatID = formatID;
    }

    @Override
    public int getVersion() {
        return this._version;
    }

    @Override
    public void setVersion(int version) {
        this._version = version;
    }

    @Override
    public boolean getSensorInBase() {
        return this._sensorInBase == 1;
    }

    @Override
    public void setSensorInBase(boolean sensorInBase) {
        this._sensorInBase = sensorInBase ? 1 : 0;
    }

    @Override
    public int getLidAngle() {
        return this._lidAngle;
    }

    @Override
    public void setLidAngle(int lidAngle) {
        this._lidAngle = lidAngle;
    }

    @Override
    public void setWhiteNoise(int whiteNoise) {
        this._noise = whiteNoise;
    }

    @Override
    public void checkValidity(Validator validator, Sensor sensor) {
    }

    public int hashCode() {
        return super.hashCode();
    }
}

