/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui;

import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.wb.swt.SWTResourceManager;
import resources.CustomSpinner;
import resources.DoubleHolder;

public class GuiUtils {
    public static final int MINIMAL_COL_WIDTH = 50;
    private static final int HIGHLIGHTER_SIZE = 2;
    private static int buttonWidth = 0;

    public static void showErrorMessage(Shell parent, String title, String message) {
        MessageBox messageBox = new MessageBox(parent, 513);
        messageBox.setText(title);
        messageBox.setMessage(message);
        messageBox.open();
    }

    public static void focusControl(Control control) {
        if (control instanceof Group) {
            Control[] grpItems = ((Group)control).getChildren();
            for (int i = 0; i < grpItems.length; ++i) {
                if (!grpItems[i].isEnabled()) continue;
                grpItems[i].setFocus();
                break;
            }
        } else {
            control.forceFocus();
        }
    }

    public static void setGridLayoutToComposite(Composite composite, int numColumns) {
        GuiUtils.setGridLayoutToComposite(composite, numColumns, false);
    }

    public static void setGridLayoutToComposite(Composite composite, int numColumns, boolean makeColumnsEqualWidth) {
        GridLayout gridLayout = new GridLayout(numColumns, makeColumnsEqualWidth);
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 10;
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 10;
        composite.setLayout((Layout)gridLayout);
    }

    public static Point getMiddleLocation(Shell shell, Display display) {
        Monitor primary = display.getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        return new Point(x, y);
    }

    public static int getButtonWidth(Control c) {
        if (buttonWidth == 0) {
            PixelConverter utilconvert = new PixelConverter(c);
            buttonWidth = utilconvert.convertHorizontalDLUsToPixels(61);
        }
        return buttonWidth;
    }

    public static int getPixelSizeWidth(Control control) {
        PixelConverter utilconvert = new PixelConverter(control);
        int fontsizew = utilconvert.convertWidthInCharsToPixels(1);
        return fontsizew;
    }

    public static int getPixelSizeHeight(Control control) {
        PixelConverter utilconvert = new PixelConverter(control);
        int fontsizeh = utilconvert.convertHeightInCharsToPixels(1);
        return fontsizeh;
    }

    private static void highlightItem(Object object, Color color) {
        if (object instanceof CustomSpinner) {
            object = ((CustomSpinner)object).getBasicSpinner();
        }
        if (object instanceof Control) {
            Control control = (Control)object;
            Composite highlighter = new Composite(control.getParent(), 0);
            highlighter.moveAbove(control);
            highlighter.setLayoutData(control.getLayoutData());
            highlighter.setBackground(color);
            GridLayout gridLayout = new GridLayout(1, false);
            gridLayout.marginWidth = 2;
            gridLayout.marginHeight = 2;
            gridLayout.horizontalSpacing = 0;
            gridLayout.verticalSpacing = 0;
            highlighter.setLayout((Layout)gridLayout);
            control.setParent(highlighter);
            highlighter.getShell().setSize(highlighter.getShell().getSize().x, highlighter.getShell().getSize().y + 4);
        } else {
            System.err.println("Cannot color item. The object type is not recognized.");
        }
    }

    public static void highlightItemError(Object object) {
        GuiUtils.highlightItem(object, SWTResourceManager.getColor(250, 128, 114));
    }

    public static void highlightItemWarning(Object object) {
        GuiUtils.highlightItem(object, SWTResourceManager.getColor(255, 255, 0));
    }

    public static void highlightItemInfo(Object object) {
        GuiUtils.highlightItem(object, SWTResourceManager.getColor(102, 178, 255));
    }

    public static boolean chooseComboItemByValue(Combo combo) {
        String input = combo.getText();
        for (int i = 0; i < combo.getItemCount(); ++i) {
            if (!combo.getItem(i).trim().toLowerCase().equals(input.trim().toLowerCase())) continue;
            combo.select(i);
            return true;
        }
        if (combo.getSelectionIndex() < 0) {
            try {
                if (input.length() > 0 && Integer.valueOf(input) < 0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public static ToolTip showToolTip(Shell shell, Point location, String text, int style, boolean autohide) {
        ToolTip t = new ToolTip(shell, style);
        t.setMessage(text);
        t.setAutoHide(autohide);
        t.setLocation(location);
        t.setVisible(true);
        return t;
    }

    public static ToolTip showBaloon(Shell shell, Control control, String text) {
        Point loaction = control.toDisplay(control.getLocation());
        loaction = new Point(loaction.x, loaction.y - 55);
        final ToolTip t = GuiUtils.showToolTip(shell, loaction, text, 4096, true);
        MouseTrackAdapter listener = new MouseTrackAdapter(){

            public void mouseHover(MouseEvent arg0) {
                if (t != null && !t.isDisposed()) {
                    t.setVisible(true);
                }
            }
        };
        control.addMouseTrackListener((MouseTrackListener)listener);
        return t;
    }

    public static Label addLabelToComposite(String text, Composite parent, int style, int horizontalAlignment, int verticalAlignment, boolean grabExcessHorizontalSpace, boolean grabExcessVerticalSpace, int horizontalSpan, int intverticalSpan) {
        Label newLabel = new Label(parent, style);
        newLabel.setText(text);
        newLabel.setLayoutData((Object)new GridData(horizontalAlignment, verticalAlignment, grabExcessHorizontalSpace, grabExcessVerticalSpace, horizontalSpan, intverticalSpan));
        return newLabel;
    }

    public static Group addGroupToComposite(String text, Composite parent, int style, int horizontalAlignment, int verticalAlignment, boolean grabExcessHorizontalSpace, boolean grabExcessVerticalSpace, int horizontalSpan, int intverticalSpan, int numColumns) {
        Group newGroup = new Group(parent, style);
        newGroup.setText(text);
        newGroup.setLayoutData((Object)new GridData(horizontalAlignment, verticalAlignment, grabExcessHorizontalSpace, grabExcessVerticalSpace, horizontalSpan, intverticalSpan));
        GuiUtils.setGridLayoutToComposite((Composite)newGroup, numColumns);
        return newGroup;
    }

    public static Composite addCompositeToComposite(Composite parent, int style, int horizontalAlignment, int verticalAlignment, boolean grabExcessHorizontalSpace, boolean grabExcessVerticalSpace, int horizontalSpan, int intverticalSpan, int numColumns) {
        Composite newComposite = new Composite(parent, style);
        newComposite.setLayoutData((Object)new GridData(horizontalAlignment, verticalAlignment, grabExcessHorizontalSpace, grabExcessVerticalSpace, horizontalSpan, intverticalSpan));
        GuiUtils.setGridLayoutToComposite(newComposite, numColumns);
        return newComposite;
    }

    public static Button addButtonToComposite(String text, String toolTip, Composite parent, int style, int horizontalAlignment, int verticalAlignment, boolean grabExcessHorizontalSpace, boolean grabExcessVerticalSpace, int horizontalSpan, int intverticalSpan) {
        Button newButton = new Button(parent, style);
        newButton.setText(text);
        newButton.setToolTipText(toolTip);
        newButton.setLayoutData((Object)new GridData(horizontalAlignment, verticalAlignment, grabExcessHorizontalSpace, grabExcessVerticalSpace, horizontalSpan, intverticalSpan));
        return newButton;
    }

    public static Combo addComboToComposite(Composite parent, int style, int horizontalAlignment, int verticalAlignment, boolean grabExcessHorizontalSpace, boolean grabExcessVerticalSpace, int horizontalSpan, int intverticalSpan) {
        Combo newCombo = new Combo(parent, style);
        newCombo.setLayoutData((Object)new GridData(horizontalAlignment, verticalAlignment, grabExcessHorizontalSpace, grabExcessVerticalSpace, horizontalSpan, intverticalSpan));
        return newCombo;
    }

    public static Text addTextToComposite(Composite parent, int style, int horizontalAlignment, int verticalAlignment, boolean grabExcessHorizontalSpace, boolean grabExcessVerticalSpace, int horizontalSpan, int intverticalSpan) {
        Text newText = new Text(parent, style);
        newText.setLayoutData((Object)new GridData(horizontalAlignment, verticalAlignment, grabExcessHorizontalSpace, grabExcessVerticalSpace, horizontalSpan, intverticalSpan));
        return newText;
    }

    public static CustomSpinner addCustomSpinnerToComposite(int maximum, Shell shell, Composite parent, int style, int horizontalAlignment, int verticalAlignment, boolean grabExcessHorizontalSpace, boolean grabExcessVerticalSpace, int horizontalSpan, int verticalSpan) {
        CustomSpinner newCustomSpinner = new CustomSpinner(parent, style, shell);
        newCustomSpinner.setMaximum(maximum);
        newCustomSpinner.setLayoutData(new GridData(horizontalAlignment, verticalAlignment, grabExcessHorizontalSpace, grabExcessVerticalSpace, horizontalSpan, verticalSpan));
        return newCustomSpinner;
    }

    public static DoubleHolder addDoubleHolderToComposite(int minimum, int maximum, int precision, Shell shell, Composite parent, int style, int horizontalAlignment, int verticalAlignment, boolean grabExcessHorizontalSpace, boolean grabExcessVerticalSpace, int horizontalSpan, int verticalSpan) {
        DoubleHolder newDoubleHolder = new DoubleHolder(parent, style, shell, precision);
        newDoubleHolder.setMaximum(maximum);
        newDoubleHolder.setMinimum(minimum);
        newDoubleHolder.setLayoutData(new GridData(horizontalAlignment, verticalAlignment, grabExcessHorizontalSpace, grabExcessVerticalSpace, horizontalSpan, verticalSpan));
        return newDoubleHolder;
    }

    public static Tree addTreeToComposite(String toolTip, Composite parent, int style, int horizontalAlignment, int verticalAlignment, boolean grabExcessHorizontalSpace, boolean grabExcessVerticalSpace, int horizontalSpan, int intverticalSpan) {
        Tree newTree = new Tree(parent, style);
        newTree.setToolTipText(toolTip);
        newTree.setLayoutData((Object)new GridData(horizontalAlignment, verticalAlignment, grabExcessHorizontalSpace, grabExcessVerticalSpace, horizontalSpan, intverticalSpan));
        return newTree;
    }

    public static abstract class WindowProperties {
        private boolean _modified = false;

        protected abstract void onModification();

        public void setModified(boolean modified) {
            this._modified = modified;
        }

        public boolean isModified() {
            return this._modified;
        }
    }
}

