/*
 * Decompiled with CFR 0.152.
 */
package pdtEditor.gui;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.wb.swt.SWTResourceManager;
import pdtEditor.DataStore;
import pdtEditor.FormFactorTable;
import pdtEditor.gui.DeviceProperties;
import pdtEditor.gui.GuiUtils;
import resources.CustomSpinner;

public class FormFactor {
    protected Shell shlFormFactor;
    private Display display;
    GuiUtils.WindowProperties _properties = new GuiUtils.WindowProperties(){

        @Override
        protected void onModification() {
        }
    };
    private Combo cmbType;
    private CustomSpinner maxHingeAngle;
    private Combo cmbHingeLocation;
    private Combo cmbScreenLocation;
    private Label lblMaxHingeAngle;
    private Label lblHingeLocation;
    private Label lblScreenLocation;
    private Button btnDefaultAdvancesConfig;
    private TabFolder tabFolder;
    private TabItem tbtmGeneral;
    private TabItem tbtmAdvanced;
    private Composite composite;
    private Composite composite_1;

    public static void main(String[] args) {
        try {
            FormFactor window = new FormFactor();
            window.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void open() {
        this.display = Display.getDefault();
        this.createContents();
        this.fillData();
        this.shlFormFactor.open();
        this.shlFormFactor.layout();
        while (!this.shlFormFactor.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    public void init() {
        this.cmbType.removeAll();
        for (FormFactorTable.FormFactorType formFactorType : FormFactorTable.FormFactorType.values()) {
            this.cmbType.add(formFactorType.getFriendlyName());
        }
        this.cmbHingeLocation.removeAll();
        for (Enum enum_ : FormFactorTable.HingeLocation.values()) {
            this.cmbHingeLocation.add(((FormFactorTable.HingeLocation)enum_).getFriendlyName());
        }
        this.cmbHingeLocation.select(0);
        this.cmbScreenLocation.removeAll();
        for (Enum enum_ : FormFactorTable.ScreenLocation.values()) {
            this.cmbScreenLocation.add(((FormFactorTable.ScreenLocation)enum_).getFriendlyName());
        }
        this.cmbScreenLocation.select(0);
        this.setDefaultAdvancedConfigValues();
    }

    public void fillData() {
        FormFactorTable formFactorTable;
        if (DataStore.getInstance().getCurrentPdtFile() == null) {
            System.err.println("null PDT file");
        }
        if ((formFactorTable = DataStore.getInstance().getCurrentPdtFile().getFormFactorTable()) == null) {
            return;
        }
        this.cmbType.setText(formFactorTable.getFormFactorType().getFriendlyName());
        GuiUtils.chooseComboItemByValue(this.cmbType);
        FormFactorTable.AdvancedConfiguration advancedConfig = formFactorTable.getAdvancedConfiguration();
        if (advancedConfig == null) {
            this.setDefaultAdvancedConfigValues();
        } else {
            this.btnDefaultAdvancesConfig.setSelection(false);
            this.maxHingeAngle.setSelection(advancedConfig.maxHingeAngle);
            this.cmbHingeLocation.setText(advancedConfig.hingeLocation.getFriendlyName());
            this.cmbScreenLocation.setText(advancedConfig.screenLocation.getFriendlyName());
        }
        this.refreshEnablement();
        this._properties.setModified(false);
    }

    public void refreshEnablement() {
        boolean manualAdvancedConfig = false;
        if (this.btnDefaultAdvancesConfig != null && !this.btnDefaultAdvancesConfig.isDisposed()) {
            manualAdvancedConfig = !this.btnDefaultAdvancesConfig.getSelection();
        }
        this.lblMaxHingeAngle.setEnabled(manualAdvancedConfig);
        this.lblHingeLocation.setEnabled(manualAdvancedConfig);
        this.lblScreenLocation.setEnabled(manualAdvancedConfig);
        this.maxHingeAngle.setEnabled(manualAdvancedConfig);
        this.cmbHingeLocation.setEnabled(manualAdvancedConfig);
        this.cmbScreenLocation.setEnabled(manualAdvancedConfig);
    }

    public void setDefaultAdvancedConfigValues() {
        try {
            FormFactorTable.AdvancedConfiguration defaults = FormFactorTable.getDefaultAdvancedConfigOfType(FormFactorTable.FormFactorType.getFormFactor(this.cmbType.getText()));
            if (defaults != null) {
                this.maxHingeAngle.setSelection(defaults.maxHingeAngle);
                this.cmbHingeLocation.setText(defaults.hingeLocation.getFriendlyName());
                this.cmbScreenLocation.setText(defaults.screenLocation.getFriendlyName());
            }
        }
        catch (Exception e) {
            return;
        }
    }

    public void saveData() {
        FormFactorTable formFactor = DataStore.getInstance().getCurrentPdtFile().getFormFactorTable();
        boolean newFormFactor = false;
        if (formFactor == null) {
            formFactor = new FormFactorTable();
            newFormFactor = true;
        }
        try {
            formFactor.setFormFactorType(FormFactorTable.FormFactorType.getFormFactor(this.cmbType.getText()));
            formFactor.setAdvancedConfiguration(!this.btnDefaultAdvancesConfig.getSelection() ? new FormFactorTable.AdvancedConfiguration(this.maxHingeAngle.getSelection(), FormFactorTable.HingeLocation.getHingeConnection(this.cmbHingeLocation.getText()), FormFactorTable.ScreenLocation.getClosingDirection(this.cmbScreenLocation.getText())) : null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        if (newFormFactor) {
            DataStore.getInstance().getCurrentPdtFile().addBdtObject(formFactor);
        }
        this._properties.setModified(false);
        this.shlFormFactor.close();
    }

    protected void createContents() {
        String maxHingeAngleToolTip = "If the device has no hinges, enter '0'.";
        String hingeLocationToolTip = "The location of the hinge relative to the primary screen.";
        String screenLocationTooltip = "The location of the screen when the hinge is fully closed.";
        this.shlFormFactor = new Shell(65632);
        this.shlFormFactor.setImage(SWTResourceManager.getImage(DeviceProperties.class, "/resources/Intel.ico"));
        this.shlFormFactor.setText("Form Factor");
        GuiUtils.setGridLayoutToComposite((Composite)this.shlFormFactor, 1);
        this.shlFormFactor.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent arg0) {
                if (FormFactor.this._properties.isModified()) {
                    MessageBox messageBox = new MessageBox(FormFactor.this.shlFormFactor, 296);
                    messageBox.setText("Closing without saving");
                    messageBox.setMessage("Some changes will be lost. Are you sure that you want to close the window without saving?");
                    if (messageBox.open() != 32) {
                        arg0.doit = false;
                        return;
                    }
                }
            }
        });
        this.tabFolder = new TabFolder((Composite)this.shlFormFactor, 0);
        this.tabFolder.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        GuiUtils.setGridLayoutToComposite((Composite)this.tabFolder, 1);
        this.tbtmGeneral = new TabItem(this.tabFolder, 0);
        this.tbtmGeneral.setText("General");
        this.tbtmAdvanced = new TabItem(this.tabFolder, 0);
        this.tbtmAdvanced.setText("Advanced");
        this.composite = GuiUtils.addCompositeToComposite((Composite)this.tabFolder, 0, 4, 128, true, true, 1, 1, 2);
        this.tbtmGeneral.setControl((Control)this.composite);
        this.composite_1 = GuiUtils.addCompositeToComposite((Composite)this.tabFolder, 0, 4, 128, true, true, 1, 1, 2);
        this.tbtmAdvanced.setControl((Control)this.composite_1);
        GuiUtils.addLabelToComposite("Enter the form factor of the target platform:", this.composite, 0, 16384, 0x1000000, false, false, 2, 1);
        GuiUtils.addLabelToComposite("Form factor type:", this.composite, 0, 16384, 0x1000000, false, false, 1, 1);
        this.cmbType = GuiUtils.addComboToComposite(this.composite, 8, 4, 4, true, false, 1, 1);
        this.btnDefaultAdvancesConfig = GuiUtils.addButtonToComposite("Use Default Configurations", "", this.composite_1, 32, 16384, 0x1000000, false, false, 2, 1);
        this.lblMaxHingeAngle = GuiUtils.addLabelToComposite("Maximum Hinge Angle (degrees):", this.composite_1, 0, 16384, 0x1000000, false, false, 1, 1);
        this.maxHingeAngle = GuiUtils.addCustomSpinnerToComposite(360, this.shlFormFactor, this.composite_1, 2048, 4, 0x1000000, true, false, 1, 1);
        this.lblHingeLocation = GuiUtils.addLabelToComposite("Hinge Location:", this.composite_1, 0, 16384, 0x1000000, false, false, 1, 1);
        this.cmbHingeLocation = GuiUtils.addComboToComposite(this.composite_1, 8, 4, 4, true, false, 1, 1);
        this.lblScreenLocation = GuiUtils.addLabelToComposite("Screen Location:", this.composite_1, 0, 16384, 0x1000000, false, false, 1, 1);
        this.cmbScreenLocation = GuiUtils.addComboToComposite(this.composite_1, 8, 4, 4, true, false, 1, 1);
        Composite compositeShellButton = GuiUtils.addCompositeToComposite((Composite)this.shlFormFactor, 0, 131072, 0x1000000, false, false, 1, 1, 2);
        Button button_1 = GuiUtils.addButtonToComposite("OK", "", compositeShellButton, 0, 131072, 0x1000000, true, false, 1, 1);
        Button button = GuiUtils.addButtonToComposite("Cancel", "", compositeShellButton, 0, 131072, 0x1000000, true, false, 1, 1);
        this.cmbType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FormFactor.this.btnDefaultAdvancesConfig != null && !FormFactor.this.btnDefaultAdvancesConfig.isDisposed() && FormFactor.this.btnDefaultAdvancesConfig.getSelection()) {
                    FormFactor.this.setDefaultAdvancedConfigValues();
                }
            }
        });
        this.btnDefaultAdvancesConfig.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormFactor.this.refreshEnablement();
                if (FormFactor.this.btnDefaultAdvancesConfig.getSelection()) {
                    FormFactor.this.setDefaultAdvancedConfigValues();
                }
            }
        });
        button_1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                FormFactor.this.saveData();
            }
        });
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                FormFactor.this.shlFormFactor.close();
            }
        });
        this.btnDefaultAdvancesConfig.setSelection(true);
        this.lblMaxHingeAngle.setToolTipText("If the device has no hinges, enter '0'.");
        this.maxHingeAngle.setToolTipText("If the device has no hinges, enter '0'.");
        this.lblHingeLocation.setToolTipText("The location of the hinge relative to the primary screen.");
        this.cmbHingeLocation.setToolTipText("The location of the hinge relative to the primary screen.");
        this.lblScreenLocation.setToolTipText("The location of the screen when the hinge is fully closed.");
        this.cmbScreenLocation.setToolTipText("The location of the screen when the hinge is fully closed.");
        int compositeMinHeight = GuiUtils.getPixelSizeHeight((Control)this.shlFormFactor) * 4;
        int shortButtonMinWidth = GuiUtils.getButtonWidth((Control)button);
        ((GridData)this.composite.getLayoutData()).heightHint = compositeMinHeight;
        ((GridData)this.composite_1.getLayoutData()).heightHint = compositeMinHeight;
        ((GridData)button_1.getLayoutData()).minimumWidth = shortButtonMinWidth;
        ((GridData)button.getLayoutData()).minimumWidth = shortButtonMinWidth;
        this.shlFormFactor.setSize(this.shlFormFactor.computeSize(-1, -1));
        this.shlFormFactor.setLocation(GuiUtils.getMiddleLocation(this.shlFormFactor, this.display));
        this.init();
        this.refreshEnablement();
        this._properties.setModified(false);
    }
}

