/*
 * Decompiled with CFR 0.152.
 */
package manager.pack.data;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class Version
implements Comparable<Version> {
    private final int major;
    private final int minor;
    private final int hotfix;
    private final int build;
    private static final String SEPARATOR = ".";
    public static final Version emptyVersion = new Version(0, 0, 0, 0);
    public static final Version debugVersion = new Version(1, 0, 0, 0);

    public Version(int major, int minor, int hotfix, int build) {
        this.major = major;
        this.minor = minor;
        this.hotfix = hotfix;
        this.build = build;
        this.validate();
    }

    public Version(int major, int minor, int hotfix) {
        this(major, minor, hotfix, 0);
    }

    public Version(String version) {
        int maj = 0;
        int min = 0;
        int hotf = 0;
        int bld = 0;
        try {
            StringTokenizer st = new StringTokenizer(version, SEPARATOR, true);
            maj = Version.parseInt(st.nextToken(), version);
            if (st.hasMoreTokens()) {
                st.nextToken();
                min = Version.parseInt(st.nextToken(), version);
                if (st.hasMoreTokens()) {
                    st.nextToken();
                    hotf = Version.parseInt(st.nextToken(), version);
                    if (st.hasMoreTokens()) {
                        st.nextToken();
                        bld = Version.parseInt(st.nextToken(), version);
                        if (st.hasMoreTokens()) {
                            throw new IllegalArgumentException("invalid version \"" + version + "\": invalid format");
                        }
                    }
                }
            }
        }
        catch (NoSuchElementException e) {
            IllegalArgumentException iae = new IllegalArgumentException("invalid version \"" + version + "\": invalid format");
            iae.initCause(e);
            throw iae;
        }
        this.major = maj;
        this.minor = min;
        this.hotfix = hotf;
        this.build = bld;
        this.validate();
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getHotfix() {
        return this.hotfix;
    }

    public int getBuild() {
        return this.build;
    }

    public static Version parseVersion(String version) {
        if (version == null) {
            return emptyVersion;
        }
        return Version.valueOf(version);
    }

    public static Version valueOf(String version) {
        if ((version = version.trim()).length() == 0) {
            return emptyVersion;
        }
        return new Version(version);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.major);
        result.append(SEPARATOR);
        result.append(this.minor);
        result.append(SEPARATOR);
        result.append(this.hotfix);
        result.append(SEPARATOR);
        result.append(this.build);
        return result.toString();
    }

    public int hashCode() {
        return this.major * 1000 + this.minor * 100 + this.hotfix * 10 + this.build;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Version)) {
            return false;
        }
        Version other = (Version)object;
        return this.major == other.major && this.minor == other.minor && this.hotfix == other.hotfix && this.build == other.build;
    }

    @Override
    public int compareTo(Version other) {
        if (other == this) {
            return 0;
        }
        int result = this.major - other.major;
        if (result != 0) {
            return result;
        }
        result = this.minor - other.minor;
        if (result != 0) {
            return result;
        }
        result = this.hotfix - other.hotfix;
        if (result != 0) {
            return result;
        }
        result = this.build - other.build;
        return result;
    }

    private static int parseInt(String value, String version) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            IllegalArgumentException iae = new IllegalArgumentException("invalid version \"" + version + "\": non-numeric \"" + value + "\"");
            iae.initCause(e);
            throw iae;
        }
    }

    private void validate() {
        if (this.major < 0) {
            throw new IllegalArgumentException("invalid version \"" + this.toString() + "\": negative number \"" + this.major + "\"");
        }
        if (this.minor < 0) {
            throw new IllegalArgumentException("invalid version \"" + this.toString() + "\": negative number \"" + this.minor + "\"");
        }
        if (this.hotfix < 0) {
            throw new IllegalArgumentException("invalid version \"" + this.toString() + "\": negative number \"" + this.hotfix + "\"");
        }
        if (this.build < 0) {
            throw new IllegalArgumentException("invalid version \"" + this.toString() + "\": negative number \"" + this.build + "\"");
        }
    }
}

