/*
 * Decompiled with CFR 0.152.
 */
package manager.common;

import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import manager.configure.Platform;
import manager.utils.ManagerUtils;

public class BuildVersion
implements Comparable<BuildVersion> {
    private int major;
    private int minor;
    private int hotfix;
    private int build;
    public static final String SEPARATOR = ".";
    public static final BuildVersion emptyVersion = new BuildVersion(0, 0, 0, 1);
    public static final BuildVersion debugVersion = new BuildVersion(9, 9, 9999, 9999);

    public BuildVersion(int major, int minor, int hotfix, int build) {
        this.major = major;
        this.minor = minor;
        this.hotfix = hotfix;
        this.build = build;
        this.validate();
    }

    public BuildVersion(String version, Platform platform) {
        int maj = 0;
        int min = 0;
        int hotf = 0;
        int bld = 0;
        try {
            StringTokenizer st = new StringTokenizer(version, SEPARATOR, true);
            maj = BuildVersion.parseInt(st.nextToken(), version, platform);
            if (st.hasMoreTokens()) {
                st.nextToken();
                min = BuildVersion.parseInt(st.nextToken(), version, platform);
                if (st.hasMoreTokens()) {
                    st.nextToken();
                    hotf = BuildVersion.parseInt(st.nextToken(), version, platform);
                    if (st.hasMoreTokens()) {
                        st.nextToken();
                        bld = BuildVersion.parseInt(st.nextToken(), version, platform);
                        if (st.hasMoreTokens()) {
                            throw new IllegalArgumentException("Invalid number \"" + version + "\": invalid format");
                        }
                    }
                }
            }
        }
        catch (NoSuchElementException e) {
            IllegalArgumentException iae = new IllegalArgumentException("Invalid number \"" + version + "\": invalid format");
            iae.initCause(e);
            throw iae;
        }
        this.major = maj;
        this.minor = min;
        this.hotfix = hotf;
        this.build = bld;
        this.validate();
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getHotfix() {
        return this.hotfix;
    }

    public int getBuild() {
        return this.build;
    }

    public void setBuild(int build) {
        this.build = build;
    }

    public static BuildVersion parseVersion(String version) {
        if (version == null) {
            return emptyVersion;
        }
        return BuildVersion.valueOf(version);
    }

    public static BuildVersion parseVersion(String version, Platform platform) {
        if (version == null || version.trim().length() == 0) {
            return emptyVersion;
        }
        return new BuildVersion(version, platform);
    }

    public static BuildVersion valueOf(String version) {
        if ((version = version.trim()).length() == 0) {
            return emptyVersion;
        }
        return new BuildVersion(version, null);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.major);
        result.append(SEPARATOR);
        result.append(this.minor);
        result.append(SEPARATOR);
        result.append(this.hotfix);
        result.append(SEPARATOR);
        result.append(this.build);
        return result.toString();
    }

    public int hashCode() {
        return this.major * 10000 + this.minor * 1000 + this.hotfix * 100 + this.build;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BuildVersion)) {
            return false;
        }
        BuildVersion other = (BuildVersion)object;
        return this.major == other.major && this.minor == other.minor && this.hotfix == other.hotfix && this.build == other.build;
    }

    @Override
    public int compareTo(BuildVersion other) {
        if (other == this) {
            return 0;
        }
        int result = this.major - other.major;
        if (result != 0) {
            return result;
        }
        result = this.minor - other.minor;
        if (result != 0) {
            return result;
        }
        result = this.hotfix - other.hotfix;
        if (result != 0) {
            return result;
        }
        result = this.build - other.build;
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int parseInt(String value, String buildVersion, Platform platform) {
        try {
            if (value.equals("TOSTRING(VER_MAJOR)")) {
                if (platform == null) {
                    return 0;
                }
                Double dd = platform.getValue();
                return dd.intValue();
            }
            if (value.equalsIgnoreCase("TOSTRING(VER_MINOR)")) {
                if (platform == null) {
                    return 0;
                }
                Double dd = platform.getValue();
                Double ret = (dd - (double)dd.intValue()) * 10.0;
                return ret.intValue();
            }
            if (!value.equalsIgnoreCase("TOSTRING(VER_FDK)")) return Integer.parseInt(value);
            String fdkVersion = "0";
            try {
                fdkVersion = ManagerUtils.getDefaultBuildFdkVersion();
                return Integer.parseInt(fdkVersion);
            }
            catch (IOException e) {
                fdkVersion = "0";
                return Integer.parseInt(fdkVersion);
            }
            catch (Exception e) {
                fdkVersion = "0";
            }
            return Integer.parseInt(fdkVersion);
        }
        catch (NumberFormatException e) {
            IllegalArgumentException exc = new IllegalArgumentException("Invalid number \"" + buildVersion + "\": non-numeric \"" + value + "\"");
            exc.initCause(e);
            throw exc;
        }
    }

    private void validate() {
        if (this.major < 0) {
            throw new IllegalArgumentException("Invalid number \"" + this.toString() + "\": negative integer \"" + this.major + "\"");
        }
        if (this.minor < 0) {
            throw new IllegalArgumentException("Invalid number \"" + this.toString() + "\": negative integer \"" + this.minor + "\"");
        }
        if (this.hotfix < 0) {
            throw new IllegalArgumentException("Invalid number \"" + this.toString() + "\": negative integer \"" + this.hotfix + "\"");
        }
        if (this.build < 0) {
            throw new IllegalArgumentException("Invalid number \"" + this.toString() + "\": negative integer \"" + this.build + "\"");
        }
    }

    public void validateVersionRange(int start, int end) {
        if (this.major < start || this.major >= end) {
            throw new IllegalArgumentException("Invalid number \"" + this.toString() + "\": major-" + this.major + " not in range \"" + "[" + start + "~" + end + ")" + "\"");
        }
        if (this.minor < start || this.minor >= end) {
            throw new IllegalArgumentException("Invalid number \"" + this.toString() + "\": minor-" + this.minor + " not in range \"" + "[" + start + "~" + end + ")" + "\"");
        }
        if (this.hotfix < start || this.hotfix >= end) {
            throw new IllegalArgumentException("Invalid number \"" + this.toString() + "\": hotfix-" + this.hotfix + " not in range \"" + "[" + start + "~" + end + ")" + "\"");
        }
        if (this.build < start || this.build >= end) {
            throw new IllegalArgumentException("Invalid number \"" + this.toString() + "\": build-" + this.build + " not in range \"" + "[" + start + "~" + end + ")" + "\"");
        }
    }
}

