<?php
class PgSubFlashDisplayer extends PageDisplayer {

    protected function initPage() {
	$filepath = realpath("../db") . "/Image";
        $this->setPageName("XML_Flash.tpl");
        $smarty = $this->smarty;

        $currentBinVersion = "0.0.0.0";   //get from hba info
        $currentDevID = 0;

        $container = new CtnHBADetail();
        $container->setID($this->getAdapterID());
        $container->toGetHBAInfo();
        $container->smartyAssign($smarty);
        $container->initContainer();

        $AdapterInfo = $container->getBase()->getBaseDetail();
        $supportSPC4 = getRequestPara('supportSPC4');
        if ($supportSPC4){
	    $type=3;
            $fileMaxSize = 1024 * 1024;
            $currentBinVersion = $AdapterInfo->getFirmwareVersion();
        }else{
            $type=2;
	    $fileMaxSize = 192 * 1024;
            $currentBinVersion = $AdapterInfo->getBIOSVersion();
	    }
        $smarty->assign("currentBinVersion", $currentBinVersion);

        if (getRequestPara("uploadFile") || getRequestPara("uploadFlash")) {
		if (getRequestPara("uploadFile")) {
            if (!isset($_FILES["boisFile"])) {
                    $smarty->assign("fileMaxSize", $fileMaxSize/1024);
                    $smarty->assign("flashResult", FlashResult::FLASH_FILETOOLARGE);
                    return;
                }
                if ($_FILES["boisFile"]["name"] != "") {
                    if ($_FILES["boisFile"]["error"] > 0){
                        $smarty->assign("flashResult",FlashResult::FLASH_INVALIDFILE);
                        return;
                    }
                    if ($_FILES["boisFile"]["size"] > $fileMaxSize) {
                        $smarty->assign("fileMaxSize", $fileMaxSize/1024);
                        $smarty->assign("flashResult", FlashResult::FLASH_FILETOOLARGE);
                        return;
                    }
                    move_uploaded_file($_FILES["boisFile"]["tmp_name"], $filepath);
                }
        }
	    //get bin file version
            $binVersion = "";
            $VenID = "";
            $DevID = "";

            $apiCmd = new XMLAPICommand();
            if( $type==2){
            $apiCmd->setCommand(XMLAPICommand::MV_BIOS_Version);
            }
            else{
            $apiCmd->setCommand(XMLAPICommand::MV_BIN_Version);
            }
            $apiCmd->setCommandPara('filepath', $filepath);
            $apiCmd->setCommandPara('Type', $type);
            $apiCmd->setCommandPara('AdapterID', $this->getAdapterID());
            $apiCmd->issueCommand();
            $xmlData = $apiCmd->getResult();

            if (isset($xmlData) && ($xmlData->RetVal . "" == 0)) //if successfully
            {
                $VerMajor = 0;
                $VerMinor = 0;
                $VerOEM = 0;
                $VerBuild = 0;

                if (isset($xmlData->BINInfo)) {
                    foreach ($xmlData->BINInfo as $boisInfo) {
                        if (isset($boisInfo->BINVersion)) {
                            foreach ($boisInfo->BINVersion as $bsVersion) {
                                foreach ($bsVersion->VerMajor as $version) {
                                    $VerMajor = trim($version);
                                }
                                foreach ($bsVersion->VerMinor as $version) {
                                    $VerMinor = trim($version);
                                }
                                foreach ($bsVersion->VerOEM as $version) {
                                    $VerOEM = trim($version);
                                }
                                foreach ($bsVersion->VerBuild as $version) {
                                    $VerBuild = trim($version);
                                }
                            }
                        }

                        if (isset($boisInfo->VenID)) {
                            $VenID = strtoupper(trim($boisInfo->VenID));
                        }
                        if (isset($boisInfo->DevID)) {
                            $DevID = strtoupper(trim($boisInfo->DevID));
                        }
                    }
                }

                if (isset($xmlData->BIOSInfo)) {
                    foreach ($xmlData->BIOSInfo as $boisInfo) {
                        if (isset($boisInfo->BIOSVersion)) {
                            foreach ($boisInfo->BIOSVersion as $bsVersion) {
                                foreach ($bsVersion->MajorVersion as $version) {
                                    $VerMajor = trim($version);
                                }
                                foreach ($bsVersion->MinorVersion as $version) {
                                    $VerMinor = trim($version);
                                }
                                foreach ($bsVersion->RevisionNumber as $version) {
                                    $VerOEM = trim($version);
                                }
                                foreach ($bsVersion->BuildNumber as $version) {
                                    $VerBuild = trim($version);
                                }
                            }
                        }

                        if (isset($boisInfo->VenID)) {
                            $VenID = strtoupper(trim($boisInfo->VenID));
                        }
                        if (isset($boisInfo->DevID)) {
                            $DevID = strtoupper(trim($boisInfo->DevID));
                        }
                    }
                }

                if ($VerMajor || $VerMinor || $VerOEM || $VerBuild) {
                    $binVersion = $VerMajor . "." . $VerMinor . "." . $VerOEM . "." . $VerBuild;
                    $smarty->assign("binVersion", $binVersion);
                    $smarty->assign("DevID", $DevID);
                    $smarty->assign("VenID", $VenID);
                    $smarty->assign("HBAID", $this->getAdapterID());
                }
            } else {  //get BIOS version failed
                $flashResult = FlashResult::FLASH_GETVERSIONFAILED;
                $smarty->assign("flashResult", FlashResult::FLASH_GETVERSIONFAILED );
            }
            $smarty->assign("filePath", $filepath);
            //check versions
            //check dev id
            //check vendor id
            $HBA = HBAFactory::getInstance($this->getAdapterID());
            $currentDevID = dechex($HBA->getDevID());
			$preDevID = substr($DevID, 0, 2);
            $preHBADevID = substr($currentDevID, 0, 2);
            if ($preDevID != strtoupper($preHBADevID))
            {
            	$smarty->assign("DevIDMismatch", 1);
            	$smarty->assign("CurrentDevID", $currentDevID);
            }
            $flashSuccess = 0;
            //flash firmware
            $sysFeature = AdapterFeature::getInstance($this->getAdapterID());
            if (file_exists($filepath) && getRequestPara("uploadFlash")) {
                if ($sysFeature->isSSDAdapter) { //ssd adapter, no check

                    $apiCmd = new XMLAPICommand();
                    $apiCmd->setCommand(XMLAPICommand::MV_SSD_UpdateIMG);
                    $apiCmd->setCommandPara('AdapterID', $this->getAdapterID());
                    $apiCmd->setCommandPara('Actions', FlashAction::FLASH_UPLOAD);
                    $apiCmd->setCommandPara('Type', $type);
                    $apiCmd->setCommandPara('filepath', $filepath);
                    //var_dump($apiCmd);

                    $apiCmd->issueCommand();

                    if ($apiCmd->getResult()->RetVal . "" == 0) {
                        $flashSuccess = FlashResult::FLASH_SUCCESS ;
                    }
                    else {
                        $flashSuccess = FlashResult::FLASH_UPLOADFAILED ;
                    }

                }else {
                        $apiCmd = new XMLAPICommand();
                        $apiCmd->setCommand(XMLAPICommand::MV_Flash_Option);
                        $apiCmd->setCommandPara('AdapterID', $this->getAdapterID());
                        $apiCmd->setCommandPara('Actions', FlashAction::FLASH_UPLOAD);
                        $apiCmd->setCommandPara('Type', $type);
                        $apiCmd->setCommandPara('filepath', $filepath);

                        $apiCmd->issueCommand();

                        if ($apiCmd->getResult()->RetVal . "" == 0) {
                            $flashSuccess = FlashResult::FLASH_SUCCESS ;
                        }
                        else {
                            $flashSuccess = FlashResult::FLASH_UPLOADFAILED ;
						}

                }
                $flashResult = $flashSuccess;
                $smarty->assign("flashResult", $flashSuccess);

                //always remove the file after operations
                if (file_exists($filepath) && trim($filepath) !== "") {
                    unlink($filepath);
                }
            }


            $smarty->assign("supportSPC4", getRequestPara('supportSPC4'));
            $smarty->assign("filePath", $filepath);
            $smarty->assign("HBAID", $this->getAdapterID());
            $smarty->assign("result", 1);
        }
    }
}

?>
