<?php
//include_once("PageDisplayer.class.php");

class PgCreateDgDisplayer extends PageDisplayer
{
	protected function initPage()
	{
		if(!getSessionPara('isAdmin'))
		{
			$this->displayDefaultPage(Target::getSystemSubPage);
			return;
		}
		
		$smarty = $this->smarty;
		//get request para
	
		$CancelAlert = gettext(AlertMsg::CREATE_CANCEL)."?";
				
		$HBAs = HBAFactory::getAllInstance();
		$supportRaidHBAIDs = array();
		foreach ($HBAs as $HBA)
		{
			if ($HBA->supportRAID()) {
				$supportRaidHBAIDs[] = $HBA->getDeviceID();
			}
		}
		if (sizeof($supportRaidHBAIDs) == 0) {
			$this->displayDefaultPage(Target::getSystemSubPage);
			return;
		}
		$smarty->assign("HBAIDs",$supportRaidHBAIDs);
		
		$HBAID = $this->getAdapterID();
		if ($HBAID == null) {
			$HBAID = $supportRaidHBAIDs[0];
		}
		
		//$this->setHBAID($HBAID);
		
		$hba = HBAFactory::getInstance($HBAID);
		$supportRaids = array();
		if ($hba->supportLDRaid0()) {
			$supportRaids[RAIDMode::LD_MODE_RAID0] = RAIDMode::RAID0;
		}
		if ($hba->supportLDRaid1()) {
			$supportRaids[RAIDMode::LD_MODE_RAID1] = RAIDMode::RAID1;
		}
		if ($hba->supportLDRaid10()) {
			$supportRaids[RAIDMode::LD_MODE_RAID10] = RAIDMode::RAID10;
		}
		if ($hba->supportLDRaid1E()) {
			$supportRaids[RAIDMode::LD_MODE_RAID1E] = RAIDMode::RAID1E;
		}
		if ($hba->supportLDRaid5()) {
			$supportRaids[RAIDMode::LD_MODE_RAID5] = RAIDMode::RAID5;
		}
		if ($hba->supportLDRaid50()) {
			$supportRaids[RAIDMode::LD_MODE_RAID50] = RAIDMode::RAID50;
		}
		if ($hba->supportLDRaid6()) {
			$supportRaids[RAIDMode::LD_MODE_RAID6] = RAIDMode::RAID6;
		}
		if ($hba->supportLDRaid60()) {
			$supportRaids[RAIDMode::LD_MODE_RAID60] = RAIDMode::RAID60;
		}
		if ($hba->supportLDRaidJBOD()) {
			$supportRaids[RAIDMode::LD_MODE_JBOD] = RAIDMode::JBOD;
		}
	
		/*$stripeOptions1 = 
			array(
				LDStripeSize::StripeSize16K =>LDStripeSize::StripeSize16KStr,
				LDStripeSize::StripeSize32K =>LDStripeSize::StripeSize32KStr,
				LDStripeSize::StripeSize64K =>LDStripeSize::StripeSize64KStr,
				LDStripeSize::StripeSize128K =>LDStripeSize::StripeSize128KStr
			);
			
		$stripeOptions2 = 
			array(
				LDStripeSize::StripeSize256K =>LDStripeSize::StripeSize256KStr,
				LDStripeSize::StripeSize512K =>LDStripeSize::StripeSize512KStr,
				LDStripeSize::StripeSize1024K =>LDStripeSize::StripeSize1024KStr 
			);*/
			
		$stripeOptions = array();
		//if ($hba->supportBigStripe()) {
			if ($hba->supportStripeSize16()){
				$stripeOptions[LDStripeSize::StripeSize16K] = LDStripeSize::StripeSize16KStr;
			}
			if ($hba->supportStripeSize32()){
				$stripeOptions[LDStripeSize::StripeSize32K] = LDStripeSize::StripeSize32KStr;
			}
			if ($hba->supportStripeSize64()){
				$stripeOptions[LDStripeSize::StripeSize64K] = LDStripeSize::StripeSize64KStr;
			}
			if ($hba->supportStripeSize128()){
				$stripeOptions[LDStripeSize::StripeSize128K] = LDStripeSize::StripeSize128KStr;
			}
			if ($hba->supportStripeSize256()){
				$stripeOptions[LDStripeSize::StripeSize256K] = LDStripeSize::StripeSize256KStr;
			}
			if ($hba->supportStripeSize512()){
				$stripeOptions[LDStripeSize::StripeSize512K] = LDStripeSize::StripeSize512KStr;
			}
			if ($hba->supportStripeSize1024()){
				$stripeOptions[LDStripeSize::StripeSize1024K] = LDStripeSize::StripeSize1024KStr;
			}
		/*	if (sizeof($stripeOptions) == 0) {
				$stripeOptions = ($stripeOptions1 + $stripeOptions2);
			}
		} else {
			$stripeOptions = $stripeOptions1;
		}*/
		
		$smarty->assign("stripeOptions",$stripeOptions);
		$smarty->assign("DefaultRaidMode", RAIDMode::LD_MODE_RAID1); //set R1 as default
		$smarty->assign("HBAID", $HBAID);
		$smarty->assign("supportRaids", $supportRaids);
		$smarty->assign("CancelAlert", $CancelAlert);
		
		//hd list
		$hdlist  = new CtnHdList();		
		$hdlist->setAdapterID($HBAID);
		$hdlist->toGetHDInfo();
		$hdlist->toGetValidSize();
		$hdlist->toGetSpareInfo();
		$hdlist->toGetHdFreeInfo();
		$hdlist->setFilter(new HdCreateFilter());
		$hdlist->smartyAssign($smarty);
		$hdlist->initContainer();
		
		$this->setPageName(Target::CreateDgPage . ".tpl");
	}
}
?>