<?php
abstract class PageDisplayer {
    protected $smarty;
    protected $PageTplName;
    protected $AdapterID = 0xff;

    public function smartyAssign($smarty) {
        $this->smarty = $smarty;
    }

    public function setPageName($PageName) {
        $this->PageTplName = $PageName;
    }

    public function getPageName() {
        return $this->PageTplName;
    }

    public function setAdapterID($HBAID) {
        $this->AdapterID = $HBAID;
    }

    public function getAdapterID() {
        return $this->AdapterID;
    }

    private function setMRUFeatures() {
        if ($this->AdapterID == 0xff) {
            $sysFeature = AdapterFeature::getInstance(0);
        }
        else {
            $sysFeature = AdapterFeature::getInstance($this->AdapterID);
        }

        $this->smarty->assign("sysFeature", $sysFeature);
    }

    public function display() {
    	
	if (isset($_SERVER["HTTPS"]) && $_SERVER["HTTPS"]) {
		recordHTTPs(1);
	} else {
		recordHTTPs(0);
	}
        if (getRequestPara("logout") != "") {
            //for command action
            $this->displayLoginPage();
            $this->smarty->assign("logout", getRequestPara("logout"));
        }else if ( (!getCookiePara("isLogUser")) && (!getCookiePara(USERID))
                && (getRequestPara('Target') != Target::LoginPage)
                && (getRequestPara('Target') != Target::AboutPage )
                && (getRequestPara('Target') != Target::AcceleratorSchedulePopup )) {
            //if havenot logined and don't want to login, go to login page
            $this->jumptoLoginPage();
        }
        else {
            $this->AdapterID = getRequestPara("HBAID");
            $this->smarty->assign("HBAID", $this->AdapterID);
            $this->initPage();
            $this->setMRUFeatures();
        }

        if(strlen(trim($this->PageTplName)))
            $this->smarty->display($this->PageTplName);

    }

    public function displayDefaultPage($defaultPage) {
        header("Location: " . getBaseURL()
                . PHPPageName::TargetPageName
                . "?" . "Target=" . $defaultPage . "&ra=" . rand(0,999999) );
    }

    protected function jumptoPage($pageUrlPara) {
        header("Location: " . getBaseURL()
                . PHPPageName::TargetPageName
                . "?" . $pageUrlPara
                . "&reqID=" . rand(0,999999)
        );
    }

    protected function jumptoMainPage() {
        header("Location: " . getBaseURL()
                . PHPPageName::TargetPageName
                . "?" . "Target=" . Target::MarvellRaidPage
                . "&reqID=" . rand(0,999999));
    }

    protected function jumptoLoginPage() {
        
        $urlParam = "";
        if(getRequestPara(LOCAL_LAUNCH_ID) != "") {
            $urlParam .= "&" . LOCAL_LAUNCH_ID . "=" . getRequestPara(LOCAL_LAUNCH_ID);
        }

        header("Location: " . getSecureBaseURL()
                . PHPPageName::TargetPageName
                . "?" . "Target=" . Target::LoginPage
                . "&reqID=" . rand(0,999999) . $urlParam);

    }

    protected function displayLoginPage() {
        $this->setPageName("XML_PermissionDenied.tpl");
        $this->smarty->assign("loginUrl", getSecureBaseURL() . PHPPageName::TargetPageName
                . "?" . "Target=" . Target::LoginPage . "&amp;reqID=" . rand(0,999999));
    }

    protected abstract function initPage();
}
?>
