<?php
class PgSSDCreateVolumeDisplayer extends PageDisplayer {
	protected function initPage()
	{
		$smarty = $this->smarty;

		$driveModesOptions = 
			array(
				SSDDriveMode::SSD_NO_DATA_PROTECTION =>SSDDriveMode::SSD_NO_DATA_PROTECTION_STR, 
				SSDDriveMode::SSD_ENABLE_DATA_PROTECTION =>SSDDriveMode::SSD_ENABLE_DATA_PROTECTION_STR
			);
			
		$opLevelOptions = 
			array(
				SSDOpeatingLevel::SSD_STANDARD_WRITE_PERFORMANCE => SSDOpeatingLevel::SSD_STANDARD_WRITE_PERFORMANCE_STR,    //default value
				SSDOpeatingLevel::SSD_MAXIMUM_WRITE_PERFORMANCE => SSDOpeatingLevel::SSD_MAXIMUM_WRITE_PERFORMANCE_STR,
			);
			
		//hd list
		$hdlist  = new CtnHdList();
		$hdlist->setAdapterID($this->getAdapterID());
		$hdlist->toGetHDInfo();
		$hdlist->smartyAssign($smarty);
		$hdlist->initContainer();
		$hds = $hdlist->getInfos();
		
		$HDIDs = "";
		foreach ($hds as $hd)
		{
			$HDIDs .= $hd->ID . " ";			
		}
		
		//var_dump($HDIDs);
		
		include_once("../phpsrc/action/GetAllSSDStatus.class.php");
		$getSSDStatus = new GetAllSSDStatus();
		$getSSDStatus->smartyAssign($smarty);
		$getSSDStatus->setAdapterID($this->getAdapterID());
		$getSSDStatus->setAllSSDStatus();
		
		$status = $getSSDStatus->getStatus();
		if ($status == SSDCreateVolumeStatus::CREATE_VD_SUCCESS){ //jump to hba page
			$smarty->assign("MaxBgaRate",BgaRateRange::MaxBgaRate );
			$smarty->assign("MinBgaRate",BgaRateRange::MinBgaRate );
			
			$container = new CtnHBADetail();
			$container->setID($this->getAdapterID());
			$container->toGetHBAInfo();
			$container->toGetHBAConfig();
			$container->smartyAssign($smarty);
			$container->initContainer();
			$smarty->assign("ssdDisableOperation",1);
			
			$this->setPageName("XML_AdapterDetail.tpl");
		} else {
			$smarty->assign("driveModesOptions",$driveModesOptions);
			$smarty->assign("opLevelOptions",$opLevelOptions);
			
			include_once("../phpsrc/action/GetCurrentCreatePara.class.php");
			$getSSDStatus = new GetCurrentCreatePara();
			$getSSDStatus->smartyAssign($smarty);
			$getSSDStatus->setAdapterID($this->getAdapterID());
			$getSSDStatus->setCurrentCreatePara();
			
			$smarty->assign("HDIDs",$HDIDs);
			
			$this->setPageName("XML_SSDCreateVolumePage.tpl");
		}
	}
}

?>