<?php
class HBADetail extends HBABase 
{
	private $ID;
	
	public function setID($ID)
	{
		$this->ID = $ID;
	}
	
	public function getID()
	{
		return $this->ID;
	}
	
	public function toGetHBAInfo()
	{
		$XMLApiCmd = new XMLAPICommand();
		$XMLApiCmd->setCommand(XMLAPICommand::MV_Adapter_GetInfo);
		$XMLApiCmd->setCommandPara("AdapterID",$this->ID);
		
		$this->XMLAPICommandList['setHBAInfo'] = $XMLApiCmd;
	}
	
	public function toGetHBAConfig()
	{
		$XMLApiCmd = new XMLAPICommand();
		$XMLApiCmd->setCommand(XMLAPICommand::MV_Adapter_GetConfig);
		$XMLApiCmd->setCommandPara("AdapterID",$this->ID);
		
		$this->XMLAPICommandList['setHBAConfig'] = $XMLApiCmd;
	}
	
	//should run after other toGetXXX()
	public function toGetSuspendMode()
	{
		$XMLApiCmd = new XMLAPICommand();
		$XMLApiCmd->setCommand(XMLAPICommand::MV_GetDriverMode);
		
		$this->XMLAPICommandList['setSuspendModeInfo'] = $XMLApiCmd;
	}
	
	protected function prepareAPICommands()
	{
		
	}
	
	/*
	for HBA xml data doesn't display ID
	*/
	
	protected function setHBAInfo($data)
	{
		$XMLRoot = $data;
		
		if (isset($XMLRoot->AdapterInfo->DriverVersion)) {
			if ($this->BaseClasses) {
				foreach ($XMLRoot->AdapterInfo as $AdapterInfo)
				{
					foreach ($this->BaseClasses as $Adapter)
					{
						$Adapter->setHBAInfo($AdapterInfo);
					}
				}
			}
			else 
			{
				foreach ($XMLRoot->AdapterInfo as $AdapterInfo)
				{
					$HBA = new HBA();
					$HBA->setDeviceID(trim($this->ID));
					$HBA->setHBAInfo($AdapterInfo);
					$this->BaseClasses[] = $HBA;
				}
			}
		}
	}
	
	protected function setHBAConfig($data)
	{
		$XMLRoot = $data;
		
		if (isset($XMLRoot->AdapterInfo->AlarmOn)) {
			if ($this->BaseClasses) {
				foreach ($XMLRoot->AdapterInfo as $AdapterInfo)
				{
					foreach ($this->BaseClasses as $Adapter)
					{
						$Adapter->setHBAConfig($AdapterInfo);
					}
				}
			}
			else 
			{
				foreach ($XMLRoot->AdapterInfo as $AdapterInfo)
				{
					$HBA = new HBA();
					$HBA->setDeviceID(trim($this->ID));
					$HBA->setHBAConfig($AdapterInfo);
					$this->BaseClasses[] = $HBA;
				}
			}
		}
	}
	
	protected function setDataToBaseClass()
	{
		
	}
	
	public function loadTestData()
	{
		$Path = "../phpsrc/baseclass/testdata/hba/";
		$Files = array("MV_Adapter_GetInfo", "MV_Adapter_GetConfig","MV_GetDriverMode");
		
		foreach ($Files as $File)
		{
			foreach ($this->XMLAPICommandList as $APICmd)
			{
				if (strpos($APICmd->getCommand(),$File)) {
					$data = simplexml_load_file($Path . $File . ".xml");
					$this->setHBAInfo($data);
					$this->setHBAConfig($data);
					$this->setSuspendModeInfo($data);
				}
			}
		}
	}
}
?>