<?php
class VDSlot
{
	private $VDID = 0xffff;
	private $size;
	private $slotNo;
	private $VD;	
	
	public function setVDID($VDID)
	{
		$this->VDID = $VDID;
	}
	public function getVDID()
	{
		return $this->VDID;
	}
	
	public function setVD($VD)
	{
		$this->VD = $VD;
	}
	public function getVD()
	{
		return $this->VD;
	}
	
	public function isFree()
	{
		return ($this->VDID == 0xffff) && (!isset($this->VD));
	}
	
	public function setSlotNo($slotNo)
	{
		$this->slotNo = $slotNo;
	}
	public function getSlotNo()
	{
		return $this->slotNo;
	}
	
	public function setSize($size)
	{
		$this->size = $size;
	}
	public function getSize()
	{
		return $this->size;
	}
}
class DG
{
	private $ID = GET_ALL;
	private $Name = 0;
	private $Raid_Level = 0;

	private $SubLDCount = 0;// sub VD count for raid 10, 50, 60
	private $NumParityDisk = 0;//raid6 Redundancy
	private $AdapterID = GET_ALL;
	private $BgaType;
	private $BgaState;
	
	private $StripeBlockSize = 0;
	private $BlockSize = 0;
	private $Size ;//total size
	private $RemainingSize;//remaining size
	private $SmallestAvailablePDSize;
	
	private $Status = 0;
    private $PDBgaRunning = 0;
	private $HDCount = 0;
	private $HDIDs = array();
	private $HDList = array();
	private $LDCount = 0;
	private $LDIDs = array();
	private $LDList = array();
	
	private $WriteCacheOn;
	
	private $SpareHDCount = 0;
	private $SpareHDIDs = array();
	private $SpareHDList = array();
	
	private $VDSlotCount = 0;
	private $VDSlots = array();
	
	public function setID($ID)
	{
		$this->ID = $ID;
	}
	public function getID()
	{
		return $this->ID;
	}
	
	public function setName($Name)
	{
		$this->Name = $Name;
	}
	public function getName()
	{
		return $this->Name;
	}
	
	public function setRaid_Level($Raid_Level)
	{
		$this->Raid_Level = $Raid_Level;
	}
	public function getRaid_Level()
	{
		return $this->Raid_Level;
	}

	public function getBgaType()
	{
		return $this->BgaType;
	}
	
	public function getBgaState()
	{
		return $this->BgaState;
	}
	public function setSubLDCount($SubLDCount)
	{
		$this->SubLDCount = $SubLDCount;
	}
	public function getSubLDCount()
	{
		return $this->SubLDCount;
	}
	
	public function setNumParityDisk($NumParityDisk)
	{
		$this->NumParityDisk = $NumParityDisk;
	}
	public function getNumParityDisk()
	{
		return $this->NumParityDisk;
	}

	public function setAdapterID($AdapterID)
	{
		$this->AdapterID = $AdapterID;
	}
	public function getAdapterID()
	{
		return $this->AdapterID;
	}

	public function setStripeBlockSize($StripeBlockSize)
	{
		$this->StripeBlockSize = $StripeBlockSize;
	}
	public function getStripeBlockSize()
	{
		return $this->StripeBlockSize;
	}
	
	public function setBlockSize($BlockSize)
	{
		$this->BlockSize = $BlockSize;
	}
	public function getBlockSize()
	{
		return $this->BlockSize;
	}
	
	public function setSize($Size)
	{
		$this->Size = $Size;
	}
	public function getSize()
	{
		return $this->Size;
	}
	public function setRemainingSize($RemainingSize)
	{
		$this->RemainingSize = $RemainingSize;
	}
	public function getRemainingSize()
	{
		return $this->RemainingSize;
	}
	
	public function setStatus($Status)
	{
		$this->Status = $Status;
	}
	public function getStatus()
	{
		return $this->Status;
	}

    public function setPDBgaRunning($PDBgaRunning)
    {
        $this->PDBgaRunning = $PDBgaRunning;
    }

    public function getPDBgaRunning()
    {
        return $this->PDBgaRunning;
    }
    
	public function setHDCount($HDCount)
	{
		$this->HDCount = $HDCount;
	}
	public function getHDCount()
	{
		return $this->HDCount;
	}
	
	public function setHDIDs($HDIDs)
	{
		$this->HDIDs = HDIDs;
	}
	
	public function getHDIDs()
	{
		return $this->HDIDs;
	}
			
	public function setLDCount($LDCount)
	{
		$this->LDCount = $LDCount;
	}
	public function getLDCount()
	{
		return $this->LDCount;
	}

	public function setLDIDs($LDIDs)
	{
		$this->LDIDs = $LDIDs;
	}
	public function getLDIDs()
	{
		return $this->LDIDs;
	}
	
	public function setWriteCacheOn($WriteCaceOn)
	{
		$this->WriteCacheOn = $WriteCaceOn;
	}
	
	public function getWriteCacheOn()
	{
		return $this->WriteCacheOn;
	}
	
	public function setSpareHDCount($SpareHDCount)
	{
		$this->SpareHDCount = $SpareHDCount;
	}
	public function getSpareHDCount()
	{
		return $this->SpareHDCount;
	}
	
	public function setSpareHDIDs($SpareHDIDs)
	{
		$this->SpareHDIDs = $SpareHDIDs;
	}
	public function getSpareHDIDs()
	{
		return $this->SpareHDIDs;
	}
	
	public function getHDList()
	{
		return $this->HDList;
	}
	
	public function setHDList($HDList)
	{
		$this->HDList = $HDList;
	}
	
	public function getLDList()
	{
		return $this->LDList;
	}
	
	public function setLDList($LDList)
	{
		$this->LDList = $LDList;
		foreach ($this->LDList as $vd)
		{
			foreach ($this->VDSlots as $slot)
			{
				if ($vd->getID() == $slot->getVDID()) {
					$slot->setVD($vd);				
				}
			}
		}
	}
	
	public function setSpareHDList($SpareHDList)
	{
		$this->SpareHDList = $SpareHDList;
	}
	public function getSpareHDList()
	{
		return $this->SpareHDList;
	}
	
	public function getSmallestAvailablePDSize()
	{
		return $this->SmallestAvailablePDSize;
	}
	
	public function setSmallestAvailablePDSize($SmallestAvailablePDSize)
	{
		$this->SmallestAvailablePDSize = $SmallestAvailablePDSize;
	}
	
	public function setVDSlotCount($VDSlotCount)
	{
		$this->VDSlotCount = $VDSlotCount;
	}
	public function getVDSlotCount()
	{
		return $this->VDSlotCount;
	}
	
	public function setVDSlots($VDSlots)
	{
		$this->VDSlots = $VDSlots;
	}
	public function getVDSlots()
	{
		return $this->VDSlots;
	}
	
	public function setDgInfo($Info)
	{
		if (isset($Info->DGID)) {
 			$this->ID = trim($Info->DGID);
 		}
 		if (isset($Info->Name)) {
 			$this->Name = trim($Info->Name);
 		}
 		if (isset($Info->RaidMode)) {
 			$this->Raid_Level = trim($Info->RaidMode);
 		}
 		if (isset($Info->AdapterID)) {
 			$this->AdapterID = trim($Info->AdapterID);
 		}
 		if (isset($Info->StripeBlockSize)) {
 			$this->StripeBlockSize = trim($Info->StripeBlockSize);
 		}
 		if (isset($Info->BlockSize)) {
 			$this->BlockSize = trim($Info->BlockSize);
 		}
 			
 		if (isset($Info->RaidMode)) {
 			if($Info->RaidMode == RAIDMode::LD_MODE_RAID6){
 				$this->NumParityDisk = trim($Info->NumParityDisk);//raid6 Redundancy
 			}
 			elseif ($Info->RaidMode == RAIDMode::LD_MODE_RAID50){
 				$this->SubLDCount  = trim($Info->SubVDCount );//sub VD count
 			}
 			elseif ($Info->RaidMode == RAIDMode::LD_MODE_RAID60){
 				$this->SubLDCount  = trim($Info->SubVDCount );//sub VD count
 				$this->NumParityDisk = trim($Info->NumParityDisk);// of parity disks
 			}
 		}
 		
 		if (isset($Info->TotalManagedSpace)){
 			$this->Size = trim($Info->TotalManagedSpace);
 		}
 		
 		if (isset($Info->RemainingManagedSpace)) {
 			$this->RemainingSize = floatval(trim($Info->RemainingManagedSpace));
 		}
 		
 		if (isset($Info->SmallestAvailablePDSize)) {
 			$this->SmallestAvailablePDSize = floatval(trim($Info->SmallestAvailablePDSize));
 		}
 		
 		if (isset($Info->Status)) {
 			$this->Status = trim($Info->Status);
 		}

 		if (isset($Info->PDBgaRunning)) {
 			$this->PDBgaRunning = trim($Info->PDBgaRunning);
 		}
 		
 		if (isset($Info->PDCount)) {
 			$this->HDCount = trim($Info->PDCount);
 		}
 		
 		if (isset($Info->VDIDs)) {
 			$this->LDIDs = array();
 			$lds = explode(" ", trim($Info->VDIDs));
 			
 			foreach ($lds as $id)
 			{
 				if(trim($id) !== "")
 				{
 					$this->LDIDs[] = $id;
 					if (trim($id) != 65535) {
 						$this->LDCount++;
 					}
 				}
 			}
 		}
 		
 		if (isset($Info->PDIDs)) {
 			$this->HDIDs = array();
 			$hds = explode(" ", trim($Info->PDIDs));		
 			$i = 0;
 			foreach ($hds as $id)
 			{
 				if($id != 65535 && trim($id) != "" && $i < $this->HDCount)
 				{
 					$this->HDIDs[] = $id;
 					$i++;
 				}
 			}
 		}
 		 		
		if (isset($Info->SparePDCount )) {
 			$this->SpareHDCount = trim($Info->SparePDCount);
 		}
 		
 		if (isset($Info->SparePDIDs)) {
 			$this->SpareHDIDs = array();
 			$hds = explode(" ", trim($Info->SparePDIDs));		
 			$i = 0;
 			foreach ($hds as $id)
 			{
 				if($id != 65535 && trim($id) !== "" && $i < $this->SpareHDCount)
 				{
 					$this->SpareHDIDs[] = $id;
 					$i++;
 				}
 			}
 		}
 
		if (isset($Info->BgaType)) {
 			$this->BgaType = trim($Info->BgaType);
 		}
 		if (isset($Info->BgaState)) {
 			$this->BgaState = trim($Info->BgaState);
 		}
 		
 		if (isset($Info->VDSlotCount)) {
 			$this->VDSlotCount = intval(trim($Info->VDSlotCount));
 			for ($i = 0; $i < $this->VDSlotCount; $i++)
 			{
 				$slot = new VDSlot();
 				if ($i < sizeof($this->LDIDs)) {
 					$slot->setVDID($this->LDIDs[$i]);
 				} 				
 				$slot->setSlotNo($i);
 				$this->VDSlots[] = $slot;
 			}
 		}
 		
 		if (isset($Info->VDSlotSize)) {
 			$sizes = explode(" ", trim($Info->VDSlotSize));
 			$sizeNum = sizeof($sizes);
 			for ($i = 0; $i < $this->VDSlotCount; $i++)
 			{
 				if ($i < $sizeNum) {
 					$this->VDSlots[$i]->setSize(trim($sizes[$i]));
 				}
 			}
 		}
	}
	
	public function setDgConfig($Config)
	{
		if (isset($Config->DGID)) {
 			$this->ID = trim($Config->DGID);
 		}
		if (isset($Config->WriteCacheOn)) {
			$this->WriteCacheOn = trim($Config->WriteCacheOn);
		}
	}
	
}

?>