<?php

abstract class Container{
	protected $base;
	protected $smarty;
	protected $infos;
	private $AdapterID;
	
	private $filter;
	
	public function setAdapterID($hbaId)
	{
		$this->AdapterID = $hbaId;
	}
	
	public function getAdapterID()
	{
		return $this->AdapterID;
	}
	
	public function setFilter($filter)
	{
		$this->filter = $filter;
	}
	
	protected function filter($objArr)
	{
		if (isset($this->filter)) {
			return $this->filter->filter($objArr);
		}
		else 
			return $objArr;
	}
	
	public function getInfos()
	{
		return $this->infos;
	}
	
	public function setInfo($infos)
	{
		$this->infos = $infos;
	}
	
	public function initContainer()
	{
		$this->setBase();
		
		if ($this->base instanceof BaseData) {
			$this->base->initData();
		}
		
		$this->setDataToPage();
	}
	
	public function smartyAssign($smarty)
	{
		$this->smarty = $smarty;
	}
	
	public function display($TPLFile)
	{
		if (getSessionPara(USERID)) {
			$this->smarty->display($TPLFile);
		}
	}
	
	public function getBase()
	{
		return $this->base;
	}
	
	protected abstract function setBase();
	protected abstract function setDataToPage();
	
	protected abstract function displayXML();
}
?>