<?php
class UserDataAccess extends XMLDataAccess 
{
	public function __construct($fileName=null)
	{
		$this->eleName = "User";
		$this->parentName = 'Users';
		if ($fileName) {
			$this->fileName = $fileName;	
		}
		else {
                        $this->fileName = realpath("../db/db.xml");
		}
		
		parent::__construct($this->fileName);
	}
	
	public function __destruct()
	{
		parent::__destruct();
	}
	
	public function getUserByName($name, $domain)
	{
		$data = array('mykeys' => array("loginName"=>$name, "domain" => $domain));
		return $this->query($data);
	}
	
	public function getUserByType($type)
	{
		$data = array('mykeys' => array("userType"=>$type));
		return $this->query($data);
	}
	
	public function getUserByID($ID)
	{
		$data = array('mykeys' => array('sessionID' => $ID));
		
		return $this->query($data);
	}
	
	//won't used any more
	public function getLoginUser($name,$passwd)
	{
		$data = array('mykeys' => array('loginName' => $name, 'passwd' => $passwd));
		
		return $this->query($data);
	}
	
	public function getAllUser()
	{
		$data = array('mykeys' => array());
		return $this->query($data);
	}
	
	public function getUsersByEventNotifyLevel($eventNotify)
	{
		$data = array('mykeys' => array("eventNotify"=>$eventNotify));
		return $this->query($data);
	}
	
	public function addUser($user)
	{
		$myvalues = array();
		
		$myvalues['loginName'] = $user->getLoginName();
		$myvalues['domain'] = $user->getDomain();
		$myvalues['emailAddr'] = $user->getEmailAddr();
		$myvalues['userType'] = $user->isAdmin() ? 1 : 0;
		$myvalues['eventNotify'] = $user->getEventNotify();
		//generate User ID
		while (true) {
			$ID = rand(0x111111,0x999999);
			$users = $this->getUserByID($ID);
			if (sizeof($users)) {
				continue;
			}
			else 
			{
				$myvalues['sessionID'] = $ID;
				break;
			}
		}
		
		$data = array('myvalues'=>$myvalues);
		
		if ($this->insert($data)) {
			return $ID;
		}
		else
		{
			return false;
		}
	}
	
	public function updateUserByLoginName($name, $domain, $user)
	{
		$mykeys = array('loginName' => $name, "domain" => $domain);
		
		$myvalues = array();
		
		$myvalues['emailAddr'] = $user->getEmailAddr();
		$myvalues['userType'] = $user->getUserType();
		$myvalues['eventNotify'] = $user->getEventNotify();
		
		$data = array('mykeys' => $mykeys, 'myvalues'=>$myvalues);
		
		return $this->update($data);
	}
	
	public function updateUserByID($ID, $user)
	{
		$mykeys = array('sessionID' => $ID);
		
		$myvalues = array();
		
		$myvalues['loginName'] = $user->getLoginName();
		$myvalues['domain'] = $user->getDomain();
		$myvalues['emailAddr'] = $user->getEmailAddr();
		$myvalues['userType'] = $user->getUserType();
		$myvalues['eventNotify'] = $user->getEventNotify();
		
		$data = array('mykeys' => $mykeys, 'myvalues'=>$myvalues);
		
		return $this->update($data);
	}
	
	public function deleteUserByID($ID)
	{
		$data = array('mykeys' => array('sessionID' => $ID));
		
		return $this->delete($data);
	}
	
	public function deleteUserByLoginName($name, $domain)
	{
		$data = array('mykeys' => array('loginName' => $name, "domain" => $domain));
		
		return $this->delete($data);
	}
	
	protected function dataWrapper($element)
	{
		return User::createUserFromXMLElement($element);
	}
}
?>
