<?php
class SystemSetting
{
	private $EventReadIndex;
	private $userName;
	private $passwd;
	private $port;
	private $serverAddr;
	private $isSSL;
	
	public function getUserName()
	{
		return $this->userName;
	}
	public function setUserName($userName)
	{
		$this->userName = $userName;
	}
	
	public function setPasswd($passwd)
	{
		$this->passwd = $passwd;
	}
	
	public function getPasswd()
    {
        //decode password
        $XMLApiCmd = new XMLAPICommand();
        $XMLApiCmd->setCommand(XMLAPICommand::MV_StringDecode);
        $XMLApiCmd->setCommandPara("sztarget", $this->passwd);

        $retVal = -1;
        if ($XMLApiCmd->issueCommand()) {
            $XMLRoot = $XMLApiCmd->getResult();
            $retVal = $XMLRoot->RetVal;
        }

        if (intval($retVal) == 0) {
            $this->passwd = $XMLRoot->szsource;
        }
        //decode password

        return $this->passwd;
	}
	
	public function getPort()
	{
		return $this->port;
	}
	public function setPort($port)
	{
		$this->port = $port;
	}
	
	public function setServerAddr($serverAddr)
	{
		$this->serverAddr = $serverAddr;
	}
	public function getServerAddr()
	{
		return $this->serverAddr;
	}
	
	public function getEventReadIndex()
	{
		return $this->EventReadIndex;
	}
	public function setEventReadIndex($EventReadIndex)
	{
		$this->EventReadIndex = $EventReadIndex;
	}
	
	public function isSSL()
	{
		return $this->isSSL;
	}
	public function setSSL($isSSL)
	{
		$this->isSSL = $isSSL;
	}
	
	public function setInfoFromXML($element)
	{
		$this->EventReadIndex = trim($element->EventReadIndex);
		$this->userName = trim($element->userName);
		$this->passwd = trim($element->passwd);
		$this->port = trim($element->port);
		$this->serverAddr = trim($element->serverAddr);
		$this->isSSL = trim($element->isSSL);
	}
	
	public static function createFromXMLElement($element)
	{
		$system = new SystemSetting();
		$system->setInfoFromXML($element);
		
		return $system;
	}
}
?>