<?php
//the class for getting Migrated target LD size
class GetMigratedPackageVDSize
{
	private $TplFile;
	private $smarty;

	private $HDs;
	private $RaidMode;
	private $LDID;
	private $HBAID = 0;
	private $NumOfParityDisk = 0; //default value

	private function initPara()
	{
		$this->LDID = getRequestPara("LDID");
		$this->HBAID = getRequestPara("HBAID");
		$this->HDs = getRequestPara("HDs");
		$this->RaidMode = getRequestPara("RaidMode");
		if ($this->RaidMode == RAIDMode::LD_MODE_RAID6
			|| $this->RaidMode == RAIDMode::LD_MODE_RAID60) {
			$this->NumOfParityDisk = getRequestPara("NumOfParityDisk");
		}
	}

	private function setMigrateDgSize()
	{
		$Cmd = new XMLAPICommand();
		$Cmd->setCommand(XMLAPICommand::MV_Package_VD_Get_Size );
		$Cmd->setCommandPara("AdapterID",$this->HBAID);
		$Cmd->setCommandPara("RaidMode",$this->RaidMode);
		$Cmd->setCommandPara("NumParityDisk",$this->NumOfParityDisk);
		$Cmd->setCommandPara("HDIDs",$this->HDs);
		$Cmd->setCommandPara("LDID",$this->LDID);
//		$Cmd->setCommandPara("Name","");
//		$Cmd->setCommandPara("SubVDCount",0);
//		$Cmd->setCommandPara("StripeBlockSize",LDStripeSize::StripeSize64K);
//		$Cmd->setCommandPara("Size",0);
//		$Cmd->setCommandPara("BlockSize",512);
//		$Cmd->setCommandPara("InitializationOption",0);

		//HDCount
		$HDCount = 0;
		$hds = explode(" ",$this->HDs);
		foreach ($hds as $Hd)
		{
			if (trim($Hd) != "") {
				$HDCount ++;
			}
		}
		$Cmd->setCommandPara("HDCount",$HDCount);

		if ($Cmd->issueCommand()) {
			$size = $Cmd->getResult()->Migrate_Package_VD_Param->Size;
			$this->smarty->assign("MigratedSizeGB",FormatSize($size));
			$this->smarty->assign("MigratedSize",ConvertSize($size));
		}
	}

	private function setTestData()
	{
		$size = 123333333;
		$this->smarty->assign("MigratedSizeGB",FormatSize($size));
		$this->smarty->assign("MigratedSize",ConvertSize($size));
	}

	public function displayResultXML()
	{
		$this->TplFile = "XML_MigratedLDSize.tpl";
		if (BaseData::DebugTest) {
			$this->setTestData();
			$this->smarty->display($this->TplFile);
			return;
		}
		$this->initPara();
		$this->setMigrateDgSize();
		$this->smarty->display($this->TplFile);
	}

	public function smartyAssign($smarty)
	{
		$this->smarty = $smarty;
	}
}
?>
