<?php
class ActionMigrateDG extends UserAction 
{
	private $DG_ID;
		
	private $RaidMode = 0;
//	private $HDCount = 0;
	private $HDs = 0;
	private $NumParityDisk = 0;
    const ToStopMP = "ToStopMP";
    protected $isRunningMP = 0;
	
	private $original_HDs = array();
	
	protected function validatePara()
	{
		//check the http request parameters
	}
	protected function initActionPara()
	{
		$this->DG_ID = getRequestPara("DGID");
		$this->HDs = getRequestPara("HDs");
		$this->RaidMode = getRequestPara("RaidMode");
		if ($this->RaidMode == RAIDMode::LD_MODE_RAID6 
			|| $this->RaidMode == RAIDMode::LD_MODE_RAID60) {
			$this->NumParityDisk = getRequestPara("NumOfParityDisk");
		}
	}
	
	private function setOriginalHDs()
	{
		include_once("../phpsrc/baseclass/Device.class.php");
		include_once("../phpsrc/baseclass/SASDevice.class.php");
		include_once("../phpsrc/baseclass/DeviceFactory.class.php");
		include_once("../phpsrc/baseclass/PortDevice.class.php");
		include_once("../phpsrc/baseclass/Block.class.php");
		include_once("../phpsrc/baseclass/HD.class.php");
		include_once("../phpsrc/baseclass/PM.class.php");
		include_once("../phpsrc/baseclass/HBA.class.php");
		include_once("../phpsrc/baseclass/ExpanderDevice.class.php");
		include_once("../phpsrc/baseclass/DG.class.php");
		include_once("../phpsrc/baseclass/DgDetail.class.php");
		
		$dgDtl = new DgDetail();
		$dgDtl->setAdapterID($this->getAdapterID());
		$dgDtl->setDGID($this->DG_ID);
		$dgDtl->toGetDgInfo();
		
		$base = $dgDtl->getBaseClasses();
		
		if (sizeof($base)) {
				$dgDetail = array_shift($base);
				foreach ($dgDetail->getHDIDs() as $hd)
				{
					if ($this->original_HDs !== "") {
						$this->original_HDs[] = $hd;
					}
					else 
					{
						$this->original_HDs[] = $hd;
					}
				}
		}
	}
	
	/*
	check whether one of pd(s) is member disk of original vd
	*/
	private function doCheckMemberDisk()
	{
		$this->setOriginalHDs();
		
		#set id of pd disks in target vd
		#set to array
		$Target_HDIDs = array();
		$Target_HDs = explode(" ",$this->HDs);
		foreach ($Target_HDs as $HDID)
		{
			if (trim($HDID) != "") {
				$Target_HDIDs[] = $HDID;
			}
		}
		
		foreach ($this->original_HDs as $Original_HDID)
		{
			foreach ($Target_HDIDs as $Target_HDID)
			{
				if (intval($Target_HDID) == $Original_HDID) {
					return true;
				}
			}
		}
		
		return false;
	}
	
	private function setCheckMigrateFailXMLRet()
	{
		$this->xmlRet = new FailXMLRet();
		$this->xmlRet->Url = getBaseURL() . "JumpPage.php?Target=" . Target::DgDetailPage . "&ID=" . $this->DG_ID . "&HBAID=" . $this->getAdapterID();
		$Err = AlertMsg::MIGRATE_DG_LIMIT_ERR;
		$this->xmlRet->Msg = $Err;
	}
	
	public function doCheckSpare()
	{
		include_once("../phpsrc/baseclass/Device.class.php");
		include_once("../phpsrc/baseclass/SASDevice.class.php");
		include_once("../phpsrc/baseclass/DeviceFactory.class.php");
		include_once("../phpsrc/baseclass/PortDevice.class.php");
		include_once("../phpsrc/baseclass/Block.class.php");
		include_once("../phpsrc/baseclass/HD.class.php");
		include_once("../phpsrc/baseclass/PM.class.php");
		include_once("../phpsrc/baseclass/ExpanderDevice.class.php");

		include_once("../phpsrc/baseclass/HdList.class.php");
		
		$HdList = new HdList();
		$HdList->setAdapterID($this->getAdapterID());
		$HdList->toGetHDRaidStatus();
		
		$HDs = $HdList->getBaseClasses();
		
		#set id of pd disks in target vd
		#set to array
		$Target_HDIDs = array();
		$Target_HDs = explode(" ",$this->HDs);
		foreach ($Target_HDs as $HDID)
		{
			if (trim($HDID) != "") {
				$HDIDs[] = $HDID;
			}
		}
		
		#set id of pd disks in original vd
		#set to array
		foreach ($this->original_HDs as $HDID)
		{
			if (trim($HDID) != "") {
				$Original_HDIDs[] = $HDID;
			}
		}
		
		#remove member disk from array
		$noneMemberDisks = array();
		foreach ($Target_HDs as $Target_HDID)
		{
			$isMember = false;
			foreach ($Original_HDIDs as $Original_HDID)
			{
				if (intval($Target_HDID) == $Original_HDID) {
					$isMember = true;
					break;
				}
			}
			if (!$isMember) {
				$noneMemberDisks[] = $Target_HDID;
			}
		}
				
		foreach ($HDs as $HD)
		{
			if ($HD->isSpare()) {
				$HDID = trim($HD->getDeviceID());
				foreach ($noneMemberDisks as $id)
				{
					if ($HDID == $id) {
						return false;
					}
				}
			}
		}
		
		return true;
	}
	
	private function setHDSpareCheckFailXMLRet()
	{
		$this->xmlRet = new FailXMLRet();
		$this->xmlRet->Url = getBaseURL() . "JumpPage.php?Target=" . Target::LdListPage ;
		$Err = ComError::ERR_HD_IS_SPARE_STR;
		$this->xmlRet->Msg = $Err;
	}
	
	private function doMigrate()
	{
		$this->ApiCmd = new XMLAPICommand();
		$this->ApiCmd->setCommand(XMLAPICommand::MV_DG_StartMigration);
		$this->ApiCmd->setCommandPara("AdapterID",$this->getAdapterID());
		$this->ApiCmd->setCommandPara("DGID",$this->DG_ID);
		$this->ApiCmd->setCommandPara("RaidMode",$this->RaidMode);
		$this->ApiCmd->setCommandPara("NumParityDisk",$this->NumParityDisk);
		//HDCount
		$HDCount = 0;
		$hds = explode(" ",$this->HDs);
		foreach ($hds as $Hd)
		{
			if (trim($Hd) != "") {
				$HDCount ++;
			}
		}
		$this->ApiCmd->setCommandPara("PDCount",$HDCount);
		$this->ApiCmd->setCommandPara("PDIDs",$this->HDs);
		$this->ApiCmd->issueCommand();
		
		if (trim($this->ApiCmd->getResult()->RetVal)) {
			$this->setDGCmdXmlRetFail();
		}
		else {
			$this->setDGCmdXmlRetSuccess();
		}
	}

	private function setFlags()
	{
		include_once("../phpsrc/baseclass/Device.class.php");
		include_once("../phpsrc/baseclass/SASDevice.class.php");
		include_once("../phpsrc/baseclass/DeviceFactory.class.php");
		include_once("../phpsrc/baseclass/PortDevice.class.php");
		include_once("../phpsrc/baseclass/Block.class.php");
		include_once("../phpsrc/baseclass/HD.class.php");
		include_once("../phpsrc/baseclass/PM.class.php");
		include_once("../phpsrc/baseclass/HBA.class.php");
		include_once("../phpsrc/baseclass/ExpanderDevice.class.php");
		include_once("../phpsrc/baseclass/DG.class.php");
		include_once("../phpsrc/baseclass/DgDetail.class.php");
		$dgDtl = new DgDetail();
		$dgDtl->setAdapterID($this->getAdapterID());
		$dgDtl->setDGID($this->DG_ID);
		$dgDtl->toGetDgInfo();

		$base = $dgDtl->getBaseClasses();
		if (sizeof($base)) {
		    $dgDetail = array_shift($base);
            if ($dgDetail->getPDBgaRunning()) {
                $this->isRunningMP = 1;
            }
        }
    }

	protected function doAction()
	{
        $cmdName = trim(getRequestPara("cmdName"));
		$this->setFlags();
        if ((getRequestPara(self::ToStopMP) == null) && $this->isRunningMP) {
			$YesUrl = getBaseURL() . PHPPageName::CmdPageName
				. "?cmdName=" . $cmdName ;
			$YesUrl .=  "&DGID" . "=" . $this->DG_ID . "&HDs=" . $this->HDs
                        . "&RaidMode=" . $this->RaidMode . "&NumOfParityDisk=" . $this->NumParityDisk
                        ."&HBAID=" . $this->getAdapterID();
			$YesUrl .=  "&" . self::ToStopMP  . "= 1";

			$NoUrl = getBaseURL()
					. PHPPageName::TargetPageName ."?Target=" . Target::getArraySubPage
                    . "&ID=" . $this->DG_ID . "&HBAID=" . $this->getAdapterID();

			$this->xmlRet = new ContXMLRet();
			$this->xmlRet->Msg =
				AlertMsg::DGMIGRATE_STOP_MP;
			$this->xmlRet->YesUrl = $YesUrl;
			$this->xmlRet->NoUrl = $NoUrl;
			$this->xmlRet->YesUrlType = XMLRetUrlType::CmdUrl;
			$this->xmlRet->NoUrlType = XMLRetUrlType::PageUrl;
            return;
        }

		if (!$this->doCheckMemberDisk()) {
			$this->setCheckMigrateFailXMLRet();
			return ;
		}
		
		#check whether non-member disks are spared
		#if spare can not do migration
		if (!$this->doCheckSpare()) {
			$this->setHDSpareCheckFailXMLRet();
			return;
		}
		
		$this->doMigrate();
	}
}
?>