<?php
class ActionCreateLD extends UserAction 
{
	private $RaidMode = 0;
	private $subRaidMode = 0xff;
	private $StripeSize = 0;
	private $InitType = 0;
	private $HDs = 0;
	private $LDName = 0;
	private $LDSize = 0;
	private $ReadCache;
	private $WriteCache;
	private $GBRounding = 0;
	private $NumParityDisk = 0;
	private $UseThorSizePolicy = 0;
	private $HBAID = 0;
	private $VDID = GET_ALL;
	private $Watermark = 0xff; //for hyper hdd
	
	protected function validatePara()
	{
		//check the http request parameters
	}
	protected function initActionPara()
	{
		$this->HBAID = $this->getAdapterID();
		$this->RaidMode = getRequestPara("RaidMode");
		$this->subRaidMode = getRequestPara("subRaidMode");
		
		if ($this->RaidMode == RAIDMode::LD_MODE_HyperHDD) //hyper hdd mode
			$this->RaidMode = $this->subRaidMode;
		
		$this->Watermark = getRequestPara("Watermark");
		$this->LDName = getRequestPara("LDName");
		$this->InitType = getRequestPara("InitType");
		$this->LDSize = getRequestPara("LDSize");
		$this->HDs = trim(getRequestPara("HDs"));
		$this->ReadCache = getRequestPara("ReadCache");
		$this->WriteCache = getRequestPara("WriteCache");
		$this->GBRounding = getRequestPara("GBRounding");
		$this->StripeSize = getRequestPara("StripeSize");
		if ($this->RaidMode == RAIDMode::LD_MODE_RAID6 || $this->RaidMode == RAIDMode::LD_MODE_RAID60) {
			$this->NumParityDisk = getRequestPara("NumOfParityDisk");
		}
		
		$sysFeature = AdapterFeature::getInstance($this->HBAID);
		$this->UseThorSizePolicy = $sysFeature->isThor;
		
	}
	
	
	private function doCreateLD()
	{
		include_once("../phpsrc/baseclass/LD.class.php");
		include_once("../phpsrc/baseclass/LdList.class.php");
		$oldVDs = new LdList();
		$oldVDs->setAdapterID($this->HBAID);
		$oldVDs->toGetLDInfo();
		
		$oldVDIDs = array();
		foreach ($oldVDs->getBaseClasses() as $vd)
		{
			$oldVDIDs[] = $vd->getID();
		}
		
		$this->ApiCmd = new XMLAPICommand();
		$this->ApiCmd->setCommand(XMLAPICommand::MV_LD_Create);
		$this->ApiCmd->setCommandPara("AdapterID",$this->HBAID);
		$this->ApiCmd->setCommandPara("RaidMode",$this->RaidMode);
		$this->ApiCmd->setCommandPara("RoundingScheme",$this->GBRounding);
		$this->ApiCmd->setCommandPara("SubLDCount",0);
		$this->ApiCmd->setCommandPara("StripeBlockSize",$this->StripeSize);
		$this->ApiCmd->setCommandPara("Raid6Redundancy",0);
		$this->ApiCmd->setCommandPara("InitializationOption",$this->InitType);
		$this->ApiCmd->setCommandPara("SectorCoefficient",LDSectorSize::SectorSize512B);
		$this->ApiCmd->setCommandPara("Name",$this->LDName);
		$this->ApiCmd->setCommandPara("HypperWaterMark",$this->Watermark);
		if ($this->LDSize<= 1)
		{
			$this->ApiCmd->setCommandPara("Size",$this->LDSize * UNIT_K);
		}
		else
		{
			if ($this->UseThorSizePolicy) {
				$this->ApiCmd->setCommandPara("Size",$this->LDSize * UNIT_K);
			}
			else 
			{
				$this->ApiCmd->setCommandPara("Size",$this->LDSize * UNIT_KILO);
			}
		}
		$this->ApiCmd->setCommandPara("NumParityDisk",$this->NumParityDisk);
		
		//cache
		$CachePolicy = intval($this->ReadCache) | intval($this->WriteCache);
		$this->ApiCmd->setCommandPara("CachePolicy",$CachePolicy);
		
		//HDCount
		$HDCount = 0;
		$hds = explode(" ",$this->HDs);
		foreach ($hds as $Hd)
		{
			if (trim($Hd) != "") {
				$HDCount ++;
			}
		}
		$this->ApiCmd->setCommandPara("HDCount",$HDCount);
		$this->ApiCmd->setCommandPara("HDIDs",$this->HDs);
		
		$this->ApiCmd->issueCommand();
		
		if ($this->ApiCmd->getResult()->RetVal . "") {
			$this->setLDCreateFail();
		}
		else {
			$newVDs = new LdList();
			$newVDs->setAdapterID($this->getAdapterID());
			$newVDs->toGetLDInfo();
			
			$newVDIDs = array();
			foreach ($newVDs->getBaseClasses() as $vd)
			{
				$newVDIDs[] = $vd->getID();
			}
			$arr = array_diff($newVDIDs, $oldVDIDs);
			if ($arr) {
				$this->VDID = array_shift($arr);
			}
			$this->setLDCreateCmdXmlRetSuccess();
		}
	}
	
	private function setLDCreateCmdXmlRetSuccess()
	{
		$this->xmlRet = new SuccessXMLRet();
		$this->xmlRet->Msg = "";
		//$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName ."?Target=" . Target::LdListPage ;
		$this->xmlRet->Url = getBaseURL() . PHPPageName::TargetPageName
			."?Target=" . Target::getIndependentVDPage . "&ID=" . $this->VDID . "&HBAID=" . $this->HBAID;
	}
	
	private function setLDCreateFail()
	{
		$this->xmlRet = new FailXMLRet();
		$XMLRoot = $this->ApiCmd->getResult();
		if ($XMLRoot->RetVal . "") {
			$this->xmlRet->Url = getBaseURL() . "JumpPage.php?Target=" . Target::getHBADetail . "&ID=" . $this->HBAID ;
			$Err = ComError::getErrStr(intval($XMLRoot->RetVal));
			$this->xmlRet->Msg = $Err;
		}
	}
	
/*	private function setLDCreateCheckFailXMLRet() //??
	{
		$this->xmlRet = new FailXMLRet();
		$this->xmlRet->Url = getBaseURL() . "JumpPage.php?Target=" . Target::LdListPage ;
		$Err = ComError::ERR_NO_RESOURCE_STR;
		$this->xmlRet->Msg = $Err;
	}*/
	
	private function setHDSpareCheckFailXMLRet()
	{
		$this->xmlRet = new FailXMLRet();
		$this->xmlRet->Url = getBaseURL() . "JumpPage.php?Target=" . Target::getHBADetail . "&ID=" . $this->HBAID;
		$Err = ComError::ERR_HD_IS_SPARE_STR;
		$this->xmlRet->Msg = $Err;
	}
	
	private function setRaid0HDCountCheckFailXMLRet()
	{
		$this->xmlRet = new FailXMLRet();
		$this->xmlRet->Url = getBaseURL() . "JumpPage.php?Target=" . Target::getHBADetail . "&ID=" . $this->HBAID ;
		$Err = ComError::ERR_INVALID_HD_COUNT_STR;
		$this->xmlRet->Msg = $Err;
	}
	
	//check raid 0 can not creat with only one disk
	//return false if not at least 2 disks are used for creating RAID0 VD;
	private function checkRaid0HDCount()
	{
		if ($this->RaidMode == RAIDMode::LD_MODE_RAID0 ) {
			$HDs = explode(' ',$this->HDs);
			if (sizeof($HDs) == 1) {
				return false;
			}
		}
		
		return true;
	}
	
	//
	//
	private function doSetCreateMaxSize()
	{
		$GetMaxCmd = new XMLAPICommand();
		$GetMaxCmd->setCommand(XMLAPICommand::MV_LD_GetMaxSize);
		$GetMaxCmd->setCommandPara("AdapterID",$this->HBAID);
		$GetMaxCmd->setCommandPara("RaidMode",$this->RaidMode);
		$GetMaxCmd->setCommandPara("RoundingScheme",0);
		$GetMaxCmd->setCommandPara("SubLDCount",0);
		$GetMaxCmd->setCommandPara("StripeBlockSize",64); 
		$GetMaxCmd->setCommandPara("Raid6Redundancy",0);
		$GetMaxCmd->setCommandPara("CachePolicy",0);
		$GetMaxCmd->setCommandPara("InitializationOption",0);
		$GetMaxCmd->setCommandPara("SectorCoefficient",LDSectorSize::SectorSize512B);
		$GetMaxCmd->setCommandPara("Name",$this->LDName);
		$GetMaxCmd->setCommandPara("Size",$this->LDSize * UNIT_KILO);
		$GetMaxCmd->setCommandPara("NumParityDisk",$this->NumParityDisk);
		
		$HDCount = 0;
		$hds = explode(" ",$this->HDs);
		foreach ($hds as $Hd)
		{
			if (trim($Hd) != "") {
				$HDCount ++;
			}
		}
		$GetMaxCmd->setCommandPara("HDCount",$HDCount);
		$GetMaxCmd->setCommandPara("HDIDs",$this->HDs);
		
		if ($GetMaxCmd->issueCommand()) {
			$XMLRet = $GetMaxCmd->getResult();
			if (ConvertSize($XMLRet->CreateLDParam->Size,$this->UseThorSizePolicy) == $this->LDSize) {
				$this->LDSize = 0;
			}
		}
	}
	
	public function doCheckSpare()
	{
		include_once("../phpsrc/baseclass/Device.class.php");
		include_once("../phpsrc/baseclass/SASDevice.class.php");
		include_once("../phpsrc/baseclass/DeviceFactory.class.php");
		include_once("../phpsrc/baseclass/PortDevice.class.php");
		include_once("../phpsrc/baseclass/Block.class.php");
		include_once("../phpsrc/baseclass/HD.class.php");
		include_once("../phpsrc/baseclass/PM.class.php");
		include_once("../phpsrc/baseclass/ExpanderDevice.class.php");

		include_once("../phpsrc/baseclass/HdList.class.php");
		
		$HdList = new HdList();
		$HdList->setAdapterID($this->HBAID);
		$HdList->toGetHDRaidStatus();
		
		$HDs = $HdList->getBaseClasses();
		$hds = explode(" ",$this->HDs);
		foreach ($hds as $Hd)
		{
			if (trim($Hd) != "") {
				unset($Hd);
			}
		}
		foreach ($HDs as $HD)
		{
			if ($HD->isSpare()) {
				$HDID = trim($HD->getDeviceID());
				foreach ($hds as $id)
				{
					if ($HDID == $id) {
						return false;
					}
				}
			}
		}
		
		return true;
	}
	
	protected function doAction()
	{
		/*if (! $this->checkRaid0HDCount()) {
			//check raid 0 can not creat with only one disk
			$this->setRaid0HDCountCheckFailXMLRet();
			return ;
		}*/
		
		if (! $this->doCheckSpare()) {
			// the create want to create is larger than max create size 
			// report resource unvaliable error.
			$this->setHDSpareCheckFailXMLRet();
			return;
		}
		$this->doSetCreateMaxSize();
		$this->doCreateLD();
	}
}
?>