/*
 * Decompiled with CFR 0.152.
 */
package manager.app;

import manager.configure.Platform;
import manager.utils.ManagerConfigs;
import manager.utils.ManagerUtils;

public class AppData {
    private String name;
    private int oemVersion;
    private String fdkVersion;
    private String desc;
    private Platform platform;
    private Boolean selected;
    private static final String SEPARATOR = ".";

    public AppData(String name) {
        this.name = name;
        try {
            this.fdkVersion = ManagerUtils.getDefaultBuildFdkVersion();
        }
        catch (Exception e) {
            this.fdkVersion = "0";
        }
        this.oemVersion = 1;
        this.selected = false;
        this.desc = "";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getOemVersion() {
        return this.oemVersion;
    }

    public void setOemVersion(int oemVersion) {
        this.oemVersion = oemVersion;
    }

    public String getFdkVersion() {
        return this.fdkVersion;
    }

    public void setFdkVersion(String fdkVersion) {
        this.fdkVersion = fdkVersion;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(Platform platform) {
        this.platform = platform;
    }

    public Boolean getSelected() {
        return this.selected;
    }

    public void setSelected(Boolean selected) {
        this.selected = selected;
    }

    public boolean equals(Object arg0) {
        if (arg0 == null || !(arg0 instanceof AppData)) {
            return false;
        }
        AppData other = (AppData)arg0;
        return this.name.equals(other.name) && this.getVersion().equals(other.getVersion());
    }

    public String getVersion() {
        String ver = "";
        if (this.platform != null) {
            ver = String.valueOf(ver) + Double.toString(this.platform.getValue());
        }
        ver = String.valueOf(ver) + SEPARATOR + this.fdkVersion;
        ver = String.valueOf(ver) + SEPARATOR + this.oemVersion;
        return ver;
    }

    public void parseVersion(String version) throws Exception {
        String err;
        block5: {
            err = "Invalid version. ";
            String[] vers = version.split("\\.");
            if (vers.length == 4) {
                try {
                    String fdk;
                    String max = vers[0];
                    String min = vers[1];
                    try {
                        fdk = ManagerUtils.getDefaultBuildFdkVersion();
                    }
                    catch (Exception e) {
                        fdk = vers[2];
                    }
                    int oem = Integer.parseInt(vers[3]);
                    Platform plat = ManagerConfigs.getPlatformByIssVersion(String.valueOf(max) + SEPARATOR + min);
                    this.setFdkVersion(fdk);
                    this.setOemVersion(oem);
                    this.setPlatform(plat);
                    return;
                }
                catch (Exception e) {
                    if (e == null || e.getMessage() == null) break block5;
                    err = String.valueOf(err) + e.getMessage().replaceAll("\n  ", "\n    ");
                }
            }
        }
        throw new Exception(err);
    }
}

