/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.model.project;

import com.intel.sensing.fdk.common.exceptions.ISSError;
import com.intel.sensing.fdk.common.log.ISSLogger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public abstract class AValidateStep {
    private ArrayList<ISSError> errors;
    private IResource fRes;
    private String fStepName;
    public static String MARKER_ID = "com.intel.sensing.fdk.core.configureProblem";

    public AValidateStep(IResource res) {
        this.fRes = res;
        this.errors = new ArrayList();
    }

    public AValidateStep(ArrayList<ISSError> errors, IResource res, String name) {
        this(res);
        this.fStepName = name;
    }

    public void execute() {
        this.reset();
        this.run();
    }

    public String getStepName() {
        if (this.fStepName == null) {
            return this.getClass().getName();
        }
        return this.fStepName;
    }

    public IResource getResource() {
        return this.fRes;
    }

    public void reportErrors() {
        this.errors.forEach(err -> {
            try {
                if (this.fRes != null) {
                    IMarker marker = this.fRes.createMarker(MARKER_ID);
                    marker.setAttribute("message", (Object)err.getMessage());
                    marker.setAttribute("severity", err.getSeverity().getMarkerValue());
                    if (err.getLine() > 0) {
                        String lineNR = "line: " + err.getLine() + " ";
                        marker.setAttribute("location", (Object)(String.valueOf(lineNR) + this.fRes.getFullPath().toOSString()));
                    }
                    err.setMarkId(marker.getId());
                }
            }
            catch (CoreException e1) {
                ISSLogger.e((Exception)((Object)e1));
            }
        });
    }

    public void addError(ISSError error) {
        if (error != null && this.fRes != null) {
            try {
                IResource res;
                Object object = res = this.fRes.exists() ? this.fRes : this.fRes.getParent();
                if (res != null && res.exists()) {
                    IMarker marker = res.createMarker(MARKER_ID);
                    marker.setAttribute("message", (Object)error.getMessage());
                    marker.setAttribute("severity", error.getSeverity().getMarkerValue());
                    error.setMarkId(marker.getId());
                    this.errors.add(error);
                }
            }
            catch (CoreException e1) {
                ISSLogger.e((Exception)((Object)e1));
            }
        }
    }

    public void removeError(ISSError error) {
        long id = error.getMarkId();
        try {
            IMarker problem;
            if (this.fRes != null && id > 0L && (problem = this.fRes.findMarker(id)) != null) {
                problem.delete();
            }
        }
        catch (CoreException e) {
            ISSLogger.e((Exception)((Object)e));
        }
        this.errors.remove(error);
    }

    public boolean hasFatalErrors() {
        return this.getFirstFatalError() != null;
    }

    public boolean hasErrors() {
        if (this.errors.isEmpty()) {
            return false;
        }
        boolean hasAny = this.errors.parallelStream().anyMatch(e -> e.getSeverity() == ISSError.Severity.ERROR);
        return hasAny;
    }

    public ISSError getFirstFatalError() {
        ISSError err = this.errors.parallelStream().filter(e -> e.getSeverity() == ISSError.Severity.FATAL).findFirst().orElse(null);
        return err;
    }

    public List<ISSError> getAllIssues() {
        return this.errors;
    }

    public void reset() {
        this.errors.forEach(err -> {
            long id = err.getMarkId();
            try {
                IMarker problem;
                if (this.fRes != null && id > 0L && (problem = this.fRes.getMarker(id)) != null) {
                    problem.delete();
                }
            }
            catch (CoreException e) {
                ISSLogger.e((Exception)((Object)e));
            }
        });
        this.errors.clear();
    }

    public abstract void run();
}

