/*
 * Decompiled with CFR 0.152.
 */
package com.intel.sensing.fdk.model.entity;

import com.intel.sensing.fdk.model.abstractData.Version;
import com.intel.sensing.fdk.model.entity.KitDependencyEntity;
import com.intel.sensing.fdk.model.entity.ModuleEntity;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class FirmwareKit
implements Comparable<FirmwareKit> {
    private String platform;
    private Version version;
    private String path;
    private List<ModuleEntity> moduleList;
    private KitDependencyEntity kitDependency;
    private String flag;
    public static final String FDK = "FDK";
    public static final String USER = "USER";
    public static final String SWAP = "SWAP";

    public FirmwareKit(String path) {
        this.path = path;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public List<ModuleEntity> getModuleList() {
        return this.moduleList;
    }

    public void setModuleList(List<ModuleEntity> moduleList) {
        this.moduleList = moduleList;
    }

    public KitDependencyEntity getKitDependency() {
        return this.kitDependency;
    }

    public void setKitDependency(KitDependencyEntity kitDependency) {
        this.kitDependency = kitDependency;
    }

    public String getPath() {
        return this.path;
    }

    public String getFlag() {
        if (this.flag == null) {
            this.flag = FDK;
        }
        return this.flag;
    }

    public boolean isFDKInstalled() {
        return this.flag.equals(FDK);
    }

    public void setUserInstalled() {
        this.flag = USER;
    }

    public void setSWAPInstalled() {
        this.flag = SWAP;
    }

    public List<String> getProjectDefaultIncludes() {
        ArrayList<String> ret = new ArrayList<String>();
        if (this.kitDependency == null) {
            return ret;
        }
        for (String dep : this.kitDependency.getDependencies()) {
            Path pathDep = Paths.get(dep, new String[0]).normalize();
            ModuleEntity me = this.moduleList.stream().filter(module -> {
                Path pathModule = Paths.get(module.getAbsoluteParentFolderAsStr(), new String[0]).normalize();
                return pathModule.endsWith(pathDep);
            }).findFirst().orElse(null);
            if (me == null || me.getIncludes() == null || me.getIncludes().isEmpty()) continue;
            me.getIncludes().stream().forEach(inc -> ret.add(String.valueOf(me.getAbsoluteParentFolderAsStr()) + File.separator + inc));
        }
        return ret;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof FirmwareKit)) {
            return false;
        }
        FirmwareKit that = (FirmwareKit)o;
        boolean platformEquals = this.platform.equals(that.platform);
        boolean versionEquals = this.version.equals(that.version);
        boolean pathEquals = this.path.equals(that.path);
        return platformEquals && versionEquals && pathEquals;
    }

    @Override
    public int compareTo(FirmwareKit o) {
        int nameCompare = this.getPlatform().compareToIgnoreCase(o.getPlatform());
        if (nameCompare != 0) {
            return nameCompare;
        }
        return this.getVersion().compareTo(o.getVersion());
    }
}

